/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.configuration.internal;

import java.util.List;
import org.hibernate.envers.configuration.internal.metadata.reader.PersistentPropertiesSource;
import org.hibernate.models.internal.ClassTypeDetailsImpl;
import org.hibernate.models.internal.dynamic.DynamicFieldDetails;
import org.hibernate.models.spi.ClassDetails;
import org.hibernate.models.spi.FieldDetails;
import org.hibernate.models.spi.MemberDetails;
import org.hibernate.models.spi.MethodDetails;
import org.hibernate.models.spi.ModelsContext;
import org.hibernate.models.spi.TypeDetails;

public class ModelsHelper {
    public static List<? extends MemberDetails> getMemberDetails(ClassDetails classDetails, String accessType) {
        return switch (accessType) {
            case "field" -> classDetails.getFields();
            case "property" -> classDetails.getMethods();
            case "record" -> classDetails.getRecordComponents();
            default -> throw new IllegalArgumentException("Unknown access type " + accessType);
        };
    }

    public static MemberDetails getMember(ClassDetails classDetails, String name) {
        FieldDetails field = classDetails.findFieldByName(name);
        if (field != null) {
            return field;
        }
        for (MethodDetails method : classDetails.getMethods()) {
            if (!method.resolveAttributeName().equals(name)) continue;
            return method;
        }
        return null;
    }

    public static FieldDetails dynamicFieldDetails(PersistentPropertiesSource propertiesSource, String propertyName, ModelsContext modelsContext) {
        return new DynamicFieldDetails(propertyName, (TypeDetails)new ClassTypeDetailsImpl(propertiesSource.getClassDetails(), TypeDetails.Kind.CLASS), propertiesSource.getClassDetails(), -5337, false, false, modelsContext);
    }
}

