/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.configuration.internal.metadata.reader;

import java.util.Iterator;
import org.hibernate.boot.registry.classloading.spi.ClassLoadingException;
import org.hibernate.envers.boot.EnversMappingException;
import org.hibernate.envers.boot.spi.EnversMetadataBuildingContext;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.models.spi.ClassDetails;

public interface PersistentPropertiesSource {
    public Iterator<Property> getPropertyIterator();

    public Property getProperty(String var1);

    public ClassDetails getClassDetails();

    public boolean isDynamicComponent();

    public boolean hasCompositeUserType();

    public static PersistentPropertiesSource forClass(final PersistentClass persistentClass, final ClassDetails classDetails) {
        return new PersistentPropertiesSource(){

            @Override
            public Iterator<Property> getPropertyIterator() {
                return persistentClass.getProperties().iterator();
            }

            @Override
            public Property getProperty(String propertyName) {
                return persistentClass.getProperty(propertyName);
            }

            @Override
            public ClassDetails getClassDetails() {
                return classDetails;
            }

            @Override
            public boolean isDynamicComponent() {
                return false;
            }

            @Override
            public boolean hasCompositeUserType() {
                return false;
            }
        };
    }

    public static PersistentPropertiesSource forComponent(EnversMetadataBuildingContext context, Component component, boolean dynamic) {
        try {
            ClassDetails classDetails = context.getClassDetailsRegistry().resolveClassDetails(component.getComponentClassName());
            return PersistentPropertiesSource.forComponent(component, classDetails, dynamic);
        }
        catch (ClassLoadingException e) {
            throw new EnversMappingException(e);
        }
    }

    public static PersistentPropertiesSource forComponent(EnversMetadataBuildingContext context, Component component) {
        return PersistentPropertiesSource.forComponent(context, component, false);
    }

    public static PersistentPropertiesSource forComponent(final Component component, final ClassDetails classDetails, final boolean dynamic) {
        return new PersistentPropertiesSource(){

            @Override
            public Iterator<Property> getPropertyIterator() {
                return component.getProperties().iterator();
            }

            @Override
            public Property getProperty(String propertyName) {
                return component.getProperty(propertyName);
            }

            @Override
            public ClassDetails getClassDetails() {
                return classDetails;
            }

            @Override
            public boolean isDynamicComponent() {
                return dynamic;
            }

            @Override
            public boolean hasCompositeUserType() {
                return component.getTypeName() != null;
            }
        };
    }
}

