/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.boot.model;

import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmEntityDiscriminatorType;
import org.hibernate.envers.boot.model.Bindable;
import org.hibernate.envers.boot.model.Column;
import org.hibernate.envers.boot.model.Formula;
import org.hibernate.mapping.Selectable;
import org.hibernate.mapping.Value;

public class DiscriminatorType
implements Bindable<JaxbHbmEntityDiscriminatorType> {
    private final Value discriminator;

    public DiscriminatorType(Value discriminator) {
        this.discriminator = discriminator;
    }

    @Override
    public JaxbHbmEntityDiscriminatorType build() {
        JaxbHbmEntityDiscriminatorType mapping = new JaxbHbmEntityDiscriminatorType();
        mapping.setType(this.discriminator.getType().getName());
        for (Selectable selectable : this.discriminator.getSelectables()) {
            if (selectable.isFormula()) {
                mapping.setFormula(Formula.from(selectable).build());
                continue;
            }
            mapping.setColumn(Column.from(selectable).build());
        }
        return mapping;
    }
}

