/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.internal.tools.query;

import jakarta.persistence.criteria.JoinType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.envers.RevisionType;
import org.hibernate.envers.boot.internal.EnversService;
import org.hibernate.envers.configuration.Configuration;
import org.hibernate.envers.internal.entities.RevisionTypeType;
import org.hibernate.envers.internal.entities.mapper.id.QueryParameterData;
import org.hibernate.envers.internal.tools.MutableInteger;
import org.hibernate.envers.internal.tools.StringTools;
import org.hibernate.envers.internal.tools.query.Parameters;
import org.hibernate.envers.query.criteria.AuditFunction;
import org.hibernate.envers.query.criteria.AuditId;
import org.hibernate.envers.query.criteria.AuditProperty;
import org.hibernate.envers.query.criteria.internal.CriteriaTools;
import org.hibernate.envers.query.order.NullPrecedence;
import org.hibernate.envers.tools.Pair;
import org.hibernate.query.Query;
import org.hibernate.query.internal.QueryLiteralHelper;
import org.hibernate.type.BasicType;

public class QueryBuilder {
    private final String entityName;
    private final String alias;
    private final MutableInteger aliasCounter;
    private final MutableInteger paramCounter;
    private final List<Parameters> parameters = new ArrayList<Parameters>();
    private final List<JoinParameter> froms;
    private final List<OrderByClause> orders;
    private final List<String> projections;
    private final Map<String, Object> projectionQueryParamValues;
    private final List<Pair<String, String>> orderFragments;
    private final SessionFactoryImplementor sessionFactory;
    private final BasicType<?> revisionType;

    public QueryBuilder(String entityName, String alias, SessionFactoryImplementor sessionFactory) {
        this(entityName, alias, new MutableInteger(), new MutableInteger(), sessionFactory);
    }

    private QueryBuilder(String entityName, String alias, MutableInteger aliasCounter, MutableInteger paramCounter, SessionFactoryImplementor sessionFactory) {
        this.entityName = entityName;
        this.alias = alias;
        this.aliasCounter = aliasCounter;
        this.paramCounter = paramCounter;
        this.sessionFactory = sessionFactory;
        this.revisionType = sessionFactory.getTypeConfiguration().getBasicTypeRegistry().getRegisteredType(RevisionTypeType.class);
        Parameters rootParameters = new Parameters(alias, "and", paramCounter);
        this.parameters.add(rootParameters);
        this.froms = new ArrayList<JoinParameter>();
        this.orders = new ArrayList<OrderByClause>();
        this.projections = new ArrayList<String>();
        this.projectionQueryParamValues = new HashMap<String, Object>();
        this.orderFragments = new ArrayList<Pair<String, String>>();
        this.addFrom(entityName, alias, true);
    }

    private QueryBuilder(QueryBuilder other) {
        this.entityName = other.entityName;
        this.alias = other.alias;
        this.sessionFactory = other.sessionFactory;
        this.revisionType = other.revisionType;
        this.aliasCounter = other.aliasCounter.deepCopy();
        this.paramCounter = other.paramCounter.deepCopy();
        for (Parameters params : other.parameters) {
            this.parameters.add(params.deepCopy());
        }
        this.froms = new ArrayList<JoinParameter>(other.froms);
        this.orders = new ArrayList<OrderByClause>(other.orders);
        this.projections = new ArrayList<String>(other.projections);
        this.projectionQueryParamValues = new HashMap<String, Object>(other.projectionQueryParamValues);
        this.orderFragments = new ArrayList<Pair<String, String>>(other.orderFragments);
    }

    public QueryBuilder deepCopy() {
        return new QueryBuilder(this);
    }

    public String getAlias() {
        return this.alias;
    }

    public void addFrom(String entityName, String alias, boolean select) {
        CrossJoinParameter joinParameter = new CrossJoinParameter(entityName, alias, select);
        this.froms.add(joinParameter);
    }

    public Parameters addJoin(JoinType joinType, String entityName, String alias, boolean select) {
        Parameters joinConditionParameters = new Parameters(alias, "and", this.paramCounter);
        InnerOuterJoinParameter joinParameter = new InnerOuterJoinParameter(joinType, entityName, alias, select, joinConditionParameters);
        this.froms.add(joinParameter);
        return joinConditionParameters;
    }

    public String generateAlias() {
        return "_e" + this.aliasCounter.getAndIncrease();
    }

    public QueryBuilder newSubQueryBuilder(String entityName, String alias) {
        return new QueryBuilder(entityName, alias, this.aliasCounter, this.paramCounter, this.sessionFactory);
    }

    public Parameters getRootParameters() {
        return this.parameters.get(0);
    }

    public Parameters addParameters(String alias) {
        Parameters result = new Parameters(alias, "and", this.paramCounter);
        this.parameters.add(result);
        return result;
    }

    public void addOrder(String alias, String propertyName, boolean ascending, NullPrecedence nullPrecedence) {
        this.orders.add(new OrderByClause(alias, propertyName, ascending, nullPrecedence));
    }

    public void addOrderFragment(String alias, String orderByCollectionRole) {
        this.orderFragments.add(Pair.make(alias, orderByCollectionRole));
    }

    public void addProjection(String function, String alias, String propertyName, boolean distinct) {
        String effectivePropertyName;
        String string = effectivePropertyName = propertyName == null ? "" : ".".concat(propertyName);
        if (function == null) {
            this.projections.add((distinct ? "distinct " : "") + alias + effectivePropertyName);
        } else {
            this.projections.add(function + "(" + (distinct ? "distinct " : "") + alias + effectivePropertyName + ")");
        }
    }

    public void addProjection(Configuration configuration, Map<String, String> aliasToEntityNameMap, Map<String, String> aliasToComponentPropertyNameMap, AuditFunction function) {
        StringBuilder expression = new StringBuilder();
        QueryBuilder.appendFunctionArgument(configuration, aliasToEntityNameMap, aliasToComponentPropertyNameMap, this.paramCounter, this.projectionQueryParamValues, this.alias, expression, function);
        this.projections.add(expression.toString());
    }

    protected static void appendFunctionArgument(Configuration configuration, Map<String, String> aliasToEntityNameMap, Map<String, String> aliasToComponentPropertyNameMap, MutableInteger paramCounter, Map<String, Object> queryParamValues, String alias, StringBuilder expression, Object argument) {
        if (argument instanceof AuditFunction) {
            AuditFunction function = (AuditFunction)argument;
            expression.append(function.getFunction()).append('(');
            boolean first = true;
            for (Object innerArg : function.getArguments()) {
                if (!first) {
                    expression.append(',');
                }
                QueryBuilder.appendFunctionArgument(configuration, aliasToEntityNameMap, aliasToComponentPropertyNameMap, paramCounter, queryParamValues, alias, expression, innerArg);
                first = false;
            }
            expression.append(')');
        } else if (argument instanceof AuditId) {
            AuditId id = (AuditId)argument;
            String prefix = configuration.getOriginalIdPropertyName();
            String idAlias = id.getAlias(alias);
            String entityName = aliasToEntityNameMap.get(idAlias);
            EnversService enversService = configuration.getEnversService();
            List<QueryParameterData> parameters = enversService.getEntitiesConfigurations().get(entityName).getIdMapper().mapToQueryParametersFromId(null);
            if (parameters.size() != 1) {
                throw new HibernateException("Cannot add id property as function argument when id property is not a single column property");
            }
            String propertyName = parameters.get(0).getProperty(prefix);
            if (idAlias != null) {
                expression.append(idAlias).append('.');
            }
            expression.append(propertyName);
        } else if (argument instanceof AuditProperty) {
            AuditProperty property = (AuditProperty)argument;
            String propertyAlias = property.getAlias(alias);
            if (propertyAlias != null) {
                expression.append(propertyAlias).append('.');
            }
            String propertyPrefix = CriteriaTools.determineComponentPropertyPrefix(configuration.getEnversService(), aliasToEntityNameMap, aliasToComponentPropertyNameMap, propertyAlias);
            String propertyName = property.getPropertyNameGetter().get(configuration);
            expression.append(propertyPrefix.concat(propertyName));
        } else {
            String queryParam = "_p" + paramCounter.getAndIncrease();
            queryParamValues.put(queryParam, argument);
            expression.append(':').append(queryParam);
        }
    }

    public void build(StringBuilder sb, Map<String, Object> queryParamValues) {
        sb.append("select ");
        if (this.projections.size() > 0) {
            StringTools.append(sb, this.projections.iterator(), ", ");
        } else {
            StringTools.append(sb, this.getSelectAliasList().iterator(), ", ");
        }
        queryParamValues.putAll(this.projectionQueryParamValues);
        sb.append(" from ");
        boolean first = true;
        for (JoinParameter joinParameter : this.froms) {
            joinParameter.appendJoin(first, sb, queryParamValues);
            first = false;
        }
        first = true;
        for (Parameters params : this.parameters) {
            if (params.isEmpty()) continue;
            if (first) {
                sb.append(" where ");
                first = false;
            } else {
                sb.append(" and ");
            }
            params.build(sb, queryParamValues);
        }
        if (!this.orders.isEmpty()) {
            sb.append(" order by ");
            StringTools.append(sb, this.getOrderList().iterator(), ", ");
        } else if (!this.orderFragments.isEmpty()) {
            sb.append(" order by ");
            Iterator<Pair<String, String>> fragmentIterator = this.orderFragments.iterator();
            while (fragmentIterator.hasNext()) {
                Pair<String, String> fragment = fragmentIterator.next();
                sb.append("_order_by_frag").append('(');
                QueryLiteralHelper.appendStringLiteral((StringBuilder)sb, (String)fragment.getFirst());
                sb.append(", ");
                QueryLiteralHelper.appendStringLiteral((StringBuilder)sb, (String)fragment.getSecond());
                sb.append(')');
                if (!fragmentIterator.hasNext()) continue;
                sb.append(", ");
            }
        }
    }

    private List<String> getSelectAliasList() {
        ArrayList<String> aliasList = new ArrayList<String>();
        for (JoinParameter from : this.froms) {
            if (!from.isSelect()) continue;
            aliasList.add(from.getAlias());
        }
        return aliasList;
    }

    public String getRootAlias() {
        return this.alias;
    }

    private List<String> getOrderList() {
        ArrayList<String> orderList = new ArrayList<String>();
        for (OrderByClause orderByClause : this.orders) {
            orderList.add(orderByClause.renderToHql());
        }
        return orderList;
    }

    public Query toQuery(Session session) {
        StringBuilder querySb = new StringBuilder();
        HashMap<String, Object> queryParamValues = new HashMap<String, Object>();
        this.build(querySb, queryParamValues);
        Query query = session.createQuery(querySb.toString());
        for (Map.Entry paramValue : queryParamValues.entrySet()) {
            if (paramValue.getValue() instanceof RevisionType) {
                query.setParameter((String)paramValue.getKey(), paramValue.getValue(), this.revisionType);
                continue;
            }
            query.setParameter((String)paramValue.getKey(), paramValue.getValue());
        }
        return query;
    }

    private static class CrossJoinParameter
    extends JoinParameter {
        private final String entityName;

        public CrossJoinParameter(String entityName, String alias, boolean select) {
            super(alias, select);
            this.entityName = entityName;
        }

        @Override
        public void appendJoin(boolean firstFromElement, StringBuilder builder, Map<String, Object> queryParamValues) {
            if (!firstFromElement) {
                builder.append(", ");
            }
            builder.append(this.entityName).append(' ').append(this.getAlias());
        }
    }

    private static class InnerOuterJoinParameter
    extends JoinParameter {
        private final JoinType joinType;
        private final String entityName;
        private final Parameters joinConditionParameters;

        public InnerOuterJoinParameter(JoinType joinType, String entityName, String alias, boolean select, Parameters joinConditionParameters) {
            super(alias, select);
            this.joinType = joinType;
            this.entityName = entityName;
            this.joinConditionParameters = joinConditionParameters;
        }

        @Override
        public void appendJoin(boolean firstFromElement, StringBuilder builder, Map<String, Object> queryParamValues) {
            if (firstFromElement) {
                throw new IllegalArgumentException("An inner/outer join cannot come as first 'from element'");
            }
            builder.append(' ').append(this.joinType.name().toLowerCase(Locale.US)).append(" join ").append(this.entityName).append(' ').append(this.getAlias()).append(" on ");
            this.joinConditionParameters.build(builder, queryParamValues);
        }
    }

    private static class OrderByClause {
        private String alias;
        private String propertyName;
        private boolean ascending;
        private NullPrecedence nullPrecedence;

        public OrderByClause(String alias, String propertyName, boolean ascending, NullPrecedence nullPrecedence) {
            this.alias = alias;
            this.propertyName = propertyName;
            this.ascending = ascending;
            this.nullPrecedence = nullPrecedence;
        }

        public String renderToHql() {
            StringBuilder hql = new StringBuilder();
            hql.append(this.alias).append(".").append(this.propertyName).append(" ");
            hql.append(this.ascending ? "asc" : "desc");
            if (this.nullPrecedence != null) {
                if (NullPrecedence.FIRST.equals((Object)this.nullPrecedence)) {
                    hql.append(" nulls first");
                } else {
                    hql.append(" nulls last");
                }
            }
            return hql.toString();
        }
    }

    private static abstract class JoinParameter {
        private final String alias;
        private final boolean select;

        protected JoinParameter(String alias, boolean select) {
            this.alias = alias;
            this.select = select;
        }

        public String getAlias() {
            return this.alias;
        }

        public boolean isSelect() {
            return this.select;
        }

        public abstract void appendJoin(boolean var1, StringBuilder var2, Map<String, Object> var3);
    }
}

