/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.event.spi;

import org.hibernate.bytecode.enhance.spi.LazyPropertyInitializer;
import org.hibernate.bytecode.enhance.spi.interceptor.LazyAttributeLoadingInterceptor;
import org.hibernate.bytecode.spi.BytecodeEnhancementMetadata;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.envers.boot.internal.EnversService;
import org.hibernate.envers.event.spi.BaseEnversUpdateEventListener;
import org.hibernate.envers.internal.synchronization.AuditProcess;
import org.hibernate.envers.internal.synchronization.work.ModWorkUnit;
import org.hibernate.event.spi.PostUpdateEvent;
import org.hibernate.event.spi.PostUpdateEventListener;
import org.hibernate.persister.entity.EntityPersister;

public class EnversPostUpdateEventListenerImpl
extends BaseEnversUpdateEventListener
implements PostUpdateEventListener {
    public EnversPostUpdateEventListenerImpl(EnversService enversService) {
        super(enversService);
    }

    public void onPostUpdate(PostUpdateEvent event) {
        String entityName = event.getPersister().getEntityName();
        if (this.getEnversService().getEntitiesConfigurations().isVersioned(entityName)) {
            this.checkIfTransactionInProgress((SessionImplementor)event.getSession());
            AuditProcess auditProcess = this.getEnversService().getAuditProcessManager().get(event.getSession());
            Object[] oldState = this.getOldDBState(auditProcess, entityName, event);
            Object[] newDbState = this.postUpdateDBState(event);
            ModWorkUnit workUnit = new ModWorkUnit((SessionImplementor)event.getSession(), event.getPersister().getEntityName(), this.getEnversService(), event.getId(), event.getPersister(), newDbState, oldState);
            auditProcess.addWorkUnit(workUnit);
            if (workUnit.containsWork()) {
                this.generateBidirectionalCollectionChangeWorkUnits(auditProcess, event.getPersister(), entityName, newDbState, oldState, (SessionImplementor)event.getSession());
            }
        }
    }

    private Object[] getOldDBState(AuditProcess auditProcess, String entityName, PostUpdateEvent event) {
        if (this.isDetachedEntityUpdate(entityName, event.getOldState())) {
            return auditProcess.getCachedEntityState(event.getId(), entityName);
        }
        return event.getOldState();
    }

    private Object[] postUpdateDBState(PostUpdateEvent event) {
        Object[] newDbState = (Object[])event.getState().clone();
        if (event.getOldState() != null) {
            EntityPersister entityPersister = event.getPersister();
            Object entity = event.getEntity();
            BytecodeEnhancementMetadata instrumentationMetadata = entityPersister.getInstrumentationMetadata();
            LazyAttributeLoadingInterceptor lazyAttributeLoadingInterceptor = instrumentationMetadata.isEnhancedForLazyLoading() ? instrumentationMetadata.extractInterceptor(entity) : null;
            for (int i = 0; i < entityPersister.getPropertyNames().length; ++i) {
                if (!entityPersister.getPropertyUpdateability()[i]) {
                    newDbState[i] = event.getOldState()[i];
                }
                if (newDbState[i] != LazyPropertyInitializer.UNFETCHED_PROPERTY) continue;
                assert (lazyAttributeLoadingInterceptor != null) : "Entity:`" + entityPersister.getEntityName() + "` with uninitialized property:` " + entityPersister.getPropertyNames()[i] + "` hasn't an associated LazyAttributeLoadingInterceptor";
                event.getOldState()[i] = newDbState[i] = lazyAttributeLoadingInterceptor.fetchAttribute(entity, entityPersister.getPropertyNames()[i]);
            }
        }
        return newDbState;
    }

    public boolean requiresPostCommitHandling(EntityPersister persister) {
        return this.getEnversService().getEntitiesConfigurations().isVersioned(persister.getEntityName());
    }
}

