/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.function;

import java.util.List;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.metamodel.mapping.ordering.OrderByFragment;
import org.hibernate.persister.collection.QueryableCollection;
import org.hibernate.persister.entity.Joinable;
import org.hibernate.query.ReturnableType;
import org.hibernate.query.spi.NavigablePath;
import org.hibernate.query.spi.QueryEngine;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.function.AbstractSqmFunctionDescriptor;
import org.hibernate.query.sqm.function.SelfRenderingFunctionSqlAstExpression;
import org.hibernate.query.sqm.function.SelfRenderingSqmFunction;
import org.hibernate.query.sqm.function.SqmFunctionDescriptor;
import org.hibernate.query.sqm.produce.function.StandardArgumentsValidators;
import org.hibernate.query.sqm.produce.function.StandardFunctionReturnTypeResolvers;
import org.hibernate.query.sqm.sql.FromClauseIndex;
import org.hibernate.query.sqm.sql.SqmToSqlAstConverter;
import org.hibernate.query.sqm.tree.SqmTypedNode;
import org.hibernate.query.sqm.tree.expression.SqmLiteral;
import org.hibernate.sql.ast.spi.SqlAstCreationState;
import org.hibernate.sql.ast.spi.SqlAstQueryPartProcessingState;
import org.hibernate.sql.ast.tree.from.DelegatingTableGroup;
import org.hibernate.sql.ast.tree.from.NamedTableReference;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.select.QuerySpec;
import org.hibernate.type.spi.TypeConfiguration;

public class OrderByFragmentFunction
extends AbstractSqmFunctionDescriptor {
    public static final String FUNCTION_NAME = "_order_by_frag";
    public static final OrderByFragmentFunction INSTANCE = new OrderByFragmentFunction();

    public OrderByFragmentFunction() {
        super(FUNCTION_NAME, StandardArgumentsValidators.exactly((int)2), StandardFunctionReturnTypeResolvers.useArgType((int)1));
    }

    protected <T> SelfRenderingSqmFunction<T> generateSqmFunctionExpression(List<? extends SqmTypedNode<?>> arguments, ReturnableType<T> impliedResultType, QueryEngine queryEngine, TypeConfiguration typeConfiguration) {
        return new SelfRenderingSqmFunction<T>((SqmFunctionDescriptor)this, null, arguments, impliedResultType, this.getArgumentsValidator(), this.getReturnTypeResolver(), (NodeBuilder)queryEngine.getCriteriaBuilder(), this.getName()){

            public SelfRenderingFunctionSqlAstExpression convertToSqlAst(SqmToSqlAstConverter walker) {
                ReturnableType resultType = this.resolveResultType(walker.getCreationContext().getMappingMetamodel().getTypeConfiguration());
                String sqmAlias = (String)((SqmLiteral)this.getArguments().get(0)).getLiteralValue();
                String attributeRole = (String)((SqmLiteral)this.getArguments().get(1)).getLiteralValue();
                TableGroup tableGroup = ((FromClauseIndex)walker.getFromClauseAccess()).findTableGroup(sqmAlias);
                QueryableCollection collectionDescriptor = (QueryableCollection)walker.getCreationContext().getSessionFactory().getRuntimeMetamodels().getMappingMetamodel().findCollectionDescriptor(attributeRole);
                PluralAttributeMapping pluralAttribute = collectionDescriptor.getAttributeMapping();
                QuerySpec queryPart = (QuerySpec)((SqlAstQueryPartProcessingState)walker.getCurrentProcessingState()).getInflightQueryPart();
                OrderByFragment fragment = pluralAttribute.getOrderByFragment() != null ? pluralAttribute.getOrderByFragment() : pluralAttribute.getManyToManyOrderByFragment();
                String targetTableExpression = collectionDescriptor.getElementPersister() == null ? collectionDescriptor.getTableName() : ((Joinable)collectionDescriptor.getElementPersister()).getTableName();
                fragment.apply(queryPart, (TableGroup)new AuditingTableGroup(tableGroup, targetTableExpression), (SqlAstCreationState)walker);
                return null;
            }
        };
    }

    private static class AuditingTableGroup
    extends DelegatingTableGroup {
        private final TableGroup delegate;
        private final String auditTableExpression;
        private final String normalTableExpression;

        public AuditingTableGroup(TableGroup delegate, String normalTableExpression) {
            this.delegate = delegate;
            this.auditTableExpression = ((NamedTableReference)delegate.getPrimaryTableReference()).getTableExpression();
            this.normalTableExpression = normalTableExpression;
        }

        protected TableGroup getTableGroup() {
            return this.delegate;
        }

        public TableReference resolveTableReference(NavigablePath navigablePath, String tableExpression, boolean allowFkOptimization) {
            if (tableExpression.equals(this.normalTableExpression)) {
                tableExpression = this.auditTableExpression;
            }
            return super.resolveTableReference(navigablePath, tableExpression, allowFkOptimization);
        }

        public TableReference getTableReference(NavigablePath navigablePath, String tableExpression, boolean allowFkOptimization, boolean resolve) {
            if (tableExpression.equals(this.normalTableExpression)) {
                tableExpression = this.auditTableExpression;
            }
            return super.getTableReference(navigablePath, tableExpression, allowFkOptimization, resolve);
        }
    }
}

