/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.configuration.internal.metadata.reader;

import jakarta.persistence.EnumType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.hibernate.envers.AuditOverride;
import org.hibernate.envers.AuditOverrides;
import org.hibernate.envers.CollectionAuditTable;
import org.hibernate.envers.RelationTargetAuditMode;
import org.hibernate.envers.RelationTargetNotFoundAction;
import org.hibernate.envers.configuration.internal.metadata.reader.AuditJoinTableData;
import org.hibernate.envers.configuration.internal.metadata.reader.AuditOverrideData;
import org.hibernate.envers.internal.entities.PropertyData;
import org.hibernate.envers.internal.tools.StringTools;
import org.hibernate.mapping.Value;
import org.hibernate.type.Type;

public class PropertyAuditingData {
    private String name;
    private String beanName;
    private String mapKey;
    private EnumType mapKeyEnumType;
    private CollectionAuditTable collectionAuditTable;
    private AuditJoinTableData joinTable;
    private String accessType;
    private final List<AuditOverrideData> auditJoinTableOverrides = new ArrayList<AuditOverrideData>(0);
    private RelationTargetAuditMode relationTargetAuditMode;
    private RelationTargetNotFoundAction relationTargetNotFoundAction;
    private String auditMappedBy;
    private String relationMappedBy;
    private String positionMappedBy;
    private boolean forceInsertable;
    private boolean usingModifiedFlag;
    private String modifiedFlagName;
    private String explicitModifiedFlagName;
    private Value value;
    private Type propertyType;
    private Type virtualPropertyType;
    private boolean synthetic;

    public PropertyAuditingData() {
    }

    public PropertyAuditingData(String name, String accessType, boolean forceInsertable) {
        this(name, accessType, RelationTargetAuditMode.AUDITED, RelationTargetNotFoundAction.DEFAULT, null, null, forceInsertable, false, null);
    }

    public PropertyAuditingData(String name, String accessType, RelationTargetNotFoundAction relationTargetNotFoundAction, boolean forceInsertable, boolean synthetic, Value value) {
        this(name, accessType, RelationTargetAuditMode.AUDITED, relationTargetNotFoundAction, null, null, forceInsertable, synthetic, value);
    }

    public PropertyAuditingData(String name, String accessType, RelationTargetAuditMode relationTargetAuditMode, RelationTargetNotFoundAction relationTargetNotFoundAction, String auditMappedBy, String positionMappedBy, boolean forceInsertable, boolean synthetic, Value value) {
        this.name = name;
        this.beanName = name;
        this.accessType = accessType;
        this.relationTargetAuditMode = relationTargetAuditMode;
        this.relationTargetNotFoundAction = relationTargetNotFoundAction;
        this.auditMappedBy = auditMappedBy;
        this.positionMappedBy = positionMappedBy;
        this.forceInsertable = forceInsertable;
        this.synthetic = synthetic;
        this.value = value;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getBeanName() {
        return this.beanName;
    }

    public void setBeanName(String beanName) {
        this.beanName = beanName;
    }

    public String getMapKey() {
        return this.mapKey;
    }

    public void setMapKey(String mapKey) {
        this.mapKey = mapKey;
    }

    public EnumType getMapKeyEnumType() {
        return this.mapKeyEnumType;
    }

    public void setMapKeyEnumType(EnumType mapKeyEnumType) {
        this.mapKeyEnumType = mapKeyEnumType;
    }

    public AuditJoinTableData getJoinTable() {
        return this.joinTable;
    }

    public void setJoinTable(AuditJoinTableData joinTable) {
        this.joinTable = joinTable;
    }

    public String getAccessType() {
        return this.accessType;
    }

    public void setAccessType(String accessType) {
        this.accessType = accessType;
    }

    public List<AuditOverrideData> getAuditingOverrides() {
        return Collections.unmodifiableList(this.auditJoinTableOverrides);
    }

    public String getAuditMappedBy() {
        return this.auditMappedBy;
    }

    public boolean hasAuditedMappedBy() {
        return this.auditMappedBy != null;
    }

    public void setAuditMappedBy(String auditMappedBy) {
        this.auditMappedBy = auditMappedBy;
    }

    public String getRelationMappedBy() {
        return this.relationMappedBy;
    }

    public boolean hasRelationMappedBy() {
        return this.relationMappedBy != null;
    }

    public void setRelationMappedBy(String relationMappedBy) {
        this.relationMappedBy = relationMappedBy;
    }

    public String getPositionMappedBy() {
        return this.positionMappedBy;
    }

    public void setPositionMappedBy(String positionMappedBy) {
        this.positionMappedBy = positionMappedBy;
    }

    public boolean isForceInsertable() {
        return this.forceInsertable;
    }

    public void setForceInsertable(boolean forceInsertable) {
        this.forceInsertable = forceInsertable;
    }

    public boolean isUsingModifiedFlag() {
        return this.usingModifiedFlag;
    }

    public void setUsingModifiedFlag(boolean usingModifiedFlag) {
        this.usingModifiedFlag = usingModifiedFlag;
    }

    public String getModifiedFlagName() {
        return this.modifiedFlagName;
    }

    public void setModifiedFlagName(String modifiedFlagName) {
        this.modifiedFlagName = modifiedFlagName;
    }

    public boolean isModifiedFlagNameExplicitlySpecified() {
        return !StringTools.isEmpty(this.explicitModifiedFlagName);
    }

    public String getExplicitModifiedFlagName() {
        return this.explicitModifiedFlagName;
    }

    public void setExplicitModifiedFlagName(String modifiedFlagName) {
        this.explicitModifiedFlagName = modifiedFlagName;
    }

    public void addAuditingOverride(AuditOverride annotation) {
        if (annotation != null) {
            String overrideName = annotation.name();
            boolean present = false;
            for (AuditOverrideData current : this.auditJoinTableOverrides) {
                if (!current.getName().equals(overrideName)) continue;
                present = true;
                break;
            }
            if (!present) {
                this.auditJoinTableOverrides.add(new AuditOverrideData(annotation));
            }
        }
    }

    public void addAuditingOverrides(AuditOverrides annotationOverrides) {
        if (annotationOverrides != null) {
            for (AuditOverride annotation : annotationOverrides.value()) {
                this.addAuditingOverride(annotation);
            }
        }
    }

    public RelationTargetAuditMode getRelationTargetAuditMode() {
        return this.relationTargetAuditMode;
    }

    public void setRelationTargetAuditMode(RelationTargetAuditMode relationTargetAuditMode) {
        this.relationTargetAuditMode = relationTargetAuditMode;
    }

    public RelationTargetNotFoundAction getRelationTargetNotFoundAction() {
        return this.relationTargetNotFoundAction;
    }

    public void setRelationTargetNotFoundAction(RelationTargetNotFoundAction relationTargetNotFoundAction) {
        this.relationTargetNotFoundAction = relationTargetNotFoundAction;
    }

    public boolean isSynthetic() {
        return this.synthetic;
    }

    public Value getValue() {
        return this.value;
    }

    public void setValue(Value value) {
        this.value = value;
    }

    public Type getPropertyType() {
        return this.propertyType;
    }

    public void setPropertyType(Type propertyType) {
        this.propertyType = propertyType;
    }

    public Type getVirtualPropertyType() {
        return this.virtualPropertyType;
    }

    public void setVirtualPropertyType(Type virtualPropertyType) {
        this.virtualPropertyType = virtualPropertyType;
    }

    public CollectionAuditTable getCollectionAuditTable() {
        return this.collectionAuditTable;
    }

    public void setCollectionAuditTable(CollectionAuditTable collectionAuditTable) {
        this.collectionAuditTable = collectionAuditTable;
    }

    public PropertyData resolvePropertyData() {
        if (this.propertyType != null && this.virtualPropertyType != null) {
            return new PropertyData(this.name, this.beanName, this.accessType, this.usingModifiedFlag, this.modifiedFlagName, this.synthetic, this.propertyType, this.virtualPropertyType.getReturnedClass());
        }
        if (this.propertyType != null) {
            return new PropertyData(this.name, this.beanName, this.accessType, this.usingModifiedFlag, this.modifiedFlagName, this.synthetic, this.propertyType);
        }
        return new PropertyData(this.name, this.beanName, this.accessType, this.usingModifiedFlag, this.modifiedFlagName, this.synthetic, null);
    }
}

