/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.configuration.internal.metadata;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import org.hibernate.envers.AuditTable;
import org.hibernate.envers.boot.EnversMappingException;
import org.hibernate.envers.boot.model.AttributeContainer;
import org.hibernate.envers.boot.model.Column;
import org.hibernate.envers.boot.model.JoinAwarePersistentEntity;
import org.hibernate.envers.boot.model.PersistentEntity;
import org.hibernate.envers.boot.model.RootPersistentEntity;
import org.hibernate.envers.boot.spi.EnversMetadataBuildingContext;
import org.hibernate.envers.configuration.Configuration;
import org.hibernate.envers.configuration.internal.metadata.AbstractMetadataGenerator;
import org.hibernate.envers.configuration.internal.metadata.AuditTableData;
import org.hibernate.envers.configuration.internal.metadata.BasicMetadataGenerator;
import org.hibernate.envers.configuration.internal.metadata.EntityMappingData;
import org.hibernate.envers.configuration.internal.metadata.IdMetadataGenerator;
import org.hibernate.envers.configuration.internal.metadata.InheritanceType;
import org.hibernate.envers.configuration.internal.metadata.PersistentEntityInstantiator;
import org.hibernate.envers.configuration.internal.metadata.ValueMetadataGenerator;
import org.hibernate.envers.configuration.internal.metadata.reader.ClassAuditingData;
import org.hibernate.envers.configuration.internal.metadata.reader.PropertyAuditingData;
import org.hibernate.envers.internal.EnversMessageLogger;
import org.hibernate.envers.internal.entities.EntityConfiguration;
import org.hibernate.envers.internal.entities.IdMappingData;
import org.hibernate.envers.internal.entities.mapper.AbstractPropertyMapper;
import org.hibernate.envers.internal.entities.mapper.CompositeMapperBuilder;
import org.hibernate.envers.internal.entities.mapper.ExtendedPropertyMapper;
import org.hibernate.envers.internal.entities.mapper.MultiPropertyMapper;
import org.hibernate.envers.internal.entities.mapper.SubclassPropertyMapper;
import org.hibernate.mapping.Join;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.SyntheticProperty;
import org.hibernate.mapping.Value;
import org.hibernate.tuple.GeneratedValueGeneration;
import org.hibernate.tuple.GenerationTiming;
import org.hibernate.tuple.ValueGeneration;
import org.jboss.logging.Logger;

public final class AuditMetadataGenerator
extends AbstractMetadataGenerator {
    private static final EnversMessageLogger LOG = (EnversMessageLogger)Logger.getMessageLogger(EnversMessageLogger.class, (String)AuditMetadataGenerator.class.getName());
    private final EnversMetadataBuildingContext metadataBuildingContext;
    private final Configuration configuration;
    private final PersistentEntityInstantiator entityInstantiator;
    private final IdMetadataGenerator idMetadataGenerator;
    private final ValueMetadataGenerator valueMetadataGenerator;
    private final Map<String, Map<Join, org.hibernate.envers.boot.model.Join>> entityJoins;

    public AuditMetadataGenerator(EnversMetadataBuildingContext metadataBuildingContext) {
        super(metadataBuildingContext);
        this.metadataBuildingContext = metadataBuildingContext;
        this.configuration = metadataBuildingContext.getConfiguration();
        BasicMetadataGenerator basicMetadataGenerator = new BasicMetadataGenerator();
        this.idMetadataGenerator = new IdMetadataGenerator(metadataBuildingContext, basicMetadataGenerator);
        this.valueMetadataGenerator = new ValueMetadataGenerator(metadataBuildingContext, basicMetadataGenerator);
        this.entityInstantiator = new PersistentEntityInstantiator(this.configuration);
        this.entityJoins = new HashMap<String, Map<Join, org.hibernate.envers.boot.model.Join>>();
    }

    private void addProperties(AttributeContainer attributeContainer, Iterator<Property> properties, CompositeMapperBuilder currentMapper, ClassAuditingData auditingData, String entityName, EntityMappingData mappingData, boolean firstPass) {
        while (properties.hasNext()) {
            Property property = properties.next();
            String propertyName = property.getName();
            PropertyAuditingData propertyAuditingData = auditingData.getPropertyAuditingData(propertyName);
            if (propertyAuditingData == null || property instanceof SyntheticProperty && property.getValue().isAlternateUniqueKey()) continue;
            this.valueMetadataGenerator.addValue(attributeContainer, property.getValue(), currentMapper, entityName, mappingData, propertyAuditingData, this.isPropertyInsertable(property), firstPass, true);
        }
    }

    private boolean isPropertyInsertable(Property property) {
        GeneratedValueGeneration valueGeneration;
        ValueGeneration generation;
        if (!property.isInsertable() && (generation = property.getValueGenerationStrategy()) instanceof GeneratedValueGeneration && (GenerationTiming.INSERT == (valueGeneration = (GeneratedValueGeneration)generation).getGenerationTiming() || GenerationTiming.ALWAYS == valueGeneration.getGenerationTiming())) {
            return true;
        }
        return property.isInsertable();
    }

    private boolean checkPropertiesAudited(Iterator<Property> properties, ClassAuditingData auditingData) {
        while (properties.hasNext()) {
            Property property = properties.next();
            String propertyName = property.getName();
            PropertyAuditingData propertyAuditingData = auditingData.getPropertyAuditingData(propertyName);
            if (propertyAuditingData != null) continue;
            return false;
        }
        return true;
    }

    private void createJoins(PersistentClass persistentClass, JoinAwarePersistentEntity entity, ClassAuditingData auditingData) {
        Iterator joins = persistentClass.getJoinIterator();
        HashMap<Join, org.hibernate.envers.boot.model.Join> joinElements = new HashMap<Join, org.hibernate.envers.boot.model.Join>();
        this.entityJoins.put(persistentClass.getEntityName(), joinElements);
        while (joins.hasNext()) {
            Join join = (Join)joins.next();
            if (!this.checkPropertiesAudited(join.getPropertyIterator(), auditingData)) continue;
            String originalTableName = join.getTable().getName();
            String auditTableName = auditingData.getSecondaryTableDictionary().get(originalTableName);
            if (auditTableName == null) {
                auditTableName = this.configuration.getAuditEntityName(originalTableName);
            }
            AuditTable auditTable = auditingData.getAuditTable();
            org.hibernate.envers.boot.model.Join joinElement = new org.hibernate.envers.boot.model.Join(this.getCatalogName(auditTable.catalog(), join.getTable()), this.getSchemaName(auditTable.schema(), join.getTable()), auditTableName);
            joinElements.put(join, joinElement);
            if (join.isOptional()) {
                joinElement.setOptional(true);
            }
            if (join.isInverse()) {
                joinElement.setInverse(true);
            }
            joinElement.addKeyColumnsFromValue((Value)join.getKey());
            joinElement.addKeyColumn(new Column(this.configuration.getRevisionFieldName()));
            entity.addJoin(joinElement);
        }
    }

    private void addJoins(PersistentClass persistentClass, CompositeMapperBuilder currentMapper, ClassAuditingData auditingData, String entityName, EntityMappingData mappingData, boolean firstPass) {
        Iterator joins = persistentClass.getJoinIterator();
        while (joins.hasNext()) {
            Join join = (Join)joins.next();
            org.hibernate.envers.boot.model.Join entityJoin = this.entityJoins.get(entityName).get(join);
            if (entityJoin == null) continue;
            this.addProperties(entityJoin, join.getPropertyIterator(), currentMapper, auditingData, entityName, mappingData, firstPass);
        }
    }

    private MappingDescriptor generateMappingData(PersistentClass persistentClass, AuditTableData auditTableData, IdMappingData idMapper) {
        String parentEntityName;
        AbstractPropertyMapper propertyMapper;
        PersistentEntity entity;
        InheritanceType inheritanceType = InheritanceType.get(persistentClass);
        if (InheritanceType.NONE == inheritanceType) {
            entity = this.entityInstantiator.instantiate(persistentClass, auditTableData);
            propertyMapper = new MultiPropertyMapper();
            parentEntityName = null;
            ((RootPersistentEntity)entity).setIdentifier(idMapper.getIdentifier());
            this.addRevisionTypeToAttributeContainer(entity, false);
            this.addAuditStrategyAdditionalColumnsToEntity(entity);
        } else {
            parentEntityName = persistentClass.getSuperclass().getEntityName();
            EntityConfiguration parentConfiguration = this.getAuditedEntityConfiguration(parentEntityName);
            if (parentConfiguration == null) {
                throw new EnversMappingException(String.format(Locale.ENGLISH, "Entity '%s' is audited, but its superclass '%s' is not.", persistentClass.getEntityName(), parentEntityName));
            }
            entity = this.entityInstantiator.instantiate(persistentClass, auditTableData);
            propertyMapper = new SubclassPropertyMapper(new MultiPropertyMapper(), parentConfiguration.getPropertyMapper());
        }
        return new MappingDescriptor(entity, (ExtendedPropertyMapper)((Object)propertyMapper), parentEntityName);
    }

    public void generateFirstPass(ClassAuditingData auditingData, EntityMappingData mappingData, boolean isAudited) {
        PersistentClass persistentClass = auditingData.getPersistentClass();
        if (!isAudited) {
            String entityName = persistentClass.getEntityName();
            IdMappingData idMapper = this.idMetadataGenerator.addIdAndGetMappingData(persistentClass, false);
            if (idMapper == null) {
                LOG.debugf("Unable to create auditing id mapping for entity %s, because of an unsupported Hibernate id mapping (e.g. key-many-to-one)", entityName);
                return;
            }
            ExtendedPropertyMapper propertyMapper = null;
            String parentEntityName = null;
            EntityConfiguration entityCfg = new EntityConfiguration(entityName, persistentClass.getClassName(), idMapper, propertyMapper, parentEntityName);
            this.addNotAuditedEntityConfiguration(entityName, entityCfg);
            return;
        }
        String entityName = persistentClass.getEntityName();
        LOG.debugf("Generating first-pass auditing mapping for entity %s", entityName);
        String auditEntityName = this.configuration.getAuditEntityName(entityName);
        String auditTableName = this.configuration.getAuditTableName(entityName, persistentClass.getTable().getName());
        this.metadataBuildingContext.getAuditEntityNameRegistry().register(auditEntityName);
        AuditTableData auditTableData = new AuditTableData(auditEntityName, auditTableName, this.getSchemaName(auditingData.getAuditTable().schema(), persistentClass.getTable()), this.getCatalogName(auditingData.getAuditTable().catalog(), persistentClass.getTable()));
        IdMappingData idMapper = this.idMetadataGenerator.addIdAndGetMappingData(persistentClass, true);
        MappingDescriptor mappingDescriptor = this.generateMappingData(persistentClass, auditTableData, idMapper);
        PersistentEntity entity = mappingDescriptor.getEntity();
        ExtendedPropertyMapper propertyMapper = mappingDescriptor.getMapper();
        String parentEntityName = mappingDescriptor.getParentEntityName();
        LOG.infof("Adding properties for entity: %s", persistentClass.getEntityName());
        this.addProperties(entity, persistentClass.getUnjoinedPropertyIterator(), propertyMapper, auditingData, persistentClass.getEntityName(), mappingData, true);
        if (entity.isJoinAware()) {
            JoinAwarePersistentEntity joinAwareEntity = (JoinAwarePersistentEntity)((Object)entity);
            this.createJoins(persistentClass, joinAwareEntity, auditingData);
            this.addJoins(persistentClass, propertyMapper, auditingData, persistentClass.getEntityName(), mappingData, true);
        }
        this.addSynthetics(entity, auditingData, propertyMapper, mappingData, persistentClass.getEntityName());
        if (!this.configuration.isRevisionEndTimestampUseLegacyPlacement()) {
            this.addAuditStrategyRevisionEndTimestampOnly(entity);
        }
        mappingData.addMapping(entity);
        EntityConfiguration entityCfg = new EntityConfiguration(auditEntityName, persistentClass.getClassName(), idMapper, propertyMapper, parentEntityName);
        this.addAuditedEntityConfiguration(persistentClass.getEntityName(), entityCfg);
    }

    private void addSynthetics(PersistentEntity entity, ClassAuditingData auditingData, CompositeMapperBuilder currentMapper, EntityMappingData mappingData, String entityName) {
        for (PropertyAuditingData propertyAuditingData : auditingData.getSyntheticProperties()) {
            this.valueMetadataGenerator.addValue(entity, propertyAuditingData.getValue(), currentMapper, entityName, mappingData, propertyAuditingData, true, true, false);
        }
    }

    public void generateSecondPass(ClassAuditingData auditingData, EntityMappingData mappingData) {
        PersistentClass persistentClass = auditingData.getPersistentClass();
        String entityName = persistentClass.getEntityName();
        LOG.debugf("Generating second-pass auditing mapping for entity %s", entityName);
        ExtendedPropertyMapper propertyMapper = this.getAuditedEntityConfiguration(entityName).getPropertyMapper();
        this.idMetadataGenerator.generateSecondPass(entityName, persistentClass);
        this.addProperties(mappingData.getEntityDefinition(), persistentClass.getUnjoinedPropertyIterator(), propertyMapper, auditingData, entityName, mappingData, false);
        this.addJoins(persistentClass, propertyMapper, auditingData, entityName, mappingData, false);
    }

    private static class MappingDescriptor {
        private final PersistentEntity entity;
        private final ExtendedPropertyMapper mapper;
        private final String parentEntityName;

        public MappingDescriptor(PersistentEntity entity, ExtendedPropertyMapper mapper, String parentEntityName) {
            this.entity = entity;
            this.mapper = mapper;
            this.parentEntityName = parentEntityName;
        }

        public PersistentEntity getEntity() {
            return this.entity;
        }

        public ExtendedPropertyMapper getMapper() {
            return this.mapper;
        }

        public String getParentEntityName() {
            return this.parentEntityName;
        }
    }
}

