/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.configuration.internal.metadata;

import jakarta.persistence.EnumType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.TreeMap;
import java.util.TreeSet;
import org.hibernate.envers.boot.model.Attribute;
import org.hibernate.envers.boot.model.AttributeContainer;
import org.hibernate.envers.boot.model.BasicAttribute;
import org.hibernate.envers.boot.model.Column;
import org.hibernate.envers.boot.model.CompositeIdentifier;
import org.hibernate.envers.boot.model.Identifier;
import org.hibernate.envers.boot.model.RootPersistentEntity;
import org.hibernate.envers.boot.registry.classloading.ClassLoaderAccessHelper;
import org.hibernate.envers.boot.spi.EnversMetadataBuildingContext;
import org.hibernate.envers.configuration.Configuration;
import org.hibernate.envers.configuration.internal.metadata.AbstractMetadataGenerator;
import org.hibernate.envers.configuration.internal.metadata.BasicMetadataGenerator;
import org.hibernate.envers.configuration.internal.metadata.CollectionMetadataContext;
import org.hibernate.envers.configuration.internal.metadata.ColumnNameIterator;
import org.hibernate.envers.configuration.internal.metadata.QueryGeneratorBuilder;
import org.hibernate.envers.configuration.internal.metadata.ValueMetadataGenerator;
import org.hibernate.envers.configuration.internal.metadata.reader.AuditJoinTableData;
import org.hibernate.envers.configuration.internal.metadata.reader.ComponentAuditedPropertiesReader;
import org.hibernate.envers.configuration.internal.metadata.reader.ComponentAuditingData;
import org.hibernate.envers.configuration.internal.metadata.reader.PersistentPropertiesSource;
import org.hibernate.envers.configuration.internal.metadata.reader.PropertyAuditingData;
import org.hibernate.envers.internal.entities.IdMappingData;
import org.hibernate.envers.internal.entities.mapper.MultiPropertyMapper;
import org.hibernate.envers.internal.entities.mapper.PropertyMapper;
import org.hibernate.envers.internal.entities.mapper.relation.BasicCollectionMapper;
import org.hibernate.envers.internal.entities.mapper.relation.CommonCollectionMapperData;
import org.hibernate.envers.internal.entities.mapper.relation.ListCollectionMapper;
import org.hibernate.envers.internal.entities.mapper.relation.MapCollectionMapper;
import org.hibernate.envers.internal.entities.mapper.relation.MiddleComponentData;
import org.hibernate.envers.internal.entities.mapper.relation.MiddleIdData;
import org.hibernate.envers.internal.entities.mapper.relation.MiddleMapKeyEnumeratedComponentMapper;
import org.hibernate.envers.internal.entities.mapper.relation.SortedMapCollectionMapper;
import org.hibernate.envers.internal.entities.mapper.relation.SortedSetCollectionMapper;
import org.hibernate.envers.internal.entities.mapper.relation.component.AbstractMiddleComponentMapper;
import org.hibernate.envers.internal.entities.mapper.relation.component.MiddleDummyComponentMapper;
import org.hibernate.envers.internal.entities.mapper.relation.component.MiddleEmbeddableComponentMapper;
import org.hibernate.envers.internal.entities.mapper.relation.component.MiddleMapElementNotKeyComponentMapper;
import org.hibernate.envers.internal.entities.mapper.relation.component.MiddleMapKeyIdComponentMapper;
import org.hibernate.envers.internal.entities.mapper.relation.component.MiddleMapKeyPropertyComponentMapper;
import org.hibernate.envers.internal.entities.mapper.relation.component.MiddleRelatedComponentMapper;
import org.hibernate.envers.internal.entities.mapper.relation.component.MiddleSimpleComponentMapper;
import org.hibernate.envers.internal.entities.mapper.relation.lazy.proxy.ListProxy;
import org.hibernate.envers.internal.entities.mapper.relation.lazy.proxy.MapProxy;
import org.hibernate.envers.internal.entities.mapper.relation.lazy.proxy.SetProxy;
import org.hibernate.envers.internal.entities.mapper.relation.lazy.proxy.SortedMapProxy;
import org.hibernate.envers.internal.entities.mapper.relation.lazy.proxy.SortedSetProxy;
import org.hibernate.envers.internal.entities.mapper.relation.query.RelationQueryGenerator;
import org.hibernate.envers.internal.tools.MappingTools;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.IndexedCollection;
import org.hibernate.mapping.Map;
import org.hibernate.mapping.Value;
import org.hibernate.type.BagType;
import org.hibernate.type.BasicType;
import org.hibernate.type.ComponentType;
import org.hibernate.type.ListType;
import org.hibernate.type.ManyToOneType;
import org.hibernate.type.MapType;
import org.hibernate.type.SetType;
import org.hibernate.type.SortedMapType;
import org.hibernate.type.SortedSetType;
import org.hibernate.type.Type;

public abstract class AbstractCollectionMetadataGenerator
extends AbstractMetadataGenerator {
    private final BasicMetadataGenerator basicMetadataGenerator;
    private final ValueMetadataGenerator valueMetadataGenerator;

    public AbstractCollectionMetadataGenerator(EnversMetadataBuildingContext metadataBuildingContext, BasicMetadataGenerator basicMetadataGenerator, ValueMetadataGenerator valueMetadataGenerator) {
        super(metadataBuildingContext);
        this.basicMetadataGenerator = basicMetadataGenerator;
        this.valueMetadataGenerator = valueMetadataGenerator;
    }

    public abstract void addCollection(CollectionMetadataContext var1);

    protected MiddleIdData createMiddleIdData(IdMappingData idMappingData, String prefix, String entityName) {
        return new MiddleIdData(this.getMetadataBuildingContext().getConfiguration(), idMappingData, prefix, entityName, this.hasAuditedEntityConfiguration(entityName));
    }

    protected List<Attribute> getPrefixedIdAttributes(String prefix, ColumnNameIterator iterator, IdMappingData idMapping) {
        return idMapping.getRelation().getAttributesPrefixed(prefix, iterator, true, true);
    }

    protected void addAttributesToEntity(RootPersistentEntity entity, List<Attribute> attributes) {
        Identifier identifier = entity.getIdentifier();
        if (identifier == null) {
            identifier = new CompositeIdentifier(this.getMetadataBuildingContext());
            entity.setIdentifier(identifier);
        }
        attributes.forEach(identifier::addAttribute);
    }

    protected CommonCollectionMapperData createCommonCollectionMapperData(CollectionMetadataContext context, String entityName, MiddleIdData idData, RelationQueryGenerator queryGenerator) {
        return new CommonCollectionMapperData(entityName, context.getPropertyAuditingData().resolvePropertyData(), idData, queryGenerator, context.getCollection().getRole());
    }

    protected String getOrderBy(Collection collection) {
        String orderBy = collection.getOrderBy();
        return orderBy == null ? collection.getManyToManyOrdering() : orderBy;
    }

    protected String getOrderByCollectionRole(Collection collection, String orderBy) {
        return orderBy == null ? null : collection.getRole();
    }

    private boolean hasNoMapKeyOrNonEntityEnumeration(String entityName, PropertyAuditingData propertyAuditingData) {
        String mapKey = propertyAuditingData.getMapKey();
        EnumType mapKeyEnumType = propertyAuditingData.getMapKeyEnumType();
        return mapKey == null && mapKeyEnumType == null || mapKeyEnumType != null && entityName == null;
    }

    private boolean hasMapKey(PropertyAuditingData propertyAuditingData) {
        String mapKey = propertyAuditingData.getMapKey();
        return mapKey != null && mapKey.isEmpty();
    }

    private boolean hasMapKeyEnum(PropertyAuditingData propertyAuditingData) {
        return propertyAuditingData.getMapKeyEnumType() != null;
    }

    private int getCurrentIndex(QueryGeneratorBuilder queryGeneratorBuilder) {
        return queryGeneratorBuilder == null ? 0 : queryGeneratorBuilder.getCurrentIndex();
    }

    protected MiddleComponentData addIndex(CollectionMetadataContext context, RootPersistentEntity middleEntity, QueryGeneratorBuilder queryGeneratorBuilder) {
        if (context.getCollection().isIndexed()) {
            PropertyAuditingData propertyAuditingData;
            String referencedEntityName = context.getReferencedEntityName();
            if (this.hasNoMapKeyOrNonEntityEnumeration(referencedEntityName, propertyAuditingData = context.getPropertyAuditingData())) {
                return this.addValueToMiddleTable(context, ((IndexedCollection)context.getCollection()).getIndex(), middleEntity, queryGeneratorBuilder, "mapkey", null, true);
            }
            if (this.hasMapKeyEnum(propertyAuditingData)) {
                return new MiddleComponentData(new MiddleMapKeyEnumeratedComponentMapper(propertyAuditingData.getName()), this.getCurrentIndex(queryGeneratorBuilder));
            }
            IdMappingData referencedIdMapping = this.getAuditedEntityConfiguration(referencedEntityName).getIdMappingData();
            AbstractMiddleComponentMapper middleComponentMapper = this.hasMapKey(propertyAuditingData) ? new MiddleMapKeyIdComponentMapper(this.getMetadataBuildingContext().getConfiguration(), referencedIdMapping.getIdMapper()) : new MiddleMapKeyPropertyComponentMapper(propertyAuditingData.getMapKey(), propertyAuditingData.getAccessType());
            return new MiddleComponentData(middleComponentMapper, this.getCurrentIndex(queryGeneratorBuilder));
        }
        return new MiddleComponentData(new MiddleDummyComponentMapper());
    }

    protected MiddleComponentData addValueToMiddleTable(CollectionMetadataContext context, Value value, RootPersistentEntity entity, QueryGeneratorBuilder queryGeneratorBuilder, String prefix, AuditJoinTableData joinTableData, boolean key) {
        Type type = value.getType();
        if (type instanceof ManyToOneType) {
            return this.addManyToOneValueToMiddleTable(context, entity, value, joinTableData, prefix, queryGeneratorBuilder);
        }
        if (type instanceof ComponentType) {
            return this.addComponentValueToMiddleTable(context, entity, (Component)value, prefix);
        }
        MiddleComponentData middleComponentData = this.addBasicValueToMiddleTable(entity, value, prefix, key);
        if (middleComponentData == null) {
            this.throwUnsupportedTypeException(type, context.getReferencingEntityName(), context.getPropertyName());
        }
        return middleComponentData;
    }

    private MiddleComponentData addManyToOneValueToMiddleTable(CollectionMetadataContext context, RootPersistentEntity entity, Value value, AuditJoinTableData joinTableData, String prefix, QueryGeneratorBuilder queryGeneratorBuilder) {
        String prefixRelated = prefix + "_";
        String referencedEntityName = MappingTools.getReferencedEntityName(value);
        IdMappingData referencedIdMapping = this.getReferencedIdMappingData(context.getReferencingEntityName(), referencedEntityName, context.getPropertyAuditingData(), true);
        if (entity != null) {
            ColumnNameIterator columnNameIterator = joinTableData != null && !joinTableData.getInverseJoinColumnNames().isEmpty() ? joinTableData.getInverseJoinColumnNamesIterator() : ColumnNameIterator.from(value.getColumnIterator());
            this.addAttributesToEntity(entity, this.getPrefixedIdAttributes(prefixRelated, columnNameIterator, referencedIdMapping));
        }
        MiddleIdData referencedIdData = this.createMiddleIdData(referencedIdMapping, prefixRelated, referencedEntityName);
        queryGeneratorBuilder.addRelation(referencedIdData);
        return new MiddleComponentData(new MiddleRelatedComponentMapper(referencedIdData), queryGeneratorBuilder.getCurrentIndex());
    }

    private MiddleComponentData addComponentValueToMiddleTable(CollectionMetadataContext context, RootPersistentEntity entity, Component component, String prefix) {
        PropertyAuditingData nestedAuditingData;
        MiddleEmbeddableComponentMapper componentMapper = new MiddleEmbeddableComponentMapper(new MultiPropertyMapper(), ClassLoaderAccessHelper.loadClass(this.getMetadataBuildingContext(), component.getComponentClassName()));
        ComponentAuditingData auditData = new ComponentAuditingData();
        new ComponentAuditedPropertiesReader(this.getMetadataBuildingContext(), PersistentPropertiesSource.forComponent(this.getMetadataBuildingContext(), component), auditData).read();
        for (String auditedPropertyName : auditData.getPropertyNames()) {
            nestedAuditingData = auditData.getPropertyAuditingData(auditedPropertyName);
            this.valueMetadataGenerator.addValue(entity, component.getProperty(auditedPropertyName).getValue(), componentMapper, prefix, context.getEntityMappingData(), nestedAuditingData, true, true, true);
        }
        for (String auditedPropertyName : auditData.getPropertyNames()) {
            nestedAuditingData = auditData.getPropertyAuditingData(auditedPropertyName);
            this.valueMetadataGenerator.addValue(entity, component.getProperty(auditedPropertyName).getValue(), componentMapper, context.getReferencingEntityName(), context.getEntityMappingData(), nestedAuditingData, true, false, true);
        }
        if (context.getCollection().isSet()) {
            String setOrdinalPropertyName = this.getMetadataBuildingContext().getConfiguration().getEmbeddableSetOrdinalPropertyName();
            BasicAttribute ordinalProperty = new BasicAttribute(setOrdinalPropertyName, "integer", true, true);
            ordinalProperty.addColumn(new Column(setOrdinalPropertyName));
            entity.getIdentifier().addAttribute(ordinalProperty);
        }
        return new MiddleComponentData(componentMapper);
    }

    private MiddleComponentData addBasicValueToMiddleTable(RootPersistentEntity entity, Value value, String prefix, boolean key) {
        boolean mapped;
        AttributeContainer attributeContainer = entity;
        if (entity != null && key) {
            attributeContainer = entity.getIdentifier();
        }
        if (mapped = this.basicMetadataGenerator.addBasic(attributeContainer, new PropertyAuditingData(prefix, "field", false), value, null, true, key)) {
            AbstractMiddleComponentMapper mapper;
            if (key) {
                Configuration configuration = this.getMetadataBuildingContext().getConfiguration();
                mapper = new MiddleSimpleComponentMapper(configuration, prefix);
            } else {
                mapper = new MiddleMapElementNotKeyComponentMapper(prefix);
            }
            return new MiddleComponentData(mapper);
        }
        return null;
    }

    protected void addMapper(CollectionMetadataContext context, CommonCollectionMapperData commonCollectionMapperData, MiddleComponentData elementComponentData, MiddleComponentData indexComponentData) {
        context.getMapperBuilder().addComposite(context.getPropertyAuditingData().resolvePropertyData(), this.resolvePropertyMapper(context, commonCollectionMapperData, elementComponentData, indexComponentData));
    }

    private PropertyMapper resolvePropertyMapper(CollectionMetadataContext context, CommonCollectionMapperData commonCollectionMapperData, MiddleComponentData elementComponentData, MiddleComponentData indexComponentData) {
        String referencingEntityName = context.getReferencingEntityName();
        boolean embeddableElementType = this.isEmbeddableElementType(context);
        boolean lobMapElementType = this.isLobMapElementType(context);
        Type collectionType = context.getCollection().getType();
        if (collectionType instanceof SortedSetType) {
            return new SortedSetCollectionMapper(this.getMetadataBuildingContext().getConfiguration(), commonCollectionMapperData, TreeSet.class, SortedSetProxy.class, elementComponentData, context.getCollection().getComparator(), embeddableElementType, embeddableElementType);
        }
        if (collectionType instanceof SetType) {
            return new BasicCollectionMapper<SetProxy>(this.getMetadataBuildingContext().getConfiguration(), commonCollectionMapperData, HashSet.class, SetProxy.class, elementComponentData, embeddableElementType, embeddableElementType);
        }
        if (collectionType instanceof SortedMapType) {
            return new SortedMapCollectionMapper(this.getMetadataBuildingContext().getConfiguration(), commonCollectionMapperData, TreeMap.class, SortedMapProxy.class, elementComponentData, indexComponentData, context.getCollection().getComparator(), embeddableElementType || lobMapElementType);
        }
        if (collectionType instanceof MapType) {
            return new MapCollectionMapper<MapProxy>(this.getMetadataBuildingContext().getConfiguration(), commonCollectionMapperData, HashMap.class, MapProxy.class, elementComponentData, indexComponentData, embeddableElementType || lobMapElementType);
        }
        if (collectionType instanceof BagType) {
            return new BasicCollectionMapper<ListProxy>(this.getMetadataBuildingContext().getConfiguration(), commonCollectionMapperData, ArrayList.class, ListProxy.class, elementComponentData, embeddableElementType, embeddableElementType);
        }
        if (collectionType instanceof ListType) {
            return new ListCollectionMapper(this.getMetadataBuildingContext().getConfiguration(), commonCollectionMapperData, elementComponentData, indexComponentData, embeddableElementType);
        }
        this.throwUnsupportedTypeException(collectionType, referencingEntityName, context.getPropertyName());
        throw new AssertionError();
    }

    protected boolean isLobMapElementType(CollectionMetadataContext context) {
        Type type;
        Collection collection = context.getCollection();
        if (collection instanceof Map && !(type = collection.getElement().getType()).isComponentType() && !type.isAssociationType() && type instanceof BasicType) {
            BasicType basicType = (BasicType)type;
            return basicType.getJavaType() == String.class && (basicType.getJdbcType().getJdbcTypeCode() == 2005 || basicType.getJdbcType().getJdbcTypeCode() == 2011);
        }
        return false;
    }

    protected boolean isEmbeddableElementType(CollectionMetadataContext context) {
        Type elementType = context.getCollection().getElement().getType();
        return elementType instanceof ComponentType;
    }
}

