/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.internal.entities.mapper;

import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.envers.boot.internal.EnversService;
import org.hibernate.envers.exception.AuditException;
import org.hibernate.envers.internal.entities.PropertyData;
import org.hibernate.envers.internal.entities.mapper.AbstractPropertyMapper;
import org.hibernate.envers.internal.entities.mapper.CompositeMapperBuilder;
import org.hibernate.envers.internal.entities.mapper.MultiDynamicComponentMapper;
import org.hibernate.envers.internal.entities.mapper.MultiPropertyMapper;
import org.hibernate.envers.internal.entities.mapper.PersistentCollectionChangeData;
import org.hibernate.envers.internal.entities.mapper.PropertyMapper;
import org.hibernate.envers.internal.entities.mapper.SinglePropertyMapper;
import org.hibernate.envers.internal.reader.AuditReaderImplementor;
import org.hibernate.envers.internal.tools.ReflectionTools;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.property.access.spi.Setter;

public class ComponentPropertyMapper
extends AbstractPropertyMapper
implements CompositeMapperBuilder {
    private final PropertyData propertyData;
    private final MultiPropertyMapper delegate;
    private final Class componentClass;

    public ComponentPropertyMapper(PropertyData propertyData, Class componentClass) {
        this.propertyData = propertyData;
        if (Map.class.isAssignableFrom(componentClass)) {
            this.delegate = new MultiDynamicComponentMapper(propertyData);
            this.componentClass = HashMap.class;
        } else {
            this.delegate = new MultiPropertyMapper();
            this.componentClass = componentClass;
        }
    }

    @Override
    public void add(PropertyData propertyData) {
        this.delegate.add(propertyData);
    }

    @Override
    public CompositeMapperBuilder addComponent(PropertyData propertyData, Class componentClass) {
        return this.delegate.addComponent(propertyData, componentClass);
    }

    @Override
    public void addComposite(PropertyData propertyData, PropertyMapper propertyMapper) {
        this.delegate.addComposite(propertyData, propertyMapper);
    }

    @Override
    public boolean mapToMapFromEntity(SessionImplementor session, Map<String, Object> data, Object newObj, Object oldObj) {
        return this.delegate.mapToMapFromEntity(session, data, newObj, oldObj);
    }

    @Override
    public void mapModifiedFlagsToMapFromEntity(SessionImplementor session, Map<String, Object> data, Object newObj, Object oldObj) {
        if (this.propertyData.isUsingModifiedFlag()) {
            data.put(this.propertyData.getModifiedFlagPropertyName(), this.delegate.mapToMapFromEntity(session, new HashMap<String, Object>(), newObj, oldObj));
        }
    }

    @Override
    public void mapModifiedFlagsToMapForCollectionChange(String collectionPropertyName, Map<String, Object> data) {
        if (this.propertyData.isUsingModifiedFlag()) {
            boolean hasModifiedCollection = false;
            for (PropertyData propData : this.delegate.getProperties().keySet()) {
                if (!collectionPropertyName.equals(propData.getName())) continue;
                hasModifiedCollection = true;
                break;
            }
            data.put(this.propertyData.getModifiedFlagPropertyName(), hasModifiedCollection);
        }
    }

    @Override
    public void mapToEntityFromMap(final EnversService enversService, final Object obj, final Map data, final Object primaryKey, final AuditReaderImplementor versionsReader, final Number revision) {
        if (data == null || obj == null) {
            return;
        }
        if (this.propertyData.getBeanName() == null) {
            this.delegate.mapToEntityFromMap(enversService, obj, data, primaryKey, versionsReader, revision);
            return;
        }
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                try {
                    Object subObj = ReflectHelper.getDefaultConstructor((Class)ComponentPropertyMapper.this.componentClass).newInstance(new Object[0]);
                    if (ComponentPropertyMapper.this.isDynamicComponentMap()) {
                        ((Map)obj).put(ComponentPropertyMapper.this.propertyData.getBeanName(), subObj);
                        ComponentPropertyMapper.this.delegate.mapToEntityFromMap(enversService, subObj, data, primaryKey, versionsReader, revision);
                    } else {
                        Setter setter = ReflectionTools.getSetter(obj.getClass(), ComponentPropertyMapper.this.propertyData, enversService.getServiceRegistry());
                        if (ComponentPropertyMapper.this.isAllPropertiesNull(data)) {
                            setter.set(obj, null, null);
                        } else {
                            setter.set(obj, subObj, null);
                            ComponentPropertyMapper.this.delegate.mapToEntityFromMap(enversService, subObj, data, primaryKey, versionsReader, revision);
                        }
                    }
                }
                catch (Exception e) {
                    throw new AuditException(e);
                }
                return null;
            }
        });
    }

    private boolean isAllPropertiesNull(Map data) {
        for (Map.Entry<PropertyData, PropertyMapper> property : this.delegate.getProperties().entrySet()) {
            Object value = data.get(property.getKey().getName());
            if (value == null && property.getValue() instanceof SinglePropertyMapper) continue;
            return false;
        }
        return true;
    }

    @Override
    public List<PersistentCollectionChangeData> mapCollectionChanges(SessionImplementor session, String referencingPropertyName, PersistentCollection newColl, Serializable oldColl, Object id) {
        return this.delegate.mapCollectionChanges(session, referencingPropertyName, newColl, oldColl, id);
    }

    @Override
    public Map<PropertyData, PropertyMapper> getProperties() {
        return this.delegate.getProperties();
    }

    @Override
    public boolean hasPropertiesWithModifiedFlag() {
        return this.delegate.hasPropertiesWithModifiedFlag();
    }
}

