/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.community.dialect;

import java.util.List;
import org.hibernate.MappingException;
import org.hibernate.community.dialect.HANALegacyDialect;
import org.hibernate.dialect.SybaseASESqlAstTranslator;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.internal.util.collections.Stack;
import org.hibernate.metamodel.mapping.CollectionPart;
import org.hibernate.metamodel.mapping.JdbcMappingContainer;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.query.IllegalQueryOperationException;
import org.hibernate.query.sqm.ComparisonOperator;
import org.hibernate.query.sqm.tuple.internal.AnonymousTupleTableGroupProducer;
import org.hibernate.sql.ast.Clause;
import org.hibernate.sql.ast.SqlAstNodeRenderingMode;
import org.hibernate.sql.ast.SqlAstWalker;
import org.hibernate.sql.ast.spi.AbstractSqlAstTranslator;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.sql.ast.tree.Statement;
import org.hibernate.sql.ast.tree.cte.CteStatement;
import org.hibernate.sql.ast.tree.expression.BinaryArithmeticExpression;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.Literal;
import org.hibernate.sql.ast.tree.expression.Summarization;
import org.hibernate.sql.ast.tree.from.DerivedTableReference;
import org.hibernate.sql.ast.tree.from.FromClause;
import org.hibernate.sql.ast.tree.from.FunctionTableReference;
import org.hibernate.sql.ast.tree.from.NamedTableReference;
import org.hibernate.sql.ast.tree.from.QueryPartTableReference;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.from.ValuesTableReference;
import org.hibernate.sql.ast.tree.insert.ConflictClause;
import org.hibernate.sql.ast.tree.insert.InsertSelectStatement;
import org.hibernate.sql.ast.tree.insert.Values;
import org.hibernate.sql.ast.tree.select.QueryGroup;
import org.hibernate.sql.ast.tree.select.QueryPart;
import org.hibernate.sql.ast.tree.select.QuerySpec;
import org.hibernate.sql.ast.tree.update.UpdateStatement;
import org.hibernate.sql.exec.spi.JdbcOperation;
import org.hibernate.sql.model.internal.TableInsertStandard;

public class HANALegacySqlAstTranslator<T extends JdbcOperation>
extends AbstractSqlAstTranslator<T> {
    private boolean inLateral;

    public HANALegacySqlAstTranslator(SessionFactoryImplementor sessionFactory, Statement statement) {
        super(sessionFactory, statement);
    }

    public void visitBinaryArithmeticExpression(BinaryArithmeticExpression arithmeticExpression) {
        if (this.isIntegerDivisionEmulationRequired(arithmeticExpression)) {
            this.appendSql("cast(");
            this.visitArithmeticOperand(arithmeticExpression.getLeftHandOperand());
            this.appendSql(arithmeticExpression.getOperator().getOperatorSqlTextString());
            this.visitArithmeticOperand(arithmeticExpression.getRightHandOperand());
            this.appendSql(" as int)");
        } else {
            super.visitBinaryArithmeticExpression(arithmeticExpression);
        }
    }

    protected void visitArithmeticOperand(Expression expression) {
        this.render((SqlAstNode)expression, SqlAstNodeRenderingMode.NO_PLAIN_PARAMETER);
    }

    private boolean isHanaCloud() {
        return ((HANALegacyDialect)this.getDialect()).isCloud();
    }

    protected void visitInsertStatementOnly(InsertSelectStatement statement) {
        if (statement.getConflictClause() == null || statement.getConflictClause().isDoNothing()) {
            super.visitInsertStatementOnly(statement);
        } else {
            this.visitInsertStatementEmulateMerge(statement);
        }
    }

    protected void visitUpdateStatementOnly(UpdateStatement statement) {
        if (this.isHanaCloud() && HANALegacySqlAstTranslator.hasNonTrivialFromClause((FromClause)statement.getFromClause())) {
            this.visitUpdateStatementEmulateMerge(statement);
        } else {
            super.visitUpdateStatementOnly(statement);
        }
    }

    protected void renderUpdateClause(UpdateStatement updateStatement) {
        if (this.isHanaCloud()) {
            super.renderUpdateClause(updateStatement);
        } else {
            this.appendSql("update");
            Stack clauseStack = this.getClauseStack();
            try {
                clauseStack.push((Object)Clause.UPDATE);
                this.renderTableReferenceIdentificationVariable((TableReference)updateStatement.getTargetTable());
            }
            finally {
                clauseStack.pop();
            }
        }
    }

    protected void renderFromClauseAfterUpdateSet(UpdateStatement statement) {
        if (!this.isHanaCloud()) {
            if (statement.getFromClause().getRoots().isEmpty()) {
                this.appendSql(" from ");
                this.renderDmlTargetTableExpression(statement.getTargetTable());
            } else {
                this.visitFromClause(statement.getFromClause());
            }
        }
    }

    protected void renderDmlTargetTableExpression(NamedTableReference tableReference) {
        super.renderDmlTargetTableExpression(tableReference);
        if (this.getClauseStack().getCurrent() != Clause.INSERT) {
            this.renderTableReferenceIdentificationVariable((TableReference)tableReference);
        }
    }

    protected void visitConflictClause(ConflictClause conflictClause) {
        if (conflictClause != null && conflictClause.isDoUpdate() && conflictClause.getConstraintName() != null) {
            throw new IllegalQueryOperationException("Insert conflict 'do update' clause with constraint name is not supported");
        }
    }

    protected boolean shouldEmulateFetchClause(QueryPart queryPart) {
        return this.useOffsetFetchClause(queryPart) && this.getQueryPartForRowNumbering() != queryPart && !this.isRowsOnlyFetchClauseType(queryPart);
    }

    protected boolean isCorrelated(CteStatement cteStatement) {
        return false;
    }

    public void visitQueryGroup(QueryGroup queryGroup) {
        if (this.shouldEmulateFetchClause((QueryPart)queryGroup)) {
            this.emulateFetchOffsetWithWindowFunctions((QueryPart)queryGroup, true);
        } else {
            super.visitQueryGroup(queryGroup);
        }
    }

    public void visitQuerySpec(QuerySpec querySpec) {
        if (this.shouldEmulateFetchClause((QueryPart)querySpec)) {
            this.emulateFetchOffsetWithWindowFunctions((QueryPart)querySpec, true);
        } else {
            super.visitQuerySpec(querySpec);
        }
    }

    public void visitQueryPartTableReference(QueryPartTableReference tableReference) {
        if (tableReference.isLateral() && !this.inLateral) {
            this.inLateral = true;
            this.emulateQueryPartTableReferenceColumnAliasing(tableReference);
            this.inLateral = false;
        } else {
            this.emulateQueryPartTableReferenceColumnAliasing(tableReference);
        }
    }

    protected void renderDerivedTableReference(DerivedTableReference tableReference) {
        if (tableReference instanceof FunctionTableReference && tableReference.isLateral()) {
            tableReference.accept((SqlAstWalker)this);
        } else {
            super.renderDerivedTableReference(tableReference);
        }
    }

    public void renderNamedSetReturningFunction(String functionName, List<? extends SqlAstNode> sqlAstArguments, AnonymousTupleTableGroupProducer tupleType, String tableIdentifierVariable, SqlAstNodeRenderingMode argumentRenderingMode) {
        ModelPart ordinalitySubPart = tupleType.findSubPart(CollectionPart.Nature.INDEX.getName(), null);
        if (ordinalitySubPart != null) {
            this.appendSql("(select t.*, row_number() over() ");
            this.appendSql(ordinalitySubPart.asBasicValuedModelPart().getSelectionExpression());
            this.appendSql(" from ");
            this.renderSimpleNamedFunction(functionName, sqlAstArguments, argumentRenderingMode);
            this.append(" t)");
        } else {
            super.renderNamedSetReturningFunction(functionName, sqlAstArguments, tupleType, tableIdentifierVariable, argumentRenderingMode);
        }
    }

    protected SqlAstNodeRenderingMode getParameterRenderingMode() {
        return this.inLateral ? SqlAstNodeRenderingMode.INLINE_ALL_PARAMETERS : super.getParameterRenderingMode();
    }

    public void visitOffsetFetchClause(QueryPart queryPart) {
        if (!this.isRowNumberingCurrentQueryPart()) {
            this.renderLimitOffsetClause(queryPart);
        }
    }

    protected void renderComparison(Expression lhs, ComparisonOperator operator, Expression rhs) {
        boolean isLob = SybaseASESqlAstTranslator.isLob((JdbcMappingContainer)lhs.getExpressionType());
        if (operator == ComparisonOperator.DISTINCT_FROM || operator == ComparisonOperator.NOT_DISTINCT_FROM) {
            if (isLob) {
                switch (operator) {
                    case DISTINCT_FROM: {
                        this.appendSql("case when ");
                        lhs.accept((SqlAstWalker)this);
                        this.appendSql(" like ");
                        rhs.accept((SqlAstWalker)this);
                        this.appendSql(" or ");
                        lhs.accept((SqlAstWalker)this);
                        this.appendSql(" is null and ");
                        rhs.accept((SqlAstWalker)this);
                        this.appendSql(" is null then 0 else 1 end=1");
                        return;
                    }
                    case NOT_DISTINCT_FROM: {
                        this.appendSql("case when ");
                        lhs.accept((SqlAstWalker)this);
                        this.appendSql(" like ");
                        rhs.accept((SqlAstWalker)this);
                        this.appendSql(" or ");
                        lhs.accept((SqlAstWalker)this);
                        this.appendSql(" is null and ");
                        rhs.accept((SqlAstWalker)this);
                        this.appendSql(" is null then 0 else 1 end=0");
                        return;
                    }
                }
            }
            this.withParameterRenderingMode(SqlAstNodeRenderingMode.NO_PLAIN_PARAMETER, () -> this.renderComparisonEmulateIntersect(lhs, operator, rhs));
        } else {
            if (isLob) {
                switch (operator) {
                    case EQUAL: {
                        lhs.accept((SqlAstWalker)this);
                        this.appendSql(" like ");
                        rhs.accept((SqlAstWalker)this);
                        return;
                    }
                    case NOT_EQUAL: {
                        lhs.accept((SqlAstWalker)this);
                        this.appendSql(" not like ");
                        rhs.accept((SqlAstWalker)this);
                        return;
                    }
                }
            }
            this.renderComparisonStandard(lhs, operator, rhs);
        }
    }

    protected void renderPartitionItem(Expression expression) {
        if (expression instanceof Literal) {
            this.appendSql("grouping sets (())");
        } else {
            if (expression instanceof Summarization) {
                throw new UnsupportedOperationException("Summarization is not supported by DBMS");
            }
            expression.accept((SqlAstWalker)this);
        }
    }

    protected void renderInsertIntoNoColumns(TableInsertStandard tableInsert) {
        throw new MappingException(String.format("The INSERT statement for table [%s] contains no column, and this is not supported by [%s]", tableInsert.getMutatingTable().getTableId(), this.getDialect()));
    }

    protected void visitValuesList(List<Values> valuesList) {
        this.visitValuesListEmulateSelectUnion(valuesList);
    }

    public void visitValuesTableReference(ValuesTableReference tableReference) {
        this.emulateValuesTableReferenceColumnAliasing(tableReference);
    }

    protected String getSkipLocked() {
        return " ignore locked";
    }
}

