/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.community.dialect;

import jakarta.persistence.TemporalType;
import java.sql.CallableStatement;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.PessimisticLockException;
import org.hibernate.QueryTimeoutException;
import org.hibernate.boot.model.FunctionContributions;
import org.hibernate.boot.model.TypeContributions;
import org.hibernate.community.dialect.PostgreSQLLegacySqlAstTranslator;
import org.hibernate.community.dialect.sequence.PostgreSQLLegacySequenceSupport;
import org.hibernate.dialect.DatabaseVersion;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.DmlTargetColumnQualifierSupport;
import org.hibernate.dialect.FunctionalDependencyAnalysisSupport;
import org.hibernate.dialect.FunctionalDependencyAnalysisSupportImpl;
import org.hibernate.dialect.NationalizationSupport;
import org.hibernate.dialect.OracleDialect;
import org.hibernate.dialect.PgJdbcHelper;
import org.hibernate.dialect.PostgreSQLArrayJdbcTypeConstructor;
import org.hibernate.dialect.PostgreSQLCastingInetJdbcType;
import org.hibernate.dialect.PostgreSQLCastingIntervalSecondJdbcType;
import org.hibernate.dialect.PostgreSQLCastingJsonJdbcType;
import org.hibernate.dialect.PostgreSQLDriverKind;
import org.hibernate.dialect.PostgreSQLEnumJdbcType;
import org.hibernate.dialect.PostgreSQLOrdinalEnumJdbcType;
import org.hibernate.dialect.PostgreSQLStructCastingJdbcType;
import org.hibernate.dialect.PostgreSQLUUIDJdbcType;
import org.hibernate.dialect.Replacer;
import org.hibernate.dialect.RowLockStrategy;
import org.hibernate.dialect.SelectItemReferenceStrategy;
import org.hibernate.dialect.TimeZoneSupport;
import org.hibernate.dialect.aggregate.AggregateSupport;
import org.hibernate.dialect.aggregate.PostgreSQLAggregateSupport;
import org.hibernate.dialect.function.CommonFunctionFactory;
import org.hibernate.dialect.function.PostgreSQLMinMaxFunction;
import org.hibernate.dialect.function.PostgreSQLTruncFunction;
import org.hibernate.dialect.function.PostgreSQLTruncRoundFunction;
import org.hibernate.dialect.identity.IdentityColumnSupport;
import org.hibernate.dialect.identity.PostgreSQLIdentityColumnSupport;
import org.hibernate.dialect.pagination.LimitHandler;
import org.hibernate.dialect.pagination.LimitOffsetLimitHandler;
import org.hibernate.dialect.pagination.OffsetFetchLimitHandler;
import org.hibernate.dialect.sequence.PostgreSQLSequenceSupport;
import org.hibernate.dialect.sequence.SequenceSupport;
import org.hibernate.dialect.unique.CreateTableUniqueDelegate;
import org.hibernate.dialect.unique.UniqueDelegate;
import org.hibernate.engine.jdbc.dialect.spi.DialectResolutionInfo;
import org.hibernate.engine.jdbc.env.spi.IdentifierCaseStrategy;
import org.hibernate.engine.jdbc.env.spi.IdentifierHelper;
import org.hibernate.engine.jdbc.env.spi.IdentifierHelperBuilder;
import org.hibernate.engine.jdbc.env.spi.NameQualifierSupport;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.exception.LockAcquisitionException;
import org.hibernate.exception.spi.SQLExceptionConversionDelegate;
import org.hibernate.exception.spi.TemplatedViolatedConstraintNameExtractor;
import org.hibernate.exception.spi.ViolatedConstraintNameExtractor;
import org.hibernate.internal.util.JdbcExceptionHelper;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.SqlExpressible;
import org.hibernate.metamodel.mapping.SqlTypedMapping;
import org.hibernate.metamodel.spi.RuntimeModelCreationContext;
import org.hibernate.procedure.internal.PostgreSQLCallableStatementSupport;
import org.hibernate.procedure.spi.CallableStatementSupport;
import org.hibernate.query.SemanticException;
import org.hibernate.query.spi.QueryOptions;
import org.hibernate.query.sqm.CastType;
import org.hibernate.query.sqm.FetchClauseType;
import org.hibernate.query.sqm.IntervalType;
import org.hibernate.query.sqm.TemporalUnit;
import org.hibernate.query.sqm.function.SqmFunctionDescriptor;
import org.hibernate.query.sqm.mutation.internal.cte.CteInsertStrategy;
import org.hibernate.query.sqm.mutation.internal.cte.CteMutationStrategy;
import org.hibernate.query.sqm.mutation.spi.SqmMultiTableInsertStrategy;
import org.hibernate.query.sqm.mutation.spi.SqmMultiTableMutationStrategy;
import org.hibernate.query.sqm.produce.function.StandardFunctionArgumentTypeResolvers;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.SqlAstTranslatorFactory;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.spi.StandardSqlAstTranslatorFactory;
import org.hibernate.sql.ast.tree.Statement;
import org.hibernate.sql.exec.spi.JdbcOperation;
import org.hibernate.tool.schema.extract.spi.ColumnTypeInformation;
import org.hibernate.type.BasicType;
import org.hibernate.type.JavaObjectType;
import org.hibernate.type.descriptor.DateTimeUtils;
import org.hibernate.type.descriptor.java.PrimitiveByteArrayJavaType;
import org.hibernate.type.descriptor.jdbc.BlobJdbcType;
import org.hibernate.type.descriptor.jdbc.ClobJdbcType;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.JdbcTypeConstructor;
import org.hibernate.type.descriptor.jdbc.ObjectNullAsBinaryTypeJdbcType;
import org.hibernate.type.descriptor.jdbc.SqlTypedJdbcType;
import org.hibernate.type.descriptor.jdbc.XmlJdbcType;
import org.hibernate.type.descriptor.jdbc.spi.JdbcTypeRegistry;
import org.hibernate.type.descriptor.sql.DdlType;
import org.hibernate.type.descriptor.sql.internal.ArrayDdlTypeImpl;
import org.hibernate.type.descriptor.sql.internal.CapacityDependentDdlType;
import org.hibernate.type.descriptor.sql.internal.DdlTypeImpl;
import org.hibernate.type.descriptor.sql.internal.NamedNativeEnumDdlTypeImpl;
import org.hibernate.type.descriptor.sql.internal.NamedNativeOrdinalEnumDdlTypeImpl;
import org.hibernate.type.descriptor.sql.internal.Scale6IntervalSecondDdlType;
import org.hibernate.type.descriptor.sql.spi.DdlTypeRegistry;
import org.hibernate.type.spi.TypeConfiguration;

public class PostgreSQLLegacyDialect
extends Dialect {
    protected final PostgreSQLDriverKind driverKind;
    private final UniqueDelegate uniqueDelegate = new CreateTableUniqueDelegate((Dialect)this);
    private static final ViolatedConstraintNameExtractor EXTRACTOR = new TemplatedViolatedConstraintNameExtractor(sqle -> {
        String sqlState = JdbcExceptionHelper.extractSqlState((SQLException)sqle);
        if (sqlState != null) {
            switch (Integer.parseInt(sqlState)) {
                case 23514: {
                    return TemplatedViolatedConstraintNameExtractor.extractUsingTemplate((String)"violates check constraint \"", (String)"\"", (String)sqle.getMessage());
                }
                case 23505: {
                    return TemplatedViolatedConstraintNameExtractor.extractUsingTemplate((String)"violates unique constraint \"", (String)"\"", (String)sqle.getMessage());
                }
                case 23503: {
                    return TemplatedViolatedConstraintNameExtractor.extractUsingTemplate((String)"violates foreign key constraint \"", (String)"\"", (String)sqle.getMessage());
                }
                case 23502: {
                    return TemplatedViolatedConstraintNameExtractor.extractUsingTemplate((String)"null value in column \"", (String)"\" violates not-null constraint", (String)sqle.getMessage());
                }
                case 23001: {
                    return null;
                }
            }
        }
        return null;
    });

    public PostgreSQLLegacyDialect() {
        this(DatabaseVersion.make((Integer)8, (Integer)0));
    }

    public PostgreSQLLegacyDialect(DialectResolutionInfo info) {
        super(info);
        this.driverKind = PostgreSQLDriverKind.determineKind((DialectResolutionInfo)info);
    }

    public PostgreSQLLegacyDialect(DatabaseVersion version) {
        super(version);
        this.driverKind = PostgreSQLDriverKind.PG_JDBC;
    }

    public PostgreSQLLegacyDialect(DatabaseVersion version, PostgreSQLDriverKind driverKind) {
        super(version);
        this.driverKind = driverKind;
    }

    public boolean getDefaultNonContextualLobCreation() {
        return true;
    }

    protected String columnType(int sqlTypeCode) {
        switch (sqlTypeCode) {
            case -6: {
                return "smallint";
            }
            case -15: {
                return this.columnType(1);
            }
            case -9: {
                return this.columnType(12);
            }
            case 4001: 
            case 4002: {
                return "text";
            }
            case 2004: 
            case 2005: 
            case 2011: {
                return "oid";
            }
            case -3: 
            case -2: 
            case 4003: {
                return "bytea";
            }
            case 3003: {
                return this.columnType(2014);
            }
        }
        return super.columnType(sqlTypeCode);
    }

    protected String castType(int sqlTypeCode) {
        switch (sqlTypeCode) {
            case -15: 
            case -9: 
            case 1: 
            case 12: {
                return "varchar";
            }
            case 4001: 
            case 4002: {
                return "text";
            }
            case -3: 
            case -2: 
            case 4003: {
                return "bytea";
            }
        }
        return super.castType(sqlTypeCode);
    }

    protected void registerColumnTypes(TypeContributions typeContributions, ServiceRegistry serviceRegistry) {
        super.registerColumnTypes(typeContributions, serviceRegistry);
        DdlTypeRegistry ddlTypeRegistry = typeContributions.getTypeConfiguration().getDdlTypeRegistry();
        ddlTypeRegistry.addDescriptor((DdlType)new ArrayDdlTypeImpl((Dialect)this, true));
        ddlTypeRegistry.addDescriptor((DdlType)CapacityDependentDdlType.builder((int)6, (String)this.columnType(6), (String)this.castType(6), (Dialect)this).withTypeCapacity(24L, "float4").build());
        ddlTypeRegistry.addDescriptor((DdlType)new DdlTypeImpl(2009, "xml", (Dialect)this));
        if (this.getVersion().isSameOrAfter(8, 2)) {
            ddlTypeRegistry.addDescriptor((DdlType)new DdlTypeImpl(3000, "uuid", (Dialect)this));
        }
        ddlTypeRegistry.addDescriptor((DdlType)new DdlTypeImpl(3002, "inet", (Dialect)this));
        ddlTypeRegistry.addDescriptor((DdlType)new DdlTypeImpl(3200, "geometry", (Dialect)this));
        ddlTypeRegistry.addDescriptor((DdlType)new DdlTypeImpl(3250, "geography", (Dialect)this));
        ddlTypeRegistry.addDescriptor((DdlType)new Scale6IntervalSecondDdlType((Dialect)this));
        if (this.getVersion().isSameOrAfter(9, 2)) {
            if (this.getVersion().isSameOrAfter(9, 4)) {
                ddlTypeRegistry.addDescriptor((DdlType)new DdlTypeImpl(3001, "jsonb", (Dialect)this));
            } else {
                ddlTypeRegistry.addDescriptor((DdlType)new DdlTypeImpl(3001, "json", (Dialect)this));
            }
        }
        ddlTypeRegistry.addDescriptor((DdlType)new NamedNativeEnumDdlTypeImpl((Dialect)this));
        ddlTypeRegistry.addDescriptor((DdlType)new NamedNativeOrdinalEnumDdlTypeImpl((Dialect)this));
    }

    public int getMaxVarcharLength() {
        return 0xA00000;
    }

    public int getMaxVarcharCapacity() {
        return 0x40000000;
    }

    public int getMaxVarbinaryLength() {
        return Integer.MAX_VALUE;
    }

    public int getDefaultStatementBatchSize() {
        return 15;
    }

    public JdbcType resolveSqlTypeDescriptor(String columnTypeName, int jdbcTypeCode, int precision, int scale, JdbcTypeRegistry jdbcTypeRegistry) {
        switch (jdbcTypeCode) {
            case 1111: {
                switch (columnTypeName) {
                    case "uuid": {
                        jdbcTypeCode = 3000;
                        break;
                    }
                    case "json": 
                    case "jsonb": {
                        jdbcTypeCode = 3001;
                        break;
                    }
                    case "xml": {
                        jdbcTypeCode = 2009;
                        break;
                    }
                    case "inet": {
                        jdbcTypeCode = 3002;
                        break;
                    }
                    case "geometry": {
                        jdbcTypeCode = 3200;
                        break;
                    }
                    case "geography": {
                        jdbcTypeCode = 3250;
                    }
                }
                break;
            }
            case 92: {
                if (!"timetz".equals(columnTypeName)) break;
                jdbcTypeCode = 3007;
                break;
            }
            case 93: {
                if (!"timestamptz".equals(columnTypeName)) break;
                jdbcTypeCode = 3003;
                break;
            }
            case 2003: {
                if (columnTypeName.charAt(0) != '_') break;
                String componentTypeName = columnTypeName.substring(1);
                Integer sqlTypeCode = this.resolveSqlTypeCode(componentTypeName, jdbcTypeRegistry.getTypeConfiguration());
                if (sqlTypeCode != null) {
                    return jdbcTypeRegistry.resolveTypeConstructorDescriptor(jdbcTypeCode, jdbcTypeRegistry.getDescriptor(sqlTypeCode.intValue()), ColumnTypeInformation.EMPTY);
                }
                SqlTypedJdbcType elementDescriptor = jdbcTypeRegistry.findSqlTypedDescriptor(componentTypeName);
                if (elementDescriptor == null) break;
                return jdbcTypeRegistry.resolveTypeConstructorDescriptor(jdbcTypeCode, (JdbcType)elementDescriptor, ColumnTypeInformation.EMPTY);
            }
            case 2002: {
                SqlTypedJdbcType descriptor = jdbcTypeRegistry.findSqlTypedDescriptor(columnTypeName.substring(columnTypeName.indexOf(46) + 1));
                if (descriptor == null) break;
                return descriptor;
            }
        }
        return jdbcTypeRegistry.getDescriptor(jdbcTypeCode);
    }

    protected Integer resolveSqlTypeCode(String columnTypeName, TypeConfiguration typeConfiguration) {
        switch (columnTypeName) {
            case "bool": {
                return 16;
            }
            case "float4": {
                return 7;
            }
            case "float8": {
                return 8;
            }
            case "int2": {
                return 5;
            }
            case "int4": {
                return 4;
            }
            case "int8": {
                return -5;
            }
        }
        return super.resolveSqlTypeCode(columnTypeName, typeConfiguration);
    }

    public String currentTime() {
        return "localtime";
    }

    public String currentTimestamp() {
        return "localtimestamp";
    }

    public String currentTimestampWithTimeZone() {
        return "current_timestamp";
    }

    public String extractPattern(TemporalUnit unit) {
        switch (unit) {
            case DAY_OF_WEEK: {
                return "(" + super.extractPattern(unit) + "+1)";
            }
        }
        return super.extractPattern(unit);
    }

    public String castPattern(CastType from, CastType to) {
        if (from == CastType.STRING && to == CastType.BOOLEAN) {
            return "cast(?1 as ?2)";
        }
        return super.castPattern(from, to);
    }

    public long getFractionalSecondPrecisionInNanos() {
        return 1000000000L;
    }

    public String timestampaddPattern(TemporalUnit unit, TemporalType temporalType, IntervalType intervalType) {
        if (intervalType != null) {
            return "(?2+?3)";
        }
        switch (unit) {
            case NANOSECOND: {
                return "(?3+(?2)/1e3*interval '1 microsecond')";
            }
            case NATIVE: {
                return "(?3+(?2)*interval '1 second')";
            }
            case QUARTER: {
                return "(?3+(?2)*interval '3 month')";
            }
            case WEEK: {
                return "(?3+(?2)*interval '7 day')";
            }
        }
        return "(?3+(?2)*interval '1 ?1')";
    }

    public String timestampdiffPattern(TemporalUnit unit, TemporalType fromTemporalType, TemporalType toTemporalType) {
        if (unit == null) {
            return "(?3-?2)";
        }
        if (toTemporalType == TemporalType.DATE && fromTemporalType == TemporalType.DATE) {
            switch (unit) {
                case QUARTER: 
                case YEAR: 
                case MONTH: {
                    return "extract(" + this.translateDurationField(unit) + " from age(?3,?2))";
                }
            }
            return "(?3-?2)" + TemporalUnit.DAY.conversionFactor(unit, (Dialect)this);
        }
        switch (unit) {
            case YEAR: {
                return "extract(year from ?3-?2)";
            }
            case QUARTER: {
                return "(extract(year from ?3-?2)*4+extract(month from ?3-?2)/3)";
            }
            case MONTH: {
                return "(extract(year from ?3-?2)*12+extract(month from ?3-?2))";
            }
            case WEEK: {
                return "(extract(day from ?3-?2)/7)";
            }
            case DAY: {
                return "extract(day from ?3-?2)";
            }
            case NANOSECOND: 
            case NATIVE: 
            case HOUR: 
            case MINUTE: 
            case SECOND: {
                return "extract(epoch from ?3-?2)" + TemporalUnit.EPOCH.conversionFactor(unit, (Dialect)this);
            }
        }
        throw new SemanticException("unrecognized field: " + unit);
    }

    @Deprecated
    protected void extractField(StringBuilder pattern, TemporalUnit unit, TemporalType fromTimestamp, TemporalType toTimestamp, TemporalUnit toUnit) {
        pattern.append("extract(");
        pattern.append(this.translateDurationField(unit));
        pattern.append(" from ");
        if (toTimestamp == TemporalType.DATE && fromTimestamp == TemporalType.DATE) {
            pattern.append("age(?3,?2)");
        } else {
            switch (unit) {
                case QUARTER: 
                case YEAR: 
                case MONTH: {
                    pattern.append("age(?3,?2)");
                    break;
                }
                case DAY: 
                case HOUR: 
                case MINUTE: 
                case SECOND: 
                case EPOCH: {
                    pattern.append("?3-?2");
                    break;
                }
                default: {
                    throw new SemanticException(unit + " is not a legal field");
                }
            }
        }
        pattern.append(")").append(unit.conversionFactor(toUnit, (Dialect)this));
    }

    public TimeZoneSupport getTimeZoneSupport() {
        return TimeZoneSupport.NORMALIZE;
    }

    public void initializeFunctionRegistry(FunctionContributions functionContributions) {
        super.initializeFunctionRegistry(functionContributions);
        CommonFunctionFactory functionFactory = new CommonFunctionFactory(functionContributions);
        functionFactory.cot();
        functionFactory.radians();
        functionFactory.degrees();
        functionFactory.log();
        functionFactory.mod_operator();
        if (this.getVersion().isSameOrAfter(12)) {
            functionFactory.log10();
            functionFactory.tanh();
            functionFactory.sinh();
            functionFactory.cosh();
            functionFactory.moreHyperbolic();
        } else {
            functionContributions.getFunctionRegistry().registerAlternateKey("log10", "log");
        }
        functionFactory.cbrt();
        functionFactory.pi();
        functionFactory.trim2();
        functionFactory.repeat();
        functionFactory.md5();
        functionFactory.initcap();
        functionFactory.substr();
        functionFactory.substring_substr();
        functionFactory.translate();
        functionFactory.toCharNumberDateTimestamp();
        functionFactory.concat_pipeOperator("convert_from(lo_get(?1),pg_client_encoding())");
        functionFactory.localtimeLocaltimestamp();
        functionFactory.length_characterLength_pattern("length(lo_get(?1),pg_client_encoding())");
        functionFactory.bitLength_pattern("bit_length(?1)", "length(lo_get(?1))*8");
        functionFactory.octetLength_pattern("octet_length(?1)", "length(lo_get(?1))");
        functionFactory.ascii();
        functionFactory.char_chr();
        functionFactory.position();
        functionFactory.bitandorxornot_operator();
        functionFactory.bitAndOr();
        functionFactory.everyAny_boolAndOr();
        functionFactory.median_percentileCont(false);
        functionFactory.stddev();
        functionFactory.stddevPopSamp();
        functionFactory.variance();
        functionFactory.varPopSamp();
        functionFactory.covarPopSamp();
        functionFactory.corr();
        functionFactory.regrLinearRegressionAggregates();
        functionFactory.insert_overlay();
        functionFactory.overlay();
        functionFactory.soundex();
        functionFactory.locate_positionSubstring();
        functionFactory.windowFunctions();
        functionFactory.listagg_stringAgg("varchar");
        functionFactory.array_postgresql();
        functionFactory.arrayAggregate();
        functionFactory.arrayPosition_postgresql();
        functionFactory.arrayPositions_postgresql();
        functionFactory.arrayLength_cardinality();
        functionFactory.arrayConcat_postgresql();
        functionFactory.arrayPrepend_postgresql();
        functionFactory.arrayAppend_postgresql();
        functionFactory.arrayContains_postgresql();
        functionFactory.arrayIntersects_postgresql();
        functionFactory.arrayGet_bracket();
        functionFactory.arraySet_unnest();
        functionFactory.arrayRemove();
        functionFactory.arrayRemoveIndex_unnest(true);
        functionFactory.arraySlice_operator();
        functionFactory.arrayReplace();
        if (this.getVersion().isSameOrAfter(14)) {
            functionFactory.arrayTrim_trim_array();
        } else {
            functionFactory.arrayTrim_unnest();
        }
        functionFactory.arrayFill_postgresql();
        functionFactory.arrayToString_postgresql();
        if (this.getVersion().isSameOrAfter(9, 4)) {
            functionFactory.makeDateTimeTimestamp();
            functionFactory.inverseDistributionOrderedSetAggregates();
            functionFactory.hypotheticalOrderedSetAggregates();
        }
        if (!this.supportsMinMaxOnUuid()) {
            functionContributions.getFunctionRegistry().register("min", (SqmFunctionDescriptor)new PostgreSQLMinMaxFunction("min"));
            functionContributions.getFunctionRegistry().register("max", (SqmFunctionDescriptor)new PostgreSQLMinMaxFunction("max"));
        }
        functionContributions.getFunctionRegistry().patternDescriptorBuilder("bitxor", "(?1#?2)").setExactArgumentCount(2).setArgumentTypeResolver(StandardFunctionArgumentTypeResolvers.ARGUMENT_OR_IMPLIED_RESULT_TYPE).register();
        functionContributions.getFunctionRegistry().register("round", (SqmFunctionDescriptor)new PostgreSQLTruncRoundFunction("round", true));
        functionContributions.getFunctionRegistry().register("trunc", (SqmFunctionDescriptor)new PostgreSQLTruncFunction(true, functionContributions.getTypeConfiguration()));
        functionContributions.getFunctionRegistry().registerAlternateKey("truncate", "trunc");
        functionFactory.dateTrunc();
    }

    protected boolean supportsMinMaxOnUuid() {
        return false;
    }

    public NameQualifierSupport getNameQualifierSupport() {
        return NameQualifierSupport.SCHEMA;
    }

    public String getCurrentSchemaCommand() {
        return "select current_schema()";
    }

    public boolean supportsDistinctFromPredicate() {
        return true;
    }

    public boolean supportsIfExistsBeforeTableName() {
        return this.getVersion().isSameOrAfter(8, 2);
    }

    public boolean supportsIfExistsBeforeTypeName() {
        return this.getVersion().isSameOrAfter(8, 2);
    }

    public boolean supportsIfExistsBeforeConstraintName() {
        return this.getVersion().isSameOrAfter(9);
    }

    public boolean supportsIfExistsAfterAlterTable() {
        return this.getVersion().isSameOrAfter(9, 2);
    }

    public boolean supportsValuesList() {
        return this.getVersion().isSameOrAfter(8, 2);
    }

    public boolean supportsPartitionBy() {
        return this.getVersion().isSameOrAfter(9, 1);
    }

    public boolean supportsNonQueryWithCTE() {
        return this.getVersion().isSameOrAfter(9, 1);
    }

    public boolean supportsConflictClauseForInsertCTE() {
        return this.getVersion().isSameOrAfter(9, 5);
    }

    public SequenceSupport getSequenceSupport() {
        return this.getVersion().isBefore(8, 2) ? PostgreSQLLegacySequenceSupport.LEGACY_INSTANCE : PostgreSQLSequenceSupport.INSTANCE;
    }

    public String getCascadeConstraintsString() {
        return " cascade";
    }

    public String getQuerySequencesString() {
        return "select * from information_schema.sequences";
    }

    public LimitHandler getLimitHandler() {
        return this.getVersion().isBefore(8, 4) ? LimitOffsetLimitHandler.OFFSET_ONLY_INSTANCE : OffsetFetchLimitHandler.INSTANCE;
    }

    public String getForUpdateString(String aliases) {
        return this.getForUpdateString() + " of " + aliases;
    }

    public String getForUpdateString(String aliases, LockOptions lockOptions) {
        LockMode lockMode;
        if (aliases.isEmpty()) {
            lockMode = lockOptions.getLockMode();
            for (Map.Entry entry : lockOptions.getAliasSpecificLocks()) {
                if (!((LockMode)entry.getValue()).greaterThan(lockMode)) continue;
                aliases = (String)entry.getKey();
            }
        }
        if ((lockMode = lockOptions.getAliasSpecificLockMode(aliases)) == null) {
            lockMode = lockOptions.getLockMode();
        }
        switch (lockMode) {
            case PESSIMISTIC_READ: {
                return this.getReadLockString(aliases, lockOptions.getTimeOut());
            }
            case PESSIMISTIC_WRITE: {
                return this.getWriteLockString(aliases, lockOptions.getTimeOut());
            }
            case UPGRADE_NOWAIT: 
            case PESSIMISTIC_FORCE_INCREMENT: {
                return this.getForUpdateNowaitString(aliases);
            }
            case UPGRADE_SKIPLOCKED: {
                return this.getForUpdateSkipLockedString(aliases);
            }
        }
        return "";
    }

    public String getNoColumnsInsertString() {
        return "default values";
    }

    public String getCaseInsensitiveLike() {
        return "ilike";
    }

    public boolean supportsCaseInsensitiveLike() {
        return true;
    }

    public String getNativeIdentifierGeneratorStrategy() {
        return "sequence";
    }

    public boolean supportsOuterJoinForUpdate() {
        return false;
    }

    public boolean useInputStreamToInsertBlob() {
        return false;
    }

    public boolean useConnectionToCreateLob() {
        return false;
    }

    public String getSelectClauseNullString(int sqlType, TypeConfiguration typeConfiguration) {
        return "cast(null as " + typeConfiguration.getDdlTypeRegistry().getDescriptor(sqlType).getRawTypeName() + ")";
    }

    public String getSelectClauseNullString(SqlTypedMapping sqlType, TypeConfiguration typeConfiguration) {
        String castTypeName = typeConfiguration.getDdlTypeRegistry().getDescriptor(sqlType.getJdbcMapping().getJdbcType().getDdlTypeCode()).getCastTypeName(sqlType.toSize(), (SqlExpressible)sqlType.getJdbcMapping(), typeConfiguration.getDdlTypeRegistry());
        return "cast(null as " + castTypeName + ")";
    }

    public boolean supportsCommentOn() {
        return true;
    }

    public boolean supportsCurrentTimestampSelection() {
        return true;
    }

    public boolean isCurrentTimestampSelectStringCallable() {
        return false;
    }

    public String getCurrentTimestampSelectString() {
        return "select now()";
    }

    public boolean supportsTupleCounts() {
        return true;
    }

    public boolean requiresParensForTupleDistinctCounts() {
        return true;
    }

    public void appendBooleanValueString(SqlAppender appender, boolean bool) {
        appender.appendSql(bool);
    }

    public IdentifierHelper buildIdentifierHelper(IdentifierHelperBuilder builder, DatabaseMetaData dbMetaData) throws SQLException {
        if (dbMetaData == null) {
            builder.setUnquotedCaseStrategy(IdentifierCaseStrategy.LOWER);
            builder.setQuotedCaseStrategy(IdentifierCaseStrategy.MIXED);
        }
        return super.buildIdentifierHelper(builder, dbMetaData);
    }

    public SqmMultiTableMutationStrategy getFallbackSqmMutationStrategy(EntityMappingType rootEntityDescriptor, RuntimeModelCreationContext runtimeModelCreationContext) {
        return new CteMutationStrategy(rootEntityDescriptor, runtimeModelCreationContext);
    }

    public SqmMultiTableInsertStrategy getFallbackSqmInsertStrategy(EntityMappingType rootEntityDescriptor, RuntimeModelCreationContext runtimeModelCreationContext) {
        return new CteInsertStrategy(rootEntityDescriptor, runtimeModelCreationContext);
    }

    public SqlAstTranslatorFactory getSqlAstTranslatorFactory() {
        return new StandardSqlAstTranslatorFactory(){

            protected <T extends JdbcOperation> SqlAstTranslator<T> buildTranslator(SessionFactoryImplementor sessionFactory, Statement statement) {
                return new PostgreSQLLegacySqlAstTranslator(sessionFactory, statement);
            }
        };
    }

    public ViolatedConstraintNameExtractor getViolatedConstraintNameExtractor() {
        return EXTRACTOR;
    }

    public SQLExceptionConversionDelegate buildSQLExceptionConversionDelegate() {
        return (sqlException, message, sql) -> {
            String sqlState = JdbcExceptionHelper.extractSqlState((SQLException)sqlException);
            if (sqlState != null) {
                switch (sqlState) {
                    case "40P01": {
                        return new LockAcquisitionException(message, sqlException, sql);
                    }
                    case "55P03": {
                        return new PessimisticLockException(message, sqlException, sql);
                    }
                    case "57014": {
                        return new QueryTimeoutException(message, sqlException, sql);
                    }
                }
            }
            return null;
        };
    }

    public int registerResultSetOutParameter(CallableStatement statement, int col) throws SQLException {
        statement.registerOutParameter(col++, 1111);
        return col;
    }

    public ResultSet getResultSet(CallableStatement ps) throws SQLException {
        ps.execute();
        return (ResultSet)ps.getObject(1);
    }

    public boolean supportsLobValueChangePropagation() {
        return false;
    }

    public boolean supportsUnboundedLobLocatorMaterialization() {
        return false;
    }

    public SelectItemReferenceStrategy getGroupBySelectItemReferenceStrategy() {
        return SelectItemReferenceStrategy.POSITION;
    }

    public CallableStatementSupport getCallableStatementSupport() {
        return this.getVersion().isSameOrAfter(11) ? PostgreSQLCallableStatementSupport.INSTANCE : PostgreSQLCallableStatementSupport.V10_INSTANCE;
    }

    public ResultSet getResultSet(CallableStatement statement, int position) throws SQLException {
        if (position != 1) {
            throw new UnsupportedOperationException("PostgreSQL only supports REF_CURSOR parameters as the first parameter");
        }
        return (ResultSet)statement.getObject(1);
    }

    public ResultSet getResultSet(CallableStatement statement, String name) throws SQLException {
        throw new UnsupportedOperationException("PostgreSQL only supports accessing REF_CURSOR parameters by position");
    }

    public boolean qualifyIndexName() {
        return false;
    }

    public IdentityColumnSupport getIdentityColumnSupport() {
        return PostgreSQLIdentityColumnSupport.INSTANCE;
    }

    public NationalizationSupport getNationalizationSupport() {
        return NationalizationSupport.IMPLICIT;
    }

    public int getMaxIdentifierLength() {
        return 63;
    }

    public boolean supportsStandardArrays() {
        return true;
    }

    public boolean supportsJdbcConnectionLobCreation(DatabaseMetaData databaseMetaData) {
        return false;
    }

    public boolean supportsMaterializedLobAccess() {
        return false;
    }

    public boolean supportsTemporalLiteralOffset() {
        return true;
    }

    public void appendDatetimeFormat(SqlAppender appender, String format) {
        appender.appendSql(this.datetimeFormat(format).result());
    }

    public Replacer datetimeFormat(String format) {
        return OracleDialect.datetimeFormat((String)format, (boolean)true, (boolean)false).replace("SSSSSS", "US").replace("SSSSS", "US").replace("SSSS", "US").replace("SSS", "MS").replace("SS", "MS").replace("S", "MS").replace("ee", "ID").replace("e", "fmID").replace("zzz", "TZ").replace("zz", "TZ").replace("z", "TZ").replace("xxx", "OF").replace("xx", "OF").replace("x", "OF");
    }

    public String translateExtractField(TemporalUnit unit) {
        switch (unit) {
            case DAY_OF_MONTH: {
                return "day";
            }
            case DAY_OF_YEAR: {
                return "doy";
            }
            case DAY_OF_WEEK: {
                return "dow";
            }
        }
        return super.translateExtractField(unit);
    }

    public AggregateSupport getAggregateSupport() {
        return PostgreSQLAggregateSupport.valueOf((Dialect)this);
    }

    public void appendBinaryLiteral(SqlAppender appender, byte[] bytes) {
        appender.appendSql("bytea '\\x");
        PrimitiveByteArrayJavaType.INSTANCE.appendString(appender, bytes);
        appender.appendSql('\'');
    }

    public void appendDateTimeLiteral(SqlAppender appender, TemporalAccessor temporalAccessor, TemporalType precision, TimeZone jdbcTimeZone) {
        switch (precision) {
            case DATE: {
                appender.appendSql("date '");
                DateTimeUtils.appendAsDate((SqlAppender)appender, (TemporalAccessor)temporalAccessor);
                appender.appendSql('\'');
                break;
            }
            case TIME: {
                if (this.supportsTemporalLiteralOffset() && temporalAccessor.isSupported(ChronoField.OFFSET_SECONDS)) {
                    appender.appendSql("time with time zone '");
                    DateTimeUtils.appendAsTime((SqlAppender)appender, (TemporalAccessor)temporalAccessor, (boolean)true, (TimeZone)jdbcTimeZone);
                } else {
                    appender.appendSql("time '");
                    DateTimeUtils.appendAsLocalTime((SqlAppender)appender, (TemporalAccessor)temporalAccessor);
                }
                appender.appendSql('\'');
                break;
            }
            case TIMESTAMP: {
                if (this.supportsTemporalLiteralOffset() && temporalAccessor.isSupported(ChronoField.OFFSET_SECONDS)) {
                    appender.appendSql("timestamp with time zone '");
                    DateTimeUtils.appendAsTimestampWithMicros((SqlAppender)appender, (TemporalAccessor)temporalAccessor, (boolean)true, (TimeZone)jdbcTimeZone);
                    appender.appendSql('\'');
                    break;
                }
                appender.appendSql("timestamp '");
                DateTimeUtils.appendAsTimestampWithMicros((SqlAppender)appender, (TemporalAccessor)temporalAccessor, (boolean)false, (TimeZone)jdbcTimeZone);
                appender.appendSql('\'');
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    public void appendDateTimeLiteral(SqlAppender appender, Date date, TemporalType precision, TimeZone jdbcTimeZone) {
        switch (precision) {
            case DATE: {
                appender.appendSql("date '");
                DateTimeUtils.appendAsDate((SqlAppender)appender, (Date)date);
                appender.appendSql('\'');
                break;
            }
            case TIME: {
                appender.appendSql("time with time zone '");
                DateTimeUtils.appendAsTime((SqlAppender)appender, (Date)date, (TimeZone)jdbcTimeZone);
                appender.appendSql('\'');
                break;
            }
            case TIMESTAMP: {
                appender.appendSql("timestamp with time zone '");
                DateTimeUtils.appendAsTimestampWithMicros((SqlAppender)appender, (Date)date, (TimeZone)jdbcTimeZone);
                appender.appendSql('\'');
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    public void appendDateTimeLiteral(SqlAppender appender, Calendar calendar, TemporalType precision, TimeZone jdbcTimeZone) {
        switch (precision) {
            case DATE: {
                appender.appendSql("date '");
                DateTimeUtils.appendAsDate((SqlAppender)appender, (Calendar)calendar);
                appender.appendSql('\'');
                break;
            }
            case TIME: {
                appender.appendSql("time with time zone '");
                DateTimeUtils.appendAsTime((SqlAppender)appender, (Calendar)calendar, (TimeZone)jdbcTimeZone);
                appender.appendSql('\'');
                break;
            }
            case TIMESTAMP: {
                appender.appendSql("timestamp with time zone '");
                DateTimeUtils.appendAsTimestampWithMillis((SqlAppender)appender, (Calendar)calendar, (TimeZone)jdbcTimeZone);
                appender.appendSql('\'');
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    private String withTimeout(String lockString, int timeout) {
        switch (timeout) {
            case 0: {
                return this.supportsNoWait() ? lockString + " nowait" : lockString;
            }
            case -2: {
                return this.supportsSkipLocked() ? lockString + " skip locked" : lockString;
            }
        }
        return lockString;
    }

    public String getWriteLockString(int timeout) {
        return this.withTimeout(this.getForUpdateString(), timeout);
    }

    public String getWriteLockString(String aliases, int timeout) {
        return this.withTimeout(this.getForUpdateString(aliases), timeout);
    }

    public String getReadLockString(int timeout) {
        return this.withTimeout(" for share", timeout);
    }

    public String getReadLockString(String aliases, int timeout) {
        return this.withTimeout(" for share of " + aliases, timeout);
    }

    public String getForUpdateNowaitString() {
        return this.supportsNoWait() ? " for update nowait" : this.getForUpdateString();
    }

    public String getForUpdateNowaitString(String aliases) {
        return this.supportsNoWait() ? " for update of " + aliases + " nowait" : this.getForUpdateString(aliases);
    }

    public String getForUpdateSkipLockedString() {
        return this.supportsSkipLocked() ? " for update skip locked" : this.getForUpdateString();
    }

    public String getForUpdateSkipLockedString(String aliases) {
        return this.supportsSkipLocked() ? " for update of " + aliases + " skip locked" : this.getForUpdateString(aliases);
    }

    public boolean supportsNoWait() {
        return this.getVersion().isSameOrAfter(8, 1);
    }

    public boolean supportsWait() {
        return false;
    }

    public boolean supportsSkipLocked() {
        return this.getVersion().isSameOrAfter(9, 5);
    }

    public boolean supportsOffsetInSubquery() {
        return true;
    }

    public boolean supportsWindowFunctions() {
        return true;
    }

    public boolean supportsLateral() {
        return this.getVersion().isSameOrAfter(9, 3);
    }

    public boolean supportsRecursiveCTE() {
        return true;
    }

    public boolean supportsFetchClause(FetchClauseType type) {
        switch (type) {
            case ROWS_ONLY: {
                return this.getVersion().isSameOrAfter(8, 4);
            }
            case PERCENT_ONLY: 
            case PERCENT_WITH_TIES: {
                return false;
            }
            case ROWS_WITH_TIES: {
                return this.getVersion().isSameOrAfter(13);
            }
        }
        return false;
    }

    public FunctionalDependencyAnalysisSupport getFunctionalDependencyAnalysisSupport() {
        return FunctionalDependencyAnalysisSupportImpl.TABLE_REFERENCE;
    }

    public RowLockStrategy getWriteRowLockStrategy() {
        return RowLockStrategy.TABLE;
    }

    public void augmentRecognizedTableTypes(List<String> tableTypesList) {
        super.augmentRecognizedTableTypes(tableTypesList);
        if (this.getVersion().isSameOrAfter(9, 3)) {
            tableTypesList.add("MATERIALIZED VIEW");
            if (this.getVersion().isSameOrAfter(10)) {
                tableTypesList.add("PARTITIONED TABLE");
            }
        }
    }

    public void contributeTypes(TypeContributions typeContributions, ServiceRegistry serviceRegistry) {
        super.contributeTypes(typeContributions, serviceRegistry);
        this.contributePostgreSQLTypes(typeContributions, serviceRegistry);
    }

    protected void contributePostgreSQLTypes(TypeContributions typeContributions, ServiceRegistry serviceRegistry) {
        JdbcTypeRegistry jdbcTypeRegistry = typeContributions.getTypeConfiguration().getJdbcTypeRegistry();
        jdbcTypeRegistry.addDescriptor(2004, (JdbcType)BlobJdbcType.BLOB_BINDING);
        jdbcTypeRegistry.addDescriptor(2005, (JdbcType)ClobJdbcType.CLOB_BINDING);
        jdbcTypeRegistry.addDescriptor((JdbcType)XmlJdbcType.INSTANCE);
        if (this.driverKind == PostgreSQLDriverKind.PG_JDBC) {
            if (PgJdbcHelper.isUsable((ServiceRegistry)serviceRegistry)) {
                jdbcTypeRegistry.addDescriptorIfAbsent(PgJdbcHelper.getInetJdbcType((ServiceRegistry)serviceRegistry));
                jdbcTypeRegistry.addDescriptorIfAbsent(PgJdbcHelper.getIntervalJdbcType((ServiceRegistry)serviceRegistry));
                jdbcTypeRegistry.addDescriptorIfAbsent(PgJdbcHelper.getStructJdbcType((ServiceRegistry)serviceRegistry));
            } else {
                jdbcTypeRegistry.addDescriptorIfAbsent((JdbcType)PostgreSQLCastingInetJdbcType.INSTANCE);
                jdbcTypeRegistry.addDescriptorIfAbsent((JdbcType)PostgreSQLCastingIntervalSecondJdbcType.INSTANCE);
                jdbcTypeRegistry.addDescriptorIfAbsent((JdbcType)PostgreSQLStructCastingJdbcType.INSTANCE);
            }
            jdbcTypeRegistry.addDescriptor((JdbcType)PostgreSQLEnumJdbcType.INSTANCE);
            jdbcTypeRegistry.addDescriptor((JdbcType)PostgreSQLOrdinalEnumJdbcType.INSTANCE);
            if (this.getVersion().isSameOrAfter(8, 2)) {
                jdbcTypeRegistry.addDescriptorIfAbsent((JdbcType)PostgreSQLUUIDJdbcType.INSTANCE);
                if (this.getVersion().isSameOrAfter(9, 2)) {
                    if (this.getVersion().isSameOrAfter(9, 4)) {
                        if (PgJdbcHelper.isUsable((ServiceRegistry)serviceRegistry)) {
                            jdbcTypeRegistry.addDescriptorIfAbsent(PgJdbcHelper.getJsonbJdbcType((ServiceRegistry)serviceRegistry));
                        } else {
                            jdbcTypeRegistry.addDescriptorIfAbsent((JdbcType)PostgreSQLCastingJsonJdbcType.JSONB_INSTANCE);
                        }
                    } else if (PgJdbcHelper.isUsable((ServiceRegistry)serviceRegistry)) {
                        jdbcTypeRegistry.addDescriptorIfAbsent(PgJdbcHelper.getJsonJdbcType((ServiceRegistry)serviceRegistry));
                    } else {
                        jdbcTypeRegistry.addDescriptorIfAbsent((JdbcType)PostgreSQLCastingJsonJdbcType.JSON_INSTANCE);
                    }
                }
            }
        } else {
            jdbcTypeRegistry.addDescriptorIfAbsent((JdbcType)PostgreSQLCastingInetJdbcType.INSTANCE);
            jdbcTypeRegistry.addDescriptorIfAbsent((JdbcType)PostgreSQLCastingIntervalSecondJdbcType.INSTANCE);
            jdbcTypeRegistry.addDescriptorIfAbsent((JdbcType)PostgreSQLStructCastingJdbcType.INSTANCE);
            if (this.getVersion().isSameOrAfter(8, 2)) {
                jdbcTypeRegistry.addDescriptorIfAbsent((JdbcType)PostgreSQLUUIDJdbcType.INSTANCE);
                if (this.getVersion().isSameOrAfter(9, 2)) {
                    if (this.getVersion().isSameOrAfter(9, 4)) {
                        jdbcTypeRegistry.addDescriptorIfAbsent((JdbcType)PostgreSQLCastingJsonJdbcType.JSONB_INSTANCE);
                    } else {
                        jdbcTypeRegistry.addDescriptorIfAbsent((JdbcType)PostgreSQLCastingJsonJdbcType.JSON_INSTANCE);
                    }
                }
            }
        }
        typeContributions.contributeJdbcType((JdbcType)ObjectNullAsBinaryTypeJdbcType.INSTANCE);
        typeContributions.contributeType((BasicType)new JavaObjectType((JdbcType)ObjectNullAsBinaryTypeJdbcType.INSTANCE, typeContributions.getTypeConfiguration().getJavaTypeRegistry().getDescriptor(Object.class)));
        jdbcTypeRegistry.addTypeConstructor((JdbcTypeConstructor)PostgreSQLArrayJdbcTypeConstructor.INSTANCE);
    }

    public UniqueDelegate getUniqueDelegate() {
        return this.uniqueDelegate;
    }

    public boolean canBatchTruncate() {
        return true;
    }

    public String rowId(String rowId) {
        return "ctid";
    }

    public int rowIdSqlType() {
        return 1111;
    }

    public String getQueryHintString(String sql, String hints) {
        return "/*+ " + hints + " */ " + sql;
    }

    public String addSqlHintOrComment(String sql, QueryOptions queryOptions, boolean commentsEnabled) {
        if (commentsEnabled && queryOptions.getComment() != null) {
            sql = this.prependComment(sql, queryOptions.getComment());
        }
        if (queryOptions.getDatabaseHints() != null && queryOptions.getDatabaseHints().size() > 0) {
            sql = this.getQueryHintString(sql, queryOptions.getDatabaseHints());
        }
        return sql;
    }

    public int getDefaultIntervalSecondScale() {
        return 6;
    }

    public DmlTargetColumnQualifierSupport getDmlTargetColumnQualifierSupport() {
        return DmlTargetColumnQualifierSupport.TABLE_ALIAS;
    }

    public boolean supportsFromClauseInUpdate() {
        return true;
    }
}

