/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.community.dialect;

import jakarta.persistence.TemporalType;
import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.hibernate.boot.model.FunctionContributions;
import org.hibernate.community.dialect.PostgreSQLLegacyDialect;
import org.hibernate.community.dialect.PostgreSQLLegacySqlAstTranslator;
import org.hibernate.dialect.DatabaseVersion;
import org.hibernate.dialect.function.CommonFunctionFactory;
import org.hibernate.engine.jdbc.dialect.spi.DialectResolutionInfo;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.query.sqm.CastType;
import org.hibernate.query.sqm.TemporalUnit;
import org.hibernate.query.sqm.produce.function.StandardFunctionArgumentTypeResolvers;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.SqlAstTranslatorFactory;
import org.hibernate.sql.ast.spi.StandardSqlAstTranslatorFactory;
import org.hibernate.sql.ast.tree.Statement;
import org.hibernate.sql.ast.tree.expression.BinaryArithmeticExpression;
import org.hibernate.sql.exec.spi.JdbcOperation;

public class PostgresPlusLegacyDialect
extends PostgreSQLLegacyDialect {
    public PostgresPlusLegacyDialect() {
    }

    public PostgresPlusLegacyDialect(DialectResolutionInfo info) {
        super(info);
    }

    public PostgresPlusLegacyDialect(DatabaseVersion version) {
        super(version);
    }

    @Override
    public void initializeFunctionRegistry(FunctionContributions functionContributions) {
        super.initializeFunctionRegistry(functionContributions);
        CommonFunctionFactory functionFactory = new CommonFunctionFactory(functionContributions);
        functionFactory.soundex();
        functionFactory.rownumRowid();
        functionFactory.sysdate();
        functionFactory.systimestamp();
        if (this.getVersion().isSameOrAfter(14)) {
            functionFactory.bitand();
            functionFactory.bitor();
            functionContributions.getFunctionRegistry().patternDescriptorBuilder("bitxor", "(bitor(?1,?2)-bitand(?1,?2))").setExactArgumentCount(2).setArgumentTypeResolver(StandardFunctionArgumentTypeResolvers.ARGUMENT_OR_IMPLIED_RESULT_TYPE).register();
        }
    }

    public String castPattern(CastType from, CastType to) {
        if (to == CastType.STRING) {
            switch (from) {
                case DATE: {
                    return "to_char(?1,'YYYY-MM-DD')";
                }
                case TIME: {
                    return "to_char(?1,'HH24:MI:SS')";
                }
                case TIMESTAMP: {
                    return "to_char(?1,'YYYY-MM-DD HH24:MI:SS.FF9')";
                }
                case OFFSET_TIMESTAMP: {
                    return "to_char(?1,'YYYY-MM-DD HH24:MI:SS.FF9TZH:TZM')";
                }
                case ZONE_TIMESTAMP: {
                    return "to_char(?1,'YYYY-MM-DD HH24:MI:SS.FF9 TZR')";
                }
            }
        }
        return super.castPattern(from, to);
    }

    @Override
    public String currentTimestamp() {
        return "current_timestamp";
    }

    @Override
    public String timestampdiffPattern(TemporalUnit unit, TemporalType fromTemporalType, TemporalType toTemporalType) {
        if (toTemporalType == TemporalType.DATE && fromTemporalType == TemporalType.DATE) {
            return super.timestampdiffPattern(unit, TemporalType.TIMESTAMP, TemporalType.TIMESTAMP);
        }
        return super.timestampdiffPattern(unit, fromTemporalType, toTemporalType);
    }

    @Override
    public int registerResultSetOutParameter(CallableStatement statement, int col) throws SQLException {
        statement.registerOutParameter(col, 2006);
        return ++col;
    }

    @Override
    public ResultSet getResultSet(CallableStatement ps) throws SQLException {
        ps.execute();
        return (ResultSet)ps.getObject(1);
    }

    public String getSelectGUIDString() {
        return "select uuid_generate_v1";
    }

    @Override
    public SqlAstTranslatorFactory getSqlAstTranslatorFactory() {
        return new StandardSqlAstTranslatorFactory(){

            protected <T extends JdbcOperation> SqlAstTranslator<T> buildTranslator(SessionFactoryImplementor sessionFactory, Statement statement) {
                return new PostgreSQLLegacySqlAstTranslator<T>(sessionFactory, statement){

                    @Override
                    public void visitBinaryArithmeticExpression(BinaryArithmeticExpression arithmeticExpression) {
                        if (this.isIntegerDivisionEmulationRequired(arithmeticExpression)) {
                            this.appendSql("floor");
                        }
                        super.visitBinaryArithmeticExpression(arithmeticExpression);
                    }
                };
            }
        };
    }
}

