/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.community.dialect;

import jakarta.persistence.TemporalType;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.time.temporal.TemporalAccessor;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.hibernate.boot.model.FunctionContributions;
import org.hibernate.boot.model.TypeContributions;
import org.hibernate.community.dialect.SybaseLegacySqlAstTranslator;
import org.hibernate.community.dialect.SybaseLegacySqmToSqlAstConverter;
import org.hibernate.dialect.AbstractTransactSQLDialect;
import org.hibernate.dialect.DatabaseVersion;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.DmlTargetColumnQualifierSupport;
import org.hibernate.dialect.NationalizationSupport;
import org.hibernate.dialect.SybaseDriverKind;
import org.hibernate.dialect.function.CommonFunctionFactory;
import org.hibernate.dialect.function.CountFunction;
import org.hibernate.dialect.function.IntegralTimestampaddFunction;
import org.hibernate.dialect.function.SybaseTruncFunction;
import org.hibernate.dialect.unique.SkipNullableUniqueDelegate;
import org.hibernate.dialect.unique.UniqueDelegate;
import org.hibernate.engine.jdbc.dialect.spi.DialectResolutionInfo;
import org.hibernate.engine.jdbc.env.spi.IdentifierCaseStrategy;
import org.hibernate.engine.jdbc.env.spi.IdentifierHelper;
import org.hibernate.engine.jdbc.env.spi.IdentifierHelperBuilder;
import org.hibernate.engine.jdbc.env.spi.NameQualifierSupport;
import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.procedure.internal.JTDSCallableStatementSupport;
import org.hibernate.procedure.internal.SybaseCallableStatementSupport;
import org.hibernate.procedure.spi.CallableStatementSupport;
import org.hibernate.query.spi.QueryOptions;
import org.hibernate.query.spi.QueryParameterBindings;
import org.hibernate.query.sqm.CastType;
import org.hibernate.query.sqm.IntervalType;
import org.hibernate.query.sqm.TemporalUnit;
import org.hibernate.query.sqm.function.SqmFunctionDescriptor;
import org.hibernate.query.sqm.internal.DomainParameterXref;
import org.hibernate.query.sqm.sql.SqmTranslator;
import org.hibernate.query.sqm.sql.SqmTranslatorFactory;
import org.hibernate.query.sqm.sql.StandardSqmTranslatorFactory;
import org.hibernate.query.sqm.tree.SqmStatement;
import org.hibernate.query.sqm.tree.select.SqmSelectStatement;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.sql.ast.SqlAstNodeRenderingMode;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.SqlAstTranslatorFactory;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.spi.SqlAstCreationContext;
import org.hibernate.sql.ast.spi.StandardSqlAstTranslatorFactory;
import org.hibernate.sql.ast.tree.Statement;
import org.hibernate.sql.ast.tree.select.SelectStatement;
import org.hibernate.sql.exec.spi.JdbcOperation;
import org.hibernate.type.BasicType;
import org.hibernate.type.JavaObjectType;
import org.hibernate.type.NullType;
import org.hibernate.type.descriptor.DateTimeUtils;
import org.hibernate.type.descriptor.jdbc.BlobJdbcType;
import org.hibernate.type.descriptor.jdbc.ClobJdbcType;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.ObjectNullAsBinaryTypeJdbcType;
import org.hibernate.type.descriptor.jdbc.TinyIntAsSmallIntJdbcType;
import org.hibernate.type.descriptor.jdbc.spi.JdbcTypeRegistry;

public class SybaseLegacyDialect
extends AbstractTransactSQLDialect {
    private static final int PARAM_LIST_SIZE_LIMIT = 250000;
    private final UniqueDelegate uniqueDelegate = new SkipNullableUniqueDelegate((Dialect)this);
    private final SybaseDriverKind driverKind;
    @Deprecated(forRemoval=true)
    protected final boolean jtdsDriver;

    public SybaseLegacyDialect() {
        this(DatabaseVersion.make((Integer)11, (Integer)0));
    }

    public SybaseLegacyDialect(DatabaseVersion version) {
        super(version);
        this.driverKind = SybaseDriverKind.OTHER;
        this.jtdsDriver = true;
    }

    public SybaseLegacyDialect(DialectResolutionInfo info) {
        super(info);
        this.driverKind = SybaseDriverKind.determineKind((DialectResolutionInfo)info);
        this.jtdsDriver = this.driverKind == SybaseDriverKind.JTDS;
    }

    public SybaseDriverKind getDriverKind() {
        return this.driverKind;
    }

    public JdbcType resolveSqlTypeDescriptor(String columnTypeName, int jdbcTypeCode, int precision, int scale, JdbcTypeRegistry jdbcTypeRegistry) {
        switch (jdbcTypeCode) {
            case 2: 
            case 3: {
                if (precision != 19 || scale != 0) break;
                return jdbcTypeRegistry.getDescriptor(-5);
            }
        }
        return super.resolveSqlTypeDescriptor(columnTypeName, jdbcTypeCode, precision, scale, jdbcTypeRegistry);
    }

    public SqmTranslatorFactory getSqmTranslatorFactory() {
        return new StandardSqmTranslatorFactory(){

            public SqmTranslator<SelectStatement> createSelectTranslator(SqmSelectStatement<?> sqmSelectStatement, QueryOptions queryOptions, DomainParameterXref domainParameterXref, QueryParameterBindings domainParameterBindings, LoadQueryInfluencers loadQueryInfluencers, SqlAstCreationContext creationContext, boolean deduplicateSelectionItems) {
                return new SybaseLegacySqmToSqlAstConverter((SqmStatement<?>)sqmSelectStatement, queryOptions, domainParameterXref, domainParameterBindings, loadQueryInfluencers, creationContext, deduplicateSelectionItems);
            }
        };
    }

    public SqlAstTranslatorFactory getSqlAstTranslatorFactory() {
        return new StandardSqlAstTranslatorFactory(){

            protected <T extends JdbcOperation> SqlAstTranslator<T> buildTranslator(SessionFactoryImplementor sessionFactory, Statement statement) {
                return new SybaseLegacySqlAstTranslator(sessionFactory, statement);
            }
        };
    }

    public boolean supportsNullPrecedence() {
        return false;
    }

    public int getInExpressionCountLimit() {
        return 250000;
    }

    public void contributeTypes(TypeContributions typeContributions, ServiceRegistry serviceRegistry) {
        super.contributeTypes(typeContributions, serviceRegistry);
        JdbcTypeRegistry jdbcTypeRegistry = typeContributions.getTypeConfiguration().getJdbcTypeRegistry();
        if (this.driverKind == SybaseDriverKind.JTDS) {
            jdbcTypeRegistry.addDescriptor(-6, (JdbcType)TinyIntAsSmallIntJdbcType.INSTANCE);
            jdbcTypeRegistry.addDescriptor(2005, (JdbcType)ClobJdbcType.CLOB_BINDING);
            jdbcTypeRegistry.addDescriptor(2011, (JdbcType)ClobJdbcType.CLOB_BINDING);
            jdbcTypeRegistry.addDescriptor(-9, (JdbcType)ClobJdbcType.CLOB_BINDING);
        } else {
            jdbcTypeRegistry.addDescriptor(2005, (JdbcType)ClobJdbcType.STREAM_BINDING_EXTRACTING);
        }
        jdbcTypeRegistry.addDescriptor(2004, (JdbcType)BlobJdbcType.PRIMITIVE_ARRAY_BINDING);
        typeContributions.contributeJdbcType((JdbcType)ObjectNullAsBinaryTypeJdbcType.INSTANCE);
        typeContributions.contributeType((BasicType)new JavaObjectType((JdbcType)ObjectNullAsBinaryTypeJdbcType.INSTANCE, typeContributions.getTypeConfiguration().getJavaTypeRegistry().getDescriptor(Object.class)));
        typeContributions.contributeType((BasicType)new NullType((JdbcType)ObjectNullAsBinaryTypeJdbcType.INSTANCE, typeContributions.getTypeConfiguration().getJavaTypeRegistry().getDescriptor(Object.class)));
    }

    public NationalizationSupport getNationalizationSupport() {
        return this.driverKind == SybaseDriverKind.JTDS ? NationalizationSupport.IMPLICIT : super.getNationalizationSupport();
    }

    public void initializeFunctionRegistry(FunctionContributions functionContributions) {
        super.initializeFunctionRegistry(functionContributions);
        CommonFunctionFactory functionFactory = new CommonFunctionFactory(functionContributions);
        functionFactory.stddev();
        functionFactory.variance();
        functionFactory.stddevPopSamp_stdevp();
        functionFactory.varPopSamp_varp();
        functionFactory.stddevPopSamp();
        functionFactory.varPopSamp();
        functionFactory.round_round();
        functionContributions.getFunctionRegistry().register("count", (SqmFunctionDescriptor)new CountFunction((Dialect)this, functionContributions.getTypeConfiguration(), SqlAstNodeRenderingMode.DEFAULT, "count_big", "+", "varchar(16384)", false));
        functionFactory.avg_castingNonDoubleArguments((Dialect)this, SqlAstNodeRenderingMode.DEFAULT);
        functionFactory.locate_charindex();
        functionFactory.replace_strReplace();
        functionFactory.everyAny_minMaxCase();
        functionFactory.octetLength_pattern("datalength(?1)");
        functionFactory.bitLength_pattern("datalength(?1)*8");
        functionContributions.getFunctionRegistry().register("timestampadd", (SqmFunctionDescriptor)new IntegralTimestampaddFunction((Dialect)this, functionContributions.getTypeConfiguration()));
        functionContributions.getFunctionRegistry().register("trunc", (SqmFunctionDescriptor)new SybaseTruncFunction(functionContributions.getTypeConfiguration()));
        functionContributions.getFunctionRegistry().registerAlternateKey("truncate", "trunc");
    }

    public String getNullColumnString() {
        return " null";
    }

    public boolean canCreateSchema() {
        return false;
    }

    public String getCurrentSchemaCommand() {
        return "select db_name()";
    }

    public int getMaxIdentifierLength() {
        return 128;
    }

    public String castPattern(CastType from, CastType to) {
        if (to == CastType.STRING) {
            switch (from) {
                case DATE: {
                    return "substring(convert(varchar,?1,23),1,10)";
                }
                case TIME: {
                    return "convert(varchar,?1,8)";
                }
                case TIMESTAMP: {
                    return "convert(varchar,?1,140)";
                }
            }
        }
        return super.castPattern(from, to);
    }

    public void appendDateTimeLiteral(SqlAppender appender, TemporalAccessor temporalAccessor, TemporalType precision, TimeZone jdbcTimeZone) {
        switch (precision) {
            case DATE: {
                appender.appendSql("convert(date,'");
                DateTimeUtils.appendAsDate((SqlAppender)appender, (TemporalAccessor)temporalAccessor);
                appender.appendSql("',140)");
                break;
            }
            case TIME: {
                appender.appendSql("convert(time,'");
                DateTimeUtils.appendAsTime((SqlAppender)appender, (TemporalAccessor)temporalAccessor, (boolean)this.supportsTemporalLiteralOffset(), (TimeZone)jdbcTimeZone);
                appender.appendSql("',8)");
                break;
            }
            case TIMESTAMP: {
                appender.appendSql("convert(datetime,'");
                DateTimeUtils.appendAsTimestampWithMillis((SqlAppender)appender, (TemporalAccessor)temporalAccessor, (boolean)this.supportsTemporalLiteralOffset(), (TimeZone)jdbcTimeZone);
                appender.appendSql("',140)");
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    public void appendDateTimeLiteral(SqlAppender appender, Date date, TemporalType precision, TimeZone jdbcTimeZone) {
        switch (precision) {
            case DATE: {
                appender.appendSql("convert(date,'");
                DateTimeUtils.appendAsDate((SqlAppender)appender, (Date)date);
                appender.appendSql("',140)");
                break;
            }
            case TIME: {
                appender.appendSql("convert(time,'");
                DateTimeUtils.appendAsLocalTime((SqlAppender)appender, (Date)date);
                appender.appendSql("',8)");
                break;
            }
            case TIMESTAMP: {
                appender.appendSql("convert(datetime,'");
                DateTimeUtils.appendAsTimestampWithMillis((SqlAppender)appender, (Date)date, (TimeZone)jdbcTimeZone);
                appender.appendSql("',140)");
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    public void appendDateTimeLiteral(SqlAppender appender, Calendar calendar, TemporalType precision, TimeZone jdbcTimeZone) {
        switch (precision) {
            case DATE: {
                appender.appendSql("convert(date,'");
                DateTimeUtils.appendAsDate((SqlAppender)appender, (Calendar)calendar);
                appender.appendSql("',140)");
                break;
            }
            case TIME: {
                appender.appendSql("convert(time,'");
                DateTimeUtils.appendAsLocalTime((SqlAppender)appender, (Calendar)calendar);
                appender.appendSql("',8)");
                break;
            }
            case TIMESTAMP: {
                appender.appendSql("convert(datetime,'");
                DateTimeUtils.appendAsTimestampWithMillis((SqlAppender)appender, (Calendar)calendar, (TimeZone)jdbcTimeZone);
                appender.appendSql("',140)");
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    public String translateExtractField(TemporalUnit unit) {
        switch (unit) {
            case WEEK: {
                return "calweekofyear";
            }
        }
        return super.translateExtractField(unit);
    }

    public String extractPattern(TemporalUnit unit) {
        return "datepart(?1,?2)";
    }

    public boolean supportsFractionalTimestampArithmetic() {
        return false;
    }

    public String timestampaddPattern(TemporalUnit unit, TemporalType temporalType, IntervalType intervalType) {
        return "dateadd(?1,?2,?3)";
    }

    public String timestampdiffPattern(TemporalUnit unit, TemporalType fromTemporalType, TemporalType toTemporalType) {
        return "datediff(?1,?2,?3)";
    }

    public void appendDatetimeFormat(SqlAppender appender, String format) {
        throw new UnsupportedOperationException("format() function not supported on Sybase");
    }

    public boolean supportsStandardCurrentTimestampFunction() {
        return false;
    }

    public IdentifierHelper buildIdentifierHelper(IdentifierHelperBuilder builder, DatabaseMetaData dbMetaData) throws SQLException {
        if (dbMetaData == null) {
            builder.setUnquotedCaseStrategy(IdentifierCaseStrategy.MIXED);
            builder.setQuotedCaseStrategy(IdentifierCaseStrategy.MIXED);
        }
        return super.buildIdentifierHelper(builder, dbMetaData);
    }

    public NameQualifierSupport getNameQualifierSupport() {
        return NameQualifierSupport.CATALOG;
    }

    public UniqueDelegate getUniqueDelegate() {
        return this.uniqueDelegate;
    }

    public CallableStatementSupport getCallableStatementSupport() {
        return this.driverKind == SybaseDriverKind.JTDS ? JTDSCallableStatementSupport.INSTANCE : SybaseCallableStatementSupport.INSTANCE;
    }

    public boolean supportsNamedParameters(DatabaseMetaData databaseMetaData) throws SQLException {
        return this.driverKind == SybaseDriverKind.JTDS && super.supportsNamedParameters(databaseMetaData);
    }

    public DmlTargetColumnQualifierSupport getDmlTargetColumnQualifierSupport() {
        return DmlTargetColumnQualifierSupport.TABLE_ALIAS;
    }

    public boolean supportsFromClauseInUpdate() {
        return true;
    }
}

