/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.community.dialect;

import jakarta.persistence.TemporalType;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.PessimisticLockException;
import org.hibernate.QueryTimeoutException;
import org.hibernate.boot.model.FunctionContributions;
import org.hibernate.boot.model.TypeContributions;
import org.hibernate.community.dialect.CockroachLegacySqlAstTranslator;
import org.hibernate.dialect.DatabaseVersion;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.FunctionalDependencyAnalysisSupport;
import org.hibernate.dialect.FunctionalDependencyAnalysisSupportImpl;
import org.hibernate.dialect.NationalizationSupport;
import org.hibernate.dialect.NullOrdering;
import org.hibernate.dialect.PgJdbcHelper;
import org.hibernate.dialect.PostgreSQLCastingInetJdbcType;
import org.hibernate.dialect.PostgreSQLCastingIntervalSecondJdbcType;
import org.hibernate.dialect.PostgreSQLCastingJsonJdbcType;
import org.hibernate.dialect.PostgreSQLDriverKind;
import org.hibernate.dialect.PostgreSQLUUIDJdbcType;
import org.hibernate.dialect.RowLockStrategy;
import org.hibernate.dialect.SimpleDatabaseVersion;
import org.hibernate.dialect.SpannerDialect;
import org.hibernate.dialect.TimeZoneSupport;
import org.hibernate.dialect.function.CommonFunctionFactory;
import org.hibernate.dialect.function.FormatFunction;
import org.hibernate.dialect.function.PostgreSQLTruncFunction;
import org.hibernate.dialect.identity.CockroachDBIdentityColumnSupport;
import org.hibernate.dialect.identity.IdentityColumnSupport;
import org.hibernate.dialect.pagination.LimitHandler;
import org.hibernate.dialect.pagination.OffsetFetchLimitHandler;
import org.hibernate.dialect.sequence.PostgreSQLSequenceSupport;
import org.hibernate.dialect.sequence.SequenceSupport;
import org.hibernate.engine.jdbc.dialect.spi.DialectResolutionInfo;
import org.hibernate.engine.jdbc.env.spi.IdentifierCaseStrategy;
import org.hibernate.engine.jdbc.env.spi.IdentifierHelper;
import org.hibernate.engine.jdbc.env.spi.IdentifierHelperBuilder;
import org.hibernate.engine.jdbc.env.spi.NameQualifierSupport;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.exception.LockAcquisitionException;
import org.hibernate.exception.spi.SQLExceptionConversionDelegate;
import org.hibernate.exception.spi.TemplatedViolatedConstraintNameExtractor;
import org.hibernate.exception.spi.ViolatedConstraintNameExtractor;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.JdbcExceptionHelper;
import org.hibernate.query.SemanticException;
import org.hibernate.query.sqm.IntervalType;
import org.hibernate.query.sqm.TemporalUnit;
import org.hibernate.query.sqm.function.SqmFunctionDescriptor;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.SqlAstTranslatorFactory;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.spi.StandardSqlAstTranslatorFactory;
import org.hibernate.sql.exec.spi.JdbcOperation;
import org.hibernate.tool.schema.extract.spi.ColumnTypeInformation;
import org.hibernate.type.BasicType;
import org.hibernate.type.JavaObjectType;
import org.hibernate.type.descriptor.DateTimeUtils;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.ObjectNullAsBinaryTypeJdbcType;
import org.hibernate.type.descriptor.jdbc.VarbinaryJdbcType;
import org.hibernate.type.descriptor.jdbc.VarcharJdbcType;
import org.hibernate.type.descriptor.jdbc.spi.JdbcTypeRegistry;
import org.hibernate.type.descriptor.sql.DdlType;
import org.hibernate.type.descriptor.sql.internal.DdlTypeImpl;
import org.hibernate.type.descriptor.sql.internal.Scale6IntervalSecondDdlType;
import org.hibernate.type.descriptor.sql.spi.DdlTypeRegistry;
import org.hibernate.type.spi.TypeConfiguration;
import org.jboss.logging.Logger;

public class CockroachLegacyDialect
extends Dialect {
    private static final CoreMessageLogger LOG = (CoreMessageLogger)Logger.getMessageLogger(CoreMessageLogger.class, (String)CockroachLegacyDialect.class.getName());
    private static final Pattern CRDB_VERSION_PATTERN = Pattern.compile("v[\\d]+(\\.[\\d]+)?(\\.[\\d]+)?");
    protected static final DatabaseVersion DEFAULT_VERSION = DatabaseVersion.make((Integer)19, (Integer)2);
    protected final PostgreSQLDriverKind driverKind;
    private static final ViolatedConstraintNameExtractor EXTRACTOR = new TemplatedViolatedConstraintNameExtractor(sqle -> {
        String sqlState = JdbcExceptionHelper.extractSqlState((SQLException)sqle);
        if (sqlState == null) {
            return null;
        }
        switch (Integer.parseInt(sqlState)) {
            case 23514: {
                return TemplatedViolatedConstraintNameExtractor.extractUsingTemplate((String)"violates check constraint \"", (String)"\"", (String)sqle.getMessage());
            }
            case 23505: {
                return TemplatedViolatedConstraintNameExtractor.extractUsingTemplate((String)"violates unique constraint \"", (String)"\"", (String)sqle.getMessage());
            }
            case 23503: {
                return TemplatedViolatedConstraintNameExtractor.extractUsingTemplate((String)"violates foreign key constraint \"", (String)"\"", (String)sqle.getMessage());
            }
            case 23502: {
                return TemplatedViolatedConstraintNameExtractor.extractUsingTemplate((String)"null value in column \"", (String)"\" violates not-null constraint", (String)sqle.getMessage());
            }
            case 23001: {
                return null;
            }
        }
        return null;
    });

    public CockroachLegacyDialect() {
        this(DEFAULT_VERSION);
    }

    public CockroachLegacyDialect(DialectResolutionInfo info) {
        this(CockroachLegacyDialect.fetchDataBaseVersion(info), PostgreSQLDriverKind.determineKind((DialectResolutionInfo)info));
        this.registerKeywords(info);
    }

    public CockroachLegacyDialect(DatabaseVersion version) {
        super(version);
        this.driverKind = PostgreSQLDriverKind.PG_JDBC;
    }

    public CockroachLegacyDialect(DatabaseVersion version, PostgreSQLDriverKind driverKind) {
        super(version);
        this.driverKind = driverKind;
    }

    protected static DatabaseVersion fetchDataBaseVersion(DialectResolutionInfo info) {
        String versionString = null;
        if (info.getDatabaseMetadata() != null) {
            try (Statement s = info.getDatabaseMetadata().getConnection().createStatement();){
                ResultSet rs = s.executeQuery("SELECT version()");
                if (rs.next()) {
                    versionString = rs.getString(1);
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        return CockroachLegacyDialect.parseVersion(versionString);
    }

    protected static DatabaseVersion parseVersion(String versionString) {
        DatabaseVersion databaseVersion = null;
        Matcher m = CRDB_VERSION_PATTERN.matcher(versionString == null ? "" : versionString);
        if (m.find()) {
            String[] versionParts = m.group().substring(1).split("\\.");
            int majorVersion = Integer.parseInt(versionParts[0]);
            int minorVersion = versionParts.length > 1 ? Integer.parseInt(versionParts[1]) : 0;
            int microVersion = versionParts.length > 2 ? Integer.parseInt(versionParts[2]) : 0;
            databaseVersion = new SimpleDatabaseVersion(majorVersion, minorVersion, microVersion);
        }
        if (databaseVersion == null) {
            LOG.unableToDetermineCockroachDatabaseVersion(DEFAULT_VERSION.getDatabaseMajorVersion() + "." + DEFAULT_VERSION.getDatabaseMinorVersion() + "." + DEFAULT_VERSION.getDatabaseMicroVersion());
            databaseVersion = DEFAULT_VERSION;
        }
        return databaseVersion;
    }

    protected String columnType(int sqlTypeCode) {
        switch (sqlTypeCode) {
            case -6: {
                return "smallint";
            }
            case 4: {
                return "int4";
            }
            case -15: {
                return this.columnType(1);
            }
            case -9: {
                return this.columnType(12);
            }
            case 2005: 
            case 2011: {
                return "string";
            }
            case -3: 
            case -2: 
            case 2004: {
                return "bytes";
            }
            case 3003: {
                return this.columnType(2014);
            }
        }
        return super.columnType(sqlTypeCode);
    }

    protected String castType(int sqlTypeCode) {
        switch (sqlTypeCode) {
            case -15: 
            case -9: 
            case 1: 
            case 12: 
            case 4001: 
            case 4002: {
                return "string";
            }
            case -3: 
            case -2: 
            case 4003: {
                return "bytes";
            }
        }
        return super.castType(sqlTypeCode);
    }

    protected void registerColumnTypes(TypeContributions typeContributions, ServiceRegistry serviceRegistry) {
        super.registerColumnTypes(typeContributions, serviceRegistry);
        DdlTypeRegistry ddlTypeRegistry = typeContributions.getTypeConfiguration().getDdlTypeRegistry();
        ddlTypeRegistry.addDescriptor((DdlType)new DdlTypeImpl(3000, "uuid", (Dialect)this));
        ddlTypeRegistry.addDescriptor((DdlType)new DdlTypeImpl(3200, "geometry", (Dialect)this));
        ddlTypeRegistry.addDescriptor((DdlType)new DdlTypeImpl(3250, "geography", (Dialect)this));
        ddlTypeRegistry.addDescriptor((DdlType)new Scale6IntervalSecondDdlType((Dialect)this));
        if (this.getVersion().isSameOrAfter(20)) {
            ddlTypeRegistry.addDescriptor((DdlType)new DdlTypeImpl(3002, "inet", (Dialect)this));
            ddlTypeRegistry.addDescriptor((DdlType)new DdlTypeImpl(3001, "jsonb", (Dialect)this));
        } else {
            ddlTypeRegistry.addDescriptor((DdlType)new DdlTypeImpl(3001, "json", (Dialect)this));
        }
    }

    public JdbcType resolveSqlTypeDescriptor(String columnTypeName, int jdbcTypeCode, int precision, int scale, JdbcTypeRegistry jdbcTypeRegistry) {
        switch (jdbcTypeCode) {
            case 1111: {
                switch (columnTypeName) {
                    case "uuid": {
                        jdbcTypeCode = 3000;
                        break;
                    }
                    case "json": 
                    case "jsonb": {
                        jdbcTypeCode = 3001;
                        break;
                    }
                    case "inet": {
                        jdbcTypeCode = 3002;
                        break;
                    }
                    case "geometry": {
                        jdbcTypeCode = 3200;
                        break;
                    }
                    case "geography": {
                        jdbcTypeCode = 3250;
                    }
                }
                break;
            }
            case 92: {
                if (!"timetz".equals(columnTypeName)) break;
                jdbcTypeCode = 3007;
                break;
            }
            case 93: {
                if (!"timestamptz".equals(columnTypeName)) break;
                jdbcTypeCode = 3003;
                break;
            }
            case 2003: {
                String componentTypeName;
                Integer sqlTypeCode;
                if (columnTypeName.charAt(0) != '_' || (sqlTypeCode = this.resolveSqlTypeCode(componentTypeName = columnTypeName.substring(1), jdbcTypeRegistry.getTypeConfiguration())) == null) break;
                return jdbcTypeRegistry.resolveTypeConstructorDescriptor(jdbcTypeCode, jdbcTypeRegistry.getDescriptor(sqlTypeCode.intValue()), ColumnTypeInformation.EMPTY);
            }
        }
        return jdbcTypeRegistry.getDescriptor(jdbcTypeCode);
    }

    protected Integer resolveSqlTypeCode(String columnTypeName, TypeConfiguration typeConfiguration) {
        switch (columnTypeName) {
            case "bool": {
                return 16;
            }
            case "float4": {
                return 7;
            }
            case "float8": {
                return 8;
            }
            case "int2": {
                return 5;
            }
            case "int4": {
                return 4;
            }
            case "int8": {
                return -5;
            }
        }
        return super.resolveSqlTypeCode(columnTypeName, typeConfiguration);
    }

    public void contributeTypes(TypeContributions typeContributions, ServiceRegistry serviceRegistry) {
        super.contributeTypes(typeContributions, serviceRegistry);
        this.contributeCockroachTypes(typeContributions, serviceRegistry);
    }

    protected void contributeCockroachTypes(TypeContributions typeContributions, ServiceRegistry serviceRegistry) {
        JdbcTypeRegistry jdbcTypeRegistry = typeContributions.getTypeConfiguration().getJdbcTypeRegistry();
        if (this.driverKind == PostgreSQLDriverKind.PG_JDBC) {
            jdbcTypeRegistry.addDescriptorIfAbsent((JdbcType)PostgreSQLUUIDJdbcType.INSTANCE);
            if (PgJdbcHelper.isUsable((ServiceRegistry)serviceRegistry)) {
                jdbcTypeRegistry.addDescriptorIfAbsent(PgJdbcHelper.getIntervalJdbcType((ServiceRegistry)serviceRegistry));
                if (this.getVersion().isSameOrAfter(20, 0)) {
                    jdbcTypeRegistry.addDescriptorIfAbsent(PgJdbcHelper.getInetJdbcType((ServiceRegistry)serviceRegistry));
                    jdbcTypeRegistry.addDescriptorIfAbsent(PgJdbcHelper.getJsonbJdbcType((ServiceRegistry)serviceRegistry));
                } else {
                    jdbcTypeRegistry.addDescriptorIfAbsent(PgJdbcHelper.getJsonJdbcType((ServiceRegistry)serviceRegistry));
                }
            } else {
                jdbcTypeRegistry.addDescriptorIfAbsent((JdbcType)PostgreSQLCastingIntervalSecondJdbcType.INSTANCE);
                if (this.getVersion().isSameOrAfter(20, 0)) {
                    jdbcTypeRegistry.addDescriptorIfAbsent((JdbcType)PostgreSQLCastingInetJdbcType.INSTANCE);
                    jdbcTypeRegistry.addDescriptorIfAbsent((JdbcType)PostgreSQLCastingJsonJdbcType.JSONB_INSTANCE);
                } else {
                    jdbcTypeRegistry.addDescriptorIfAbsent((JdbcType)PostgreSQLCastingJsonJdbcType.JSON_INSTANCE);
                }
            }
        } else {
            jdbcTypeRegistry.addDescriptorIfAbsent((JdbcType)PostgreSQLUUIDJdbcType.INSTANCE);
            jdbcTypeRegistry.addDescriptorIfAbsent((JdbcType)PostgreSQLCastingIntervalSecondJdbcType.INSTANCE);
            if (this.getVersion().isSameOrAfter(20, 0)) {
                jdbcTypeRegistry.addDescriptorIfAbsent((JdbcType)PostgreSQLCastingInetJdbcType.INSTANCE);
                jdbcTypeRegistry.addDescriptorIfAbsent((JdbcType)PostgreSQLCastingJsonJdbcType.JSONB_INSTANCE);
            } else {
                jdbcTypeRegistry.addDescriptorIfAbsent((JdbcType)PostgreSQLCastingJsonJdbcType.JSON_INSTANCE);
            }
        }
        jdbcTypeRegistry.addDescriptor(2004, (JdbcType)VarbinaryJdbcType.INSTANCE);
        jdbcTypeRegistry.addDescriptor(2005, (JdbcType)VarcharJdbcType.INSTANCE);
        jdbcTypeRegistry.addDescriptor(2011, (JdbcType)VarcharJdbcType.INSTANCE);
        typeContributions.contributeJdbcType((JdbcType)ObjectNullAsBinaryTypeJdbcType.INSTANCE);
        typeContributions.contributeType((BasicType)new JavaObjectType((JdbcType)ObjectNullAsBinaryTypeJdbcType.INSTANCE, typeContributions.getTypeConfiguration().getJavaTypeRegistry().getDescriptor(Object.class)));
    }

    public void initializeFunctionRegistry(FunctionContributions functionContributions) {
        super.initializeFunctionRegistry(functionContributions);
        CommonFunctionFactory functionFactory = new CommonFunctionFactory(functionContributions);
        functionFactory.ascii();
        functionFactory.char_chr();
        functionFactory.overlay();
        functionFactory.position();
        functionFactory.substringFromFor();
        functionFactory.locate_positionSubstring();
        functionFactory.concat_pipeOperator();
        functionFactory.trim2();
        functionFactory.substr();
        functionFactory.reverse();
        functionFactory.repeat();
        functionFactory.md5();
        functionFactory.sha1();
        functionFactory.octetLength();
        functionFactory.bitLength();
        functionFactory.cbrt();
        functionFactory.cot();
        functionFactory.degrees();
        functionFactory.radians();
        functionFactory.pi();
        functionFactory.log();
        functionFactory.log10_log();
        functionFactory.round();
        functionFactory.bitandorxornot_operator();
        functionFactory.bitAndOr();
        functionFactory.everyAny_boolAndOr();
        functionFactory.median_percentileCont_castDouble();
        functionFactory.stddev();
        functionFactory.stddevPopSamp();
        functionFactory.variance();
        functionFactory.varPopSamp();
        functionFactory.covarPopSamp();
        functionFactory.corr();
        functionFactory.regrLinearRegressionAggregates();
        functionContributions.getFunctionRegistry().register("format", (SqmFunctionDescriptor)new FormatFunction("experimental_strftime", false, true, false, functionContributions.getTypeConfiguration()));
        functionFactory.windowFunctions();
        functionFactory.listagg_stringAgg("string");
        functionFactory.inverseDistributionOrderedSetAggregates();
        functionFactory.hypotheticalOrderedSetAggregates_windowEmulation();
        functionFactory.array_postgresql();
        functionFactory.arrayAggregate();
        functionFactory.arrayPosition_postgresql();
        functionFactory.arrayPositions_postgresql();
        functionFactory.arrayLength_cardinality();
        functionFactory.arrayConcat_postgresql();
        functionFactory.arrayPrepend_postgresql();
        functionFactory.arrayAppend_postgresql();
        functionFactory.arrayContains_postgresql();
        functionFactory.arrayOverlaps_postgresql();
        functionFactory.arrayGet_bracket();
        functionFactory.arraySet_unnest();
        functionFactory.arrayRemove();
        functionFactory.arrayRemoveIndex_unnest(true);
        functionFactory.arraySlice_operator();
        functionFactory.arrayReplace();
        functionFactory.arrayTrim_unnest();
        functionFactory.arrayFill_cockroachdb();
        functionFactory.arrayToString_postgresql();
        functionContributions.getFunctionRegistry().register("trunc", (SqmFunctionDescriptor)new PostgreSQLTruncFunction(this.getVersion().isSameOrAfter(22, 2), functionContributions.getTypeConfiguration()));
        functionContributions.getFunctionRegistry().registerAlternateKey("truncate", "trunc");
    }

    public TimeZoneSupport getTimeZoneSupport() {
        return TimeZoneSupport.NORMALIZE;
    }

    public void appendBooleanValueString(SqlAppender appender, boolean bool) {
        appender.appendSql(bool);
    }

    public String getCascadeConstraintsString() {
        return " cascade";
    }

    public boolean supportsCurrentTimestampSelection() {
        return true;
    }

    public boolean isCurrentTimestampSelectStringCallable() {
        return false;
    }

    public String getCurrentTimestampSelectString() {
        return "select now()";
    }

    public boolean supportsDistinctFromPredicate() {
        return true;
    }

    public boolean supportsIfExistsBeforeTableName() {
        return true;
    }

    public boolean supportsIfExistsBeforeConstraintName() {
        return true;
    }

    public boolean supportsIfExistsAfterAlterTable() {
        return true;
    }

    public boolean qualifyIndexName() {
        return false;
    }

    public IdentityColumnSupport getIdentityColumnSupport() {
        return CockroachDBIdentityColumnSupport.INSTANCE;
    }

    public boolean supportsValuesList() {
        return true;
    }

    public boolean supportsPartitionBy() {
        return true;
    }

    public boolean supportsNonQueryWithCTE() {
        return true;
    }

    public boolean supportsRecursiveCTE() {
        return this.getVersion().isSameOrAfter(20, 1);
    }

    public String getNoColumnsInsertString() {
        return "default values";
    }

    public String getCaseInsensitiveLike() {
        return "ilike";
    }

    public boolean supportsCaseInsensitiveLike() {
        return true;
    }

    public boolean supportsNullPrecedence() {
        return false;
    }

    public NullOrdering getNullOrdering() {
        return NullOrdering.SMALLEST;
    }

    public boolean supportsTupleCounts() {
        return true;
    }

    public boolean requiresParensForTupleDistinctCounts() {
        return true;
    }

    public String getNativeIdentifierGeneratorStrategy() {
        return "sequence";
    }

    public SequenceSupport getSequenceSupport() {
        return PostgreSQLSequenceSupport.INSTANCE;
    }

    public String getQuerySequencesString() {
        return "select sequence_name,sequence_schema,sequence_catalog,start_value,minimum_value,maximum_value,increment from information_schema.sequences";
    }

    public boolean supportsLobValueChangePropagation() {
        return false;
    }

    public SqlAstTranslatorFactory getSqlAstTranslatorFactory() {
        return new StandardSqlAstTranslatorFactory(){

            protected <T extends JdbcOperation> SqlAstTranslator<T> buildTranslator(SessionFactoryImplementor sessionFactory, org.hibernate.sql.ast.tree.Statement statement) {
                return new CockroachLegacySqlAstTranslator(sessionFactory, statement);
            }
        };
    }

    public NationalizationSupport getNationalizationSupport() {
        return NationalizationSupport.IMPLICIT;
    }

    public int getMaxIdentifierLength() {
        return 63;
    }

    public boolean supportsStandardArrays() {
        return true;
    }

    public boolean supportsTemporalLiteralOffset() {
        return true;
    }

    public void appendDateTimeLiteral(SqlAppender appender, TemporalAccessor temporalAccessor, TemporalType precision, TimeZone jdbcTimeZone) {
        switch (precision) {
            case DATE: {
                appender.appendSql("date '");
                DateTimeUtils.appendAsDate((SqlAppender)appender, (TemporalAccessor)temporalAccessor);
                appender.appendSql('\'');
                break;
            }
            case TIME: {
                if (this.supportsTemporalLiteralOffset() && temporalAccessor.isSupported(ChronoField.OFFSET_SECONDS)) {
                    appender.appendSql("time with time zone '");
                    DateTimeUtils.appendAsTime((SqlAppender)appender, (TemporalAccessor)temporalAccessor, (boolean)true, (TimeZone)jdbcTimeZone);
                } else {
                    appender.appendSql("time '");
                    DateTimeUtils.appendAsLocalTime((SqlAppender)appender, (TemporalAccessor)temporalAccessor);
                }
                appender.appendSql('\'');
                break;
            }
            case TIMESTAMP: {
                if (this.supportsTemporalLiteralOffset() && temporalAccessor.isSupported(ChronoField.OFFSET_SECONDS)) {
                    appender.appendSql("timestamp with time zone '");
                    DateTimeUtils.appendAsTimestampWithMicros((SqlAppender)appender, (TemporalAccessor)temporalAccessor, (boolean)true, (TimeZone)jdbcTimeZone);
                    appender.appendSql('\'');
                    break;
                }
                appender.appendSql("timestamp '");
                DateTimeUtils.appendAsTimestampWithMicros((SqlAppender)appender, (TemporalAccessor)temporalAccessor, (boolean)false, (TimeZone)jdbcTimeZone);
                appender.appendSql('\'');
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    public void appendDateTimeLiteral(SqlAppender appender, Date date, TemporalType precision, TimeZone jdbcTimeZone) {
        switch (precision) {
            case DATE: {
                appender.appendSql("date '");
                DateTimeUtils.appendAsDate((SqlAppender)appender, (Date)date);
                appender.appendSql('\'');
                break;
            }
            case TIME: {
                appender.appendSql("time with time zone '");
                DateTimeUtils.appendAsTime((SqlAppender)appender, (Date)date, (TimeZone)jdbcTimeZone);
                appender.appendSql('\'');
                break;
            }
            case TIMESTAMP: {
                appender.appendSql("timestamp with time zone '");
                DateTimeUtils.appendAsTimestampWithMicros((SqlAppender)appender, (Date)date, (TimeZone)jdbcTimeZone);
                appender.appendSql('\'');
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    public void appendDateTimeLiteral(SqlAppender appender, Calendar calendar, TemporalType precision, TimeZone jdbcTimeZone) {
        switch (precision) {
            case DATE: {
                appender.appendSql("date '");
                DateTimeUtils.appendAsDate((SqlAppender)appender, (Calendar)calendar);
                appender.appendSql('\'');
                break;
            }
            case TIME: {
                appender.appendSql("time with time zone '");
                DateTimeUtils.appendAsTime((SqlAppender)appender, (Calendar)calendar, (TimeZone)jdbcTimeZone);
                appender.appendSql('\'');
                break;
            }
            case TIMESTAMP: {
                appender.appendSql("timestamp with time zone '");
                DateTimeUtils.appendAsTimestampWithMillis((SqlAppender)appender, (Calendar)calendar, (TimeZone)jdbcTimeZone);
                appender.appendSql('\'');
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    public String extractPattern(TemporalUnit unit) {
        switch (unit) {
            case DAY_OF_WEEK: {
                return "(" + super.extractPattern(unit) + "+1)";
            }
        }
        return super.extractPattern(unit);
    }

    public String translateExtractField(TemporalUnit unit) {
        switch (unit) {
            case DAY_OF_MONTH: {
                return "day";
            }
            case DAY_OF_YEAR: {
                return "dayofyear";
            }
            case DAY_OF_WEEK: {
                return "dayofweek";
            }
        }
        return super.translateExtractField(unit);
    }

    public long getFractionalSecondPrecisionInNanos() {
        return 1000L;
    }

    public String timestampaddPattern(TemporalUnit unit, TemporalType temporalType, IntervalType intervalType) {
        if (intervalType != null) {
            return "(?2+?3)";
        }
        switch (unit) {
            case NANOSECOND: {
                return "(?3+(?2)/1e3*interval '1 microsecond')";
            }
            case NATIVE: {
                return "(?3+(?2)*interval '1 microsecond')";
            }
            case QUARTER: {
                return "(?3+(?2)*interval '3 month')";
            }
            case WEEK: {
                return "(?3+(?2)*interval '7 day')";
            }
        }
        return "(?3+(?2)*interval '1 ?1')";
    }

    public String timestampdiffPattern(TemporalUnit unit, TemporalType fromTemporalType, TemporalType toTemporalType) {
        if (unit == null) {
            return "(?3-?2)";
        }
        if (toTemporalType == TemporalType.DATE && fromTemporalType == TemporalType.DATE) {
            switch (unit) {
                case QUARTER: 
                case YEAR: 
                case MONTH: {
                    return "extract(" + this.translateDurationField(unit) + " from age(cast(?3 as timestamptz),cast(?2 as timestamptz)))";
                }
            }
            return "(?3-?2)" + TemporalUnit.DAY.conversionFactor(unit, (Dialect)this);
        }
        if (this.getVersion().isSameOrAfter(20, 1)) {
            switch (unit) {
                case YEAR: {
                    return "extract(year from ?3-?2)";
                }
                case QUARTER: {
                    return "(extract(year from ?3-?2)*4+extract(month from ?3-?2)//3)";
                }
                case MONTH: {
                    return "(extract(year from ?3-?2)*12+extract(month from ?3-?2))";
                }
                case WEEK: {
                    return "(extract(day from ?3-?2)/7)";
                }
                case DAY: {
                    return "extract(day from ?3-?2)";
                }
                case NANOSECOND: 
                case NATIVE: 
                case HOUR: 
                case MINUTE: 
                case SECOND: {
                    return "cast(extract(epoch from ?3-?2)" + TemporalUnit.EPOCH.conversionFactor(unit, (Dialect)this) + " as int)";
                }
            }
            throw new SemanticException("unrecognized field: " + unit);
        }
        switch (unit) {
            case YEAR: {
                return "extract(year from ?3-?2)";
            }
            case QUARTER: {
                return "(extract(year from ?3-?2)*4+extract(month from ?3-?2)//3)";
            }
            case MONTH: {
                return "(extract(year from ?3-?2)*12+extract(month from ?3-?2))";
            }
            case WEEK: {
                return "extract_duration(hour from ?3-?2)/168";
            }
            case DAY: {
                return "extract_duration(hour from ?3-?2)/24";
            }
            case NANOSECOND: {
                return "extract_duration(microsecond from ?3-?2)*1e3";
            }
        }
        return "extract_duration(?1 from ?3-?2)";
    }

    public String translateDurationField(TemporalUnit unit) {
        return unit == TemporalUnit.NATIVE ? "microsecond" : super.translateDurationField(unit);
    }

    public void appendDatetimeFormat(SqlAppender appender, String format) {
        appender.appendSql(SpannerDialect.datetimeFormat((String)format).result());
    }

    public LimitHandler getLimitHandler() {
        return OffsetFetchLimitHandler.INSTANCE;
    }

    public String getForUpdateString(String aliases) {
        return this.getForUpdateString() + " of " + aliases;
    }

    public String getForUpdateString(LockOptions lockOptions) {
        if (this.getVersion().isBefore(20, 1)) {
            return "";
        }
        return super.getForUpdateString(lockOptions);
    }

    public String getForUpdateString() {
        return this.getVersion().isBefore(20, 1) ? "" : " for update";
    }

    public String getForUpdateString(String aliases, LockOptions lockOptions) {
        LockMode lockMode;
        if (this.getVersion().isBefore(20, 1)) {
            return "";
        }
        if (aliases.isEmpty()) {
            lockMode = lockOptions.getLockMode();
            for (Map.Entry entry : lockOptions.getAliasSpecificLocks()) {
                if (!((LockMode)entry.getValue()).greaterThan(lockMode)) continue;
                aliases = (String)entry.getKey();
            }
        }
        if ((lockMode = lockOptions.getAliasSpecificLockMode(aliases)) == null) {
            lockMode = lockOptions.getLockMode();
        }
        switch (lockMode) {
            case PESSIMISTIC_READ: {
                return this.getReadLockString(aliases, lockOptions.getTimeOut());
            }
            case PESSIMISTIC_WRITE: {
                return this.getWriteLockString(aliases, lockOptions.getTimeOut());
            }
            case UPGRADE_NOWAIT: 
            case PESSIMISTIC_FORCE_INCREMENT: {
                return this.getForUpdateNowaitString(aliases);
            }
            case UPGRADE_SKIPLOCKED: {
                return this.getForUpdateSkipLockedString(aliases);
            }
        }
        return "";
    }

    private String withTimeout(String lockString, int timeout) {
        switch (timeout) {
            case 0: {
                return this.supportsNoWait() ? lockString + " nowait" : lockString;
            }
            case -2: {
                return this.supportsSkipLocked() ? lockString + " skip locked" : lockString;
            }
        }
        return lockString;
    }

    public String getWriteLockString(int timeout) {
        return this.withTimeout(this.getForUpdateString(), timeout);
    }

    public String getWriteLockString(String aliases, int timeout) {
        return this.withTimeout(this.getForUpdateString(aliases), timeout);
    }

    public String getReadLockString(int timeout) {
        return this.withTimeout(" for share", timeout);
    }

    public String getReadLockString(String aliases, int timeout) {
        return this.withTimeout(" for share of " + aliases, timeout);
    }

    public String getForUpdateNowaitString() {
        return this.supportsNoWait() ? this.getForUpdateString() + " nowait" : this.getForUpdateString();
    }

    public String getForUpdateNowaitString(String aliases) {
        return this.supportsNoWait() ? this.getForUpdateString(aliases) + " nowait" : this.getForUpdateString(aliases);
    }

    public String getForUpdateSkipLockedString() {
        return this.supportsSkipLocked() ? this.getForUpdateString() + " skip locked" : this.getForUpdateString();
    }

    public String getForUpdateSkipLockedString(String aliases) {
        return this.supportsSkipLocked() ? this.getForUpdateString(aliases) + " skip locked" : this.getForUpdateString(aliases);
    }

    public boolean supportsOuterJoinForUpdate() {
        return false;
    }

    public boolean useInputStreamToInsertBlob() {
        return false;
    }

    public boolean supportsOffsetInSubquery() {
        return true;
    }

    public boolean supportsWindowFunctions() {
        return true;
    }

    public boolean supportsLateral() {
        return this.getVersion().isSameOrAfter(20, 1);
    }

    public boolean supportsNoWait() {
        return this.getVersion().isSameOrAfter(20, 1);
    }

    public boolean supportsWait() {
        return false;
    }

    public boolean supportsSkipLocked() {
        return false;
    }

    public FunctionalDependencyAnalysisSupport getFunctionalDependencyAnalysisSupport() {
        return FunctionalDependencyAnalysisSupportImpl.TABLE_REFERENCE;
    }

    public RowLockStrategy getWriteRowLockStrategy() {
        return this.getVersion().isSameOrAfter(20, 1) ? RowLockStrategy.TABLE : RowLockStrategy.NONE;
    }

    public NameQualifierSupport getNameQualifierSupport() {
        return NameQualifierSupport.SCHEMA;
    }

    public IdentifierHelper buildIdentifierHelper(IdentifierHelperBuilder builder, DatabaseMetaData dbMetaData) throws SQLException {
        if (dbMetaData == null) {
            builder.setUnquotedCaseStrategy(IdentifierCaseStrategy.LOWER);
            builder.setQuotedCaseStrategy(IdentifierCaseStrategy.MIXED);
        }
        return super.buildIdentifierHelper(builder, dbMetaData);
    }

    public ViolatedConstraintNameExtractor getViolatedConstraintNameExtractor() {
        return EXTRACTOR;
    }

    public SQLExceptionConversionDelegate buildSQLExceptionConversionDelegate() {
        return (sqlException, message, sql) -> {
            String sqlState = JdbcExceptionHelper.extractSqlState((SQLException)sqlException);
            if (sqlState == null) {
                return null;
            }
            switch (sqlState) {
                case "40P01": {
                    return new LockAcquisitionException(message, sqlException, sql);
                }
                case "55P03": {
                    return new PessimisticLockException(message, sqlException, sql);
                }
                case "57014": {
                    return new QueryTimeoutException(message, sqlException, sql);
                }
            }
            return null;
        };
    }

    public int getDefaultIntervalSecondScale() {
        return 6;
    }
}

