/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.community.dialect;

import org.hibernate.community.dialect.MariaDBLegacyDialect;
import org.hibernate.dialect.MySQLSqlAstTranslator;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.query.sqm.ComparisonOperator;
import org.hibernate.sql.ast.SqlAstWalker;
import org.hibernate.sql.ast.spi.AbstractSqlAstTranslator;
import org.hibernate.sql.ast.tree.Statement;
import org.hibernate.sql.ast.tree.expression.CastTarget;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.Literal;
import org.hibernate.sql.ast.tree.expression.Summarization;
import org.hibernate.sql.ast.tree.from.QueryPartTableReference;
import org.hibernate.sql.ast.tree.predicate.BooleanExpressionPredicate;
import org.hibernate.sql.ast.tree.predicate.LikePredicate;
import org.hibernate.sql.ast.tree.select.QueryGroup;
import org.hibernate.sql.ast.tree.select.QueryPart;
import org.hibernate.sql.ast.tree.select.QuerySpec;
import org.hibernate.sql.exec.spi.JdbcOperation;

public class MariaDBLegacySqlAstTranslator<T extends JdbcOperation>
extends AbstractSqlAstTranslator<T> {
    private MariaDBLegacyDialect dialect = (MariaDBLegacyDialect)super.getDialect();

    public MariaDBLegacySqlAstTranslator(SessionFactoryImplementor sessionFactory, Statement statement) {
        super(sessionFactory, statement);
    }

    protected boolean supportsWithClause() {
        return this.dialect.getVersion().isSameOrAfter(10, 2);
    }

    protected boolean supportsWithClauseInSubquery() {
        return false;
    }

    protected void renderExpressionAsClauseItem(Expression expression) {
        expression.accept((SqlAstWalker)this);
    }

    protected void visitRecursivePath(Expression recursivePath, int sizeEstimate) {
        if (sizeEstimate == -1) {
            super.visitRecursivePath(recursivePath, sizeEstimate);
        } else {
            this.appendSql("cast(");
            recursivePath.accept((SqlAstWalker)this);
            this.appendSql(" as char(");
            this.appendSql(sizeEstimate);
            this.appendSql("))");
        }
    }

    public void visitBooleanExpressionPredicate(BooleanExpressionPredicate booleanExpressionPredicate) {
        boolean isNegated = booleanExpressionPredicate.isNegated();
        if (isNegated) {
            this.appendSql("not(");
        }
        booleanExpressionPredicate.getExpression().accept((SqlAstWalker)this);
        if (isNegated) {
            this.appendSql(')');
        }
    }

    protected String getForShare(int timeoutMillis) {
        return " lock in share mode";
    }

    protected boolean shouldEmulateFetchClause(QueryPart queryPart) {
        return this.useOffsetFetchClause(queryPart) && this.getQueryPartForRowNumbering() != queryPart && this.supportsWindowFunctions() && !this.isRowsOnlyFetchClauseType(queryPart);
    }

    protected boolean supportsSimpleQueryGrouping() {
        return this.dialect.getVersion().isSameOrAfter(10, 4);
    }

    protected boolean shouldEmulateLateralWithIntersect(QueryPart queryPart) {
        return this.supportsSimpleQueryGrouping() || !queryPart.hasOffsetOrFetchClause();
    }

    protected boolean supportsNestedSubqueryCorrelation() {
        return false;
    }

    public void visitQueryGroup(QueryGroup queryGroup) {
        if (this.shouldEmulateFetchClause((QueryPart)queryGroup)) {
            this.emulateFetchOffsetWithWindowFunctions((QueryPart)queryGroup, true);
        } else {
            super.visitQueryGroup(queryGroup);
        }
    }

    public void visitQuerySpec(QuerySpec querySpec) {
        if (this.shouldEmulateFetchClause((QueryPart)querySpec)) {
            this.emulateFetchOffsetWithWindowFunctions((QueryPart)querySpec, true);
        } else {
            super.visitQuerySpec(querySpec);
        }
    }

    public void visitQueryPartTableReference(QueryPartTableReference tableReference) {
        this.emulateQueryPartTableReferenceColumnAliasing(tableReference);
    }

    public void visitOffsetFetchClause(QueryPart queryPart) {
        if (!this.isRowNumberingCurrentQueryPart()) {
            this.renderCombinedLimitClause(queryPart);
        }
    }

    protected void renderComparison(Expression lhs, ComparisonOperator operator, Expression rhs) {
        this.renderComparisonDistinctOperator(lhs, operator, rhs);
    }

    protected void renderPartitionItem(Expression expression) {
        if (expression instanceof Literal) {
            this.appendSql("'0'");
        } else if (expression instanceof Summarization) {
            Summarization summarization = (Summarization)expression;
            this.renderCommaSeparated(summarization.getGroupings());
            this.appendSql(" with ");
            this.appendSql(summarization.getKind().sqlText());
        } else {
            expression.accept((SqlAstWalker)this);
        }
    }

    public void visitLikePredicate(LikePredicate likePredicate) {
        if (likePredicate.isCaseSensitive()) {
            likePredicate.getMatchExpression().accept((SqlAstWalker)this);
            if (likePredicate.isNegated()) {
                this.appendSql(" not");
            }
            this.appendSql(" like ");
            this.renderBackslashEscapedLikePattern(likePredicate.getPattern(), likePredicate.getEscapeCharacter(), this.dialect.isNoBackslashEscapesEnabled());
        } else {
            this.appendSql(this.dialect.getLowercaseFunction());
            this.appendSql('(');
            likePredicate.getMatchExpression().accept((SqlAstWalker)this);
            this.appendSql(')');
            if (likePredicate.isNegated()) {
                this.appendSql(" not");
            }
            this.appendSql(" like ");
            this.appendSql(this.dialect.getLowercaseFunction());
            this.appendSql('(');
            this.renderBackslashEscapedLikePattern(likePredicate.getPattern(), likePredicate.getEscapeCharacter(), this.dialect.isNoBackslashEscapesEnabled());
            this.appendSql(')');
        }
        if (likePredicate.getEscapeCharacter() != null) {
            this.appendSql(" escape ");
            likePredicate.getEscapeCharacter().accept((SqlAstWalker)this);
        }
    }

    public boolean supportsRowValueConstructorSyntaxInSet() {
        return false;
    }

    protected boolean supportsRowValueConstructorSyntaxInQuantifiedPredicates() {
        return false;
    }

    protected boolean supportsIntersect() {
        return this.dialect.getVersion().isSameOrAfter(10, 3);
    }

    protected boolean supportsDistinctFromPredicate() {
        return true;
    }

    protected String getFromDual() {
        return " from dual";
    }

    protected String getFromDualForSelectOnly() {
        return this.getDialect().getVersion().isBefore(10, 4) ? this.getFromDual() : "";
    }

    public MariaDBLegacyDialect getDialect() {
        return this.dialect;
    }

    private boolean supportsWindowFunctions() {
        return this.dialect.getVersion().isSameOrAfter(10, 2);
    }

    public void visitCastTarget(CastTarget castTarget) {
        String sqlType = MySQLSqlAstTranslator.getSqlType((CastTarget)castTarget, (SessionFactoryImplementor)this.getSessionFactory());
        if (sqlType != null) {
            this.appendSql(sqlType);
        } else {
            super.visitCastTarget(castTarget);
        }
    }
}

