/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.community.dialect.sequence;

import org.hibernate.MappingException;
import org.hibernate.dialect.sequence.ANSISequenceSupport;
import org.hibernate.dialect.sequence.SequenceSupport;

public class FirebirdSequenceSupport
extends ANSISequenceSupport {
    public static final SequenceSupport INSTANCE = new FirebirdSequenceSupport(){

        public String getCreateSequenceString(String sequenceName, int initialValue, int incrementSize) {
            if (initialValue == 1 && incrementSize == 1) {
                return this.getCreateSequenceString(sequenceName);
            }
            return super.getCreateSequenceString(sequenceName, initialValue, incrementSize);
        }
    };
    public static final SequenceSupport LEGACY_INSTANCE = new FirebirdSequenceSupport(){

        public String[] getCreateSequenceStrings(String sequenceName, int initialValue, int incrementSize) {
            String[] stringArray;
            if (initialValue == 1) {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = this.getCreateSequenceString(sequenceName);
            } else {
                String[] stringArray3 = new String[2];
                stringArray3[0] = this.getCreateSequenceString(sequenceName);
                stringArray = stringArray3;
                stringArray3[1] = "alter sequence " + sequenceName + " restart with " + (initialValue - incrementSize);
            }
            return stringArray;
        }

        public String getSequenceNextValString(String sequenceName, int increment) {
            return increment == 1 ? this.getSequenceNextValString(sequenceName) : "select gen_id(" + sequenceName + "," + increment + ") from rdb$database";
        }
    };

    public String getFromDual() {
        return " from rdb$database";
    }

    public String getSelectSequencePreviousValString(String sequenceName) throws MappingException {
        return "gen_id(" + sequenceName + ",0)";
    }
}

