/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.community.dialect;

import java.util.List;
import java.util.function.Consumer;
import org.hibernate.LockMode;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.query.sqm.ComparisonOperator;
import org.hibernate.sql.ast.SqlAstNodeRenderingMode;
import org.hibernate.sql.ast.SqlAstWalker;
import org.hibernate.sql.ast.spi.AbstractSqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.ast.tree.Statement;
import org.hibernate.sql.ast.tree.cte.CteStatement;
import org.hibernate.sql.ast.tree.expression.CaseSearchedExpression;
import org.hibernate.sql.ast.tree.expression.CaseSimpleExpression;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.Literal;
import org.hibernate.sql.ast.tree.expression.SqlTuple;
import org.hibernate.sql.ast.tree.expression.Summarization;
import org.hibernate.sql.ast.tree.from.NamedTableReference;
import org.hibernate.sql.ast.tree.select.QueryPart;
import org.hibernate.sql.ast.tree.select.QuerySpec;
import org.hibernate.sql.ast.tree.select.SelectClause;
import org.hibernate.sql.exec.spi.JdbcOperation;

public class SybaseAnywhereSqlAstTranslator<T extends JdbcOperation>
extends AbstractSqlAstTranslator<T> {
    public SybaseAnywhereSqlAstTranslator(SessionFactoryImplementor sessionFactory, Statement statement) {
        super(sessionFactory, statement);
    }

    protected void visitAnsiCaseSearchedExpression(CaseSearchedExpression caseSearchedExpression, Consumer<Expression> resultRenderer) {
        if (this.getParameterRenderingMode() == SqlAstNodeRenderingMode.DEFAULT && this.areAllResultsParameters(caseSearchedExpression)) {
            List whenFragments = caseSearchedExpression.getWhenFragments();
            Expression firstResult = ((CaseSearchedExpression.WhenFragment)whenFragments.get(0)).getResult();
            super.visitAnsiCaseSearchedExpression(caseSearchedExpression, e -> {
                if (e == firstResult) {
                    this.renderCasted((Expression)e);
                } else {
                    resultRenderer.accept((Expression)e);
                }
            });
        } else {
            super.visitAnsiCaseSearchedExpression(caseSearchedExpression, resultRenderer);
        }
    }

    protected void visitAnsiCaseSimpleExpression(CaseSimpleExpression caseSimpleExpression, Consumer<Expression> resultRenderer) {
        if (this.getParameterRenderingMode() == SqlAstNodeRenderingMode.DEFAULT && this.areAllResultsParameters(caseSimpleExpression)) {
            List whenFragments = caseSimpleExpression.getWhenFragments();
            Expression firstResult = ((CaseSimpleExpression.WhenFragment)whenFragments.get(0)).getResult();
            super.visitAnsiCaseSimpleExpression(caseSimpleExpression, e -> {
                if (e == firstResult) {
                    this.renderCasted((Expression)e);
                } else {
                    resultRenderer.accept((Expression)e);
                }
            });
        } else {
            super.visitAnsiCaseSimpleExpression(caseSimpleExpression, resultRenderer);
        }
    }

    protected boolean renderNamedTableReference(NamedTableReference tableReference, LockMode lockMode) {
        super.renderNamedTableReference(tableReference, lockMode);
        if (this.getDialect().getVersion().isBefore(10)) {
            if (LockMode.READ.lessThan(lockMode)) {
                this.appendSql(" holdlock");
            }
            return true;
        }
        return false;
    }

    protected void renderForUpdateClause(QuerySpec querySpec, AbstractSqlAstTranslator.ForUpdateClause forUpdateClause) {
        if (this.getDialect().getVersion().isBefore(10)) {
            return;
        }
        super.renderForUpdateClause(querySpec, forUpdateClause);
    }

    protected boolean needsRowsToSkip() {
        return this.getDialect().getVersion().isBefore(9);
    }

    protected void renderFetchPlusOffsetExpression(Expression fetchClauseExpression, Expression offsetClauseExpression, int offset) {
        this.renderFetchPlusOffsetExpressionAsSingleParameter(fetchClauseExpression, offsetClauseExpression, offset);
    }

    protected void visitSqlSelections(SelectClause selectClause) {
        if (this.getDialect().getVersion().isBefore(9)) {
            this.renderTopClause((QuerySpec)this.getQueryPartStack().getCurrent(), true, true);
        } else {
            this.renderTopStartAtClause((QuerySpec)this.getQueryPartStack().getCurrent());
        }
        super.visitSqlSelections(selectClause);
    }

    protected void renderTopClause(QuerySpec querySpec, boolean addOffset, boolean needsParenthesis) {
        this.assertRowsOnlyFetchClauseType((QueryPart)querySpec);
        super.renderTopClause(querySpec, addOffset, needsParenthesis);
    }

    protected void renderTopStartAtClause(QuerySpec querySpec) {
        this.assertRowsOnlyFetchClauseType((QueryPart)querySpec);
        super.renderTopStartAtClause(querySpec);
    }

    public void visitOffsetFetchClause(QueryPart queryPart) {
        if (this.getDialect().getVersion().isBefore(9) && !queryPart.isRoot() && this.useOffsetFetchClause(queryPart) && queryPart.getOffsetClauseExpression() != null) {
            throw new IllegalArgumentException("Can't emulate offset clause in subquery");
        }
    }

    protected void renderSearchClause(CteStatement cte) {
    }

    protected void renderCycleClause(CteStatement cte) {
    }

    protected void renderComparison(Expression lhs, ComparisonOperator operator, Expression rhs) {
        this.renderComparisonEmulateIntersect(lhs, operator, rhs);
    }

    protected void renderSelectTupleComparison(List<SqlSelection> lhsExpressions, SqlTuple tuple, ComparisonOperator operator) {
        this.emulateSelectTupleComparison(lhsExpressions, tuple.getExpressions(), operator, true);
    }

    protected void renderPartitionItem(Expression expression) {
        if (expression instanceof Literal) {
            this.appendSql("()");
        } else {
            if (expression instanceof Summarization) {
                throw new UnsupportedOperationException("Summarization is not supported by DBMS!");
            }
            expression.accept((SqlAstWalker)this);
        }
    }

    protected boolean supportsRowValueConstructorSyntax() {
        return false;
    }

    protected boolean supportsRowValueConstructorSyntaxInInList() {
        return false;
    }

    protected boolean supportsRowValueConstructorSyntaxInQuantifiedPredicates() {
        return false;
    }

    protected String getFromDual() {
        return " from sys.dummy";
    }

    protected String getFromDualForSelectOnly() {
        return this.getFromDual();
    }
}

