/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.redis.impl.hash;

import java.util.HashMap;
import java.util.Map;
import org.hibernate.ogm.datastore.redis.impl.RedisJsonBlobType;
import org.hibernate.ogm.datastore.redis.impl.RedisJsonByteType;
import org.hibernate.ogm.datastore.redis.impl.hash.RedisHashEnumType;
import org.hibernate.ogm.datastore.redis.impl.hash.RedisHashType;
import org.hibernate.ogm.type.impl.Iso8601StringCalendarType;
import org.hibernate.ogm.type.impl.Iso8601StringDateType;
import org.hibernate.ogm.type.impl.SerializableAsStringType;
import org.hibernate.ogm.type.spi.GridType;
import org.hibernate.type.BinaryType;
import org.hibernate.type.CustomType;
import org.hibernate.type.EnumType;
import org.hibernate.type.MaterializedBlobType;
import org.hibernate.type.SerializableToBlobType;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.Type;

public class RedisHashTypeConverter {
    public static final RedisHashTypeConverter INSTANCE = new RedisHashTypeConverter();
    private static final Map<Type, GridType> conversionMap = RedisHashTypeConverter.createGridTypeConversionMap();

    private static Map<Type, GridType> createGridTypeConversionMap() {
        HashMap<Type, GridType> conversion = new HashMap<Type, GridType>();
        conversion.put((Type)StandardBasicTypes.CALENDAR, (GridType)Iso8601StringCalendarType.DATE_TIME);
        conversion.put((Type)StandardBasicTypes.CALENDAR_DATE, (GridType)Iso8601StringCalendarType.DATE);
        conversion.put((Type)StandardBasicTypes.DATE, (GridType)Iso8601StringDateType.DATE);
        conversion.put((Type)StandardBasicTypes.TIME, (GridType)Iso8601StringDateType.TIME);
        conversion.put((Type)StandardBasicTypes.TIMESTAMP, (GridType)Iso8601StringDateType.DATE_TIME);
        conversion.put((Type)StandardBasicTypes.BYTE, (GridType)RedisJsonByteType.INSTANCE);
        conversion.put((Type)StandardBasicTypes.INTEGER, (GridType)RedisHashType.INTEGER);
        conversion.put((Type)StandardBasicTypes.SHORT, (GridType)RedisHashType.SHORT);
        conversion.put((Type)StandardBasicTypes.LONG, (GridType)RedisHashType.LONG);
        conversion.put((Type)StandardBasicTypes.DOUBLE, (GridType)RedisHashType.DOUBLE);
        conversion.put((Type)StandardBasicTypes.FLOAT, (GridType)RedisHashType.FLOAT);
        conversion.put((Type)StandardBasicTypes.BYTE, (GridType)RedisHashType.BYTE);
        conversion.put((Type)BinaryType.INSTANCE, (GridType)RedisJsonBlobType.INSTANCE);
        conversion.put((Type)MaterializedBlobType.INSTANCE, (GridType)RedisJsonBlobType.INSTANCE);
        conversion.put((Type)StandardBasicTypes.SERIALIZABLE, (GridType)RedisJsonBlobType.INSTANCE);
        conversion.put((Type)StandardBasicTypes.BOOLEAN, (GridType)RedisHashType.BOOLEAN);
        conversion.put((Type)StandardBasicTypes.NUMERIC_BOOLEAN, (GridType)RedisHashType.NUMERIC_BOOLEAN);
        conversion.put((Type)StandardBasicTypes.UUID_BINARY, (GridType)RedisHashType.UUID_BINARY);
        return conversion;
    }

    public GridType convert(Type type) {
        CustomType customType;
        if (type instanceof CustomType && (customType = (CustomType)type).getUserType() instanceof EnumType) {
            EnumType enumType = (EnumType)customType.getUserType();
            return new RedisHashEnumType(customType, enumType);
        }
        if (type instanceof SerializableToBlobType) {
            return new SerializableAsStringType(((SerializableToBlobType)type).getJavaTypeDescriptor());
        }
        return conversionMap.get(type);
    }
}

