/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.redis.dialect.value;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.hibernate.ogm.datastore.document.impl.DotPatternMapHelpers;
import org.hibernate.ogm.datastore.redis.dialect.value.StructuredValue;

@JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
public class Entity
extends StructuredValue {
    private static final String PATH_SEPARATOR = ".";
    private static final Pattern PATH_SPLIT_PATTERN = Pattern.compile(Pattern.quote("."));
    private final Map<String, Object> properties = new HashMap<String, Object>();

    @JsonIgnore
    public Map<String, Object> getProperties() {
        HashMap<String, Object> props = new HashMap<String, Object>(this.properties);
        return props;
    }

    @JsonAnyGetter
    public Map<String, Object> getPropertiesAsHierarchy() {
        HashMap<String, Object> hierarchicalProperties = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : this.properties.entrySet()) {
            String columnName = entry.getKey();
            if (Entity.isEmbeddedProperty(columnName)) {
                Entity.putEmbeddedProperty(hierarchicalProperties, columnName, entry.getValue());
                continue;
            }
            hierarchicalProperties.put(columnName, entry.getValue());
        }
        return hierarchicalProperties;
    }

    public static void putEmbeddedProperty(Map<String, Object> root, String name, Object value) {
        String[] pathElements = PATH_SPLIT_PATTERN.split(name);
        HashMap<String, Object> owner = root;
        for (int i = 0; i < pathElements.length - 1; ++i) {
            String element = pathElements[i];
            HashMap<String, Object> nextOwner = (HashMap<String, Object>)owner.get(element);
            if (nextOwner == null) {
                nextOwner = new HashMap<String, Object>();
                owner.put(element, nextOwner);
            }
            owner = nextOwner;
        }
        owner.put(pathElements[pathElements.length - 1], value);
    }

    public static boolean isEmbeddedProperty(String columnName) {
        return columnName.contains(PATH_SEPARATOR);
    }

    @JsonAnySetter
    public void set(String name, Object value) {
        if (value instanceof Map) {
            this.setMapValue(name, (Map)value);
        } else {
            this.properties.put(name, value);
        }
    }

    private void setMapValue(String name, Map<String, Object> value) {
        for (Map.Entry<String, Object> entry : value.entrySet()) {
            this.set(name + PATH_SEPARATOR + entry.getKey(), entry.getValue());
        }
    }

    @JsonIgnore
    public void unset(String name) {
        if (this.properties.containsKey(name)) {
            this.properties.remove(name);
        } else {
            HashSet<String> keys = new HashSet<String>(this.properties.keySet());
            for (String key : keys) {
                if (!key.startsWith(name + PATH_SEPARATOR)) continue;
                this.unset(key);
            }
            DotPatternMapHelpers.resetValue(this.properties, (String)name);
        }
    }

    @JsonIgnore
    public boolean isEmpty() {
        return this.properties.isEmpty();
    }

    @JsonIgnore
    public Set<String> getKeys() {
        return this.properties.keySet();
    }

    @JsonIgnore
    public Object getProperty(String dotPath) {
        return this.properties.get(dotPath);
    }
}

