/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.redis;

import com.lambdaworks.redis.KeyScanCursor;
import com.lambdaworks.redis.ScanArgs;
import com.lambdaworks.redis.cluster.api.sync.RedisAdvancedClusterCommands;
import com.lambdaworks.redis.cluster.api.sync.RedisClusterCommands;
import com.lambdaworks.redis.cluster.models.partitions.RedisClusterNode;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.hibernate.ogm.datastore.document.impl.DotPatternMapHelpers;
import org.hibernate.ogm.datastore.redis.dialect.value.Association;
import org.hibernate.ogm.datastore.redis.dialect.value.Entity;
import org.hibernate.ogm.datastore.redis.impl.json.JsonSerializationStrategy;
import org.hibernate.ogm.datastore.redis.logging.impl.Log;
import org.hibernate.ogm.datastore.redis.logging.impl.LoggerFactory;
import org.hibernate.ogm.datastore.redis.options.impl.TTLOption;
import org.hibernate.ogm.dialect.impl.AbstractGroupingByEntityDialect;
import org.hibernate.ogm.dialect.spi.AssociationContext;
import org.hibernate.ogm.dialect.spi.NextValueRequest;
import org.hibernate.ogm.dialect.spi.OperationContext;
import org.hibernate.ogm.dialect.spi.TupleContext;
import org.hibernate.ogm.entityentry.impl.TuplePointer;
import org.hibernate.ogm.model.key.spi.AssociationKey;
import org.hibernate.ogm.model.key.spi.AssociationType;
import org.hibernate.ogm.model.key.spi.EntityKey;
import org.hibernate.ogm.model.key.spi.EntityKeyMetadata;
import org.hibernate.ogm.model.key.spi.IdSourceKey;
import org.hibernate.ogm.model.spi.Tuple;
import org.hibernate.ogm.options.spi.OptionsContext;

public abstract class AbstractRedisDialect
extends AbstractGroupingByEntityDialect {
    public static final String IDENTIFIERS = "Identifiers";
    public static final String ASSOCIATIONS = "Associations";
    private static final Pattern MODE_PATTERN = Pattern.compile("^redis_mode:([a-z]+)$", 8);
    private static final Log log = LoggerFactory.getLogger();
    protected final RedisClusterCommands<String, String> connection;
    protected final JsonSerializationStrategy strategy = new JsonSerializationStrategy();
    protected final boolean clusterMode;

    public AbstractRedisDialect(RedisClusterCommands<String, String> connection, boolean configuredForCluster) {
        this.connection = connection;
        String redisMode = this.getRedisMode(connection);
        if (redisMode != null) {
            log.connectedRedisNodeRunsIn(redisMode);
            this.clusterMode = "cluster".equalsIgnoreCase(redisMode.trim());
        } else {
            this.clusterMode = false;
        }
        if (configuredForCluster && !this.clusterMode) {
            log.redisModeMismatchClusterModeConfigured(redisMode);
        } else if (!configuredForCluster && this.clusterMode) {
            log.redisModeMismatchStandaloneModeConfigured(redisMode);
        }
    }

    private String getRedisMode(RedisClusterCommands<String, String> connection) {
        String info = connection.info("server");
        Matcher matcher = MODE_PATTERN.matcher(info);
        if (matcher.find()) {
            return matcher.group(1);
        }
        log.cannotDetermineRedisMode(info);
        return null;
    }

    public Number nextValue(NextValueRequest request) {
        String key = this.identifierId(request.getKey());
        Long value = this.connection.incrby((Object)key, (long)request.getIncrement());
        Long nextValue = value - (long)request.getIncrement() + (long)request.getInitialValue();
        return nextValue;
    }

    public boolean supportsSequences() {
        return true;
    }

    protected String identifierId(IdSourceKey key) {
        String prefix = "Identifiers:" + key.getTable();
        if (key.getColumnName() != null) {
            String entityId = key.getColumnValue();
            return prefix + ":" + entityId;
        }
        return prefix;
    }

    public void removeTuple(EntityKey key, TupleContext tupleContext) {
        this.remove(key);
    }

    protected void addKeyValuesFromKeyName(EntityKeyMetadata entityKeyMetadata, String prefix, String key, Entity document) {
        if (key.startsWith(prefix)) {
            String keyWithoutPrefix = this.getKeyWithoutTablePrefix(prefix, key);
            Map<String, Object> keys = this.keyStringToMap(entityKeyMetadata, keyWithoutPrefix);
            for (Map.Entry<String, Object> entry : keys.entrySet()) {
                document.set(entry.getKey(), entry.getValue());
            }
        }
    }

    protected static Object getAssociationRow(Tuple row, AssociationKey associationKey) {
        String[] columnsToPersist = associationKey.getMetadata().getColumnsWithoutKeyColumns((Iterable)row.getColumnNames());
        if (columnsToPersist.length == 1) {
            return row.get(columnsToPersist[0]);
        }
        Entity rowObject = new Entity();
        String prefix = DotPatternMapHelpers.getColumnSharedPrefixOfAssociatedEntityLink((AssociationKey)associationKey);
        for (String column : columnsToPersist) {
            Object value = row.get(column);
            if (value == null) continue;
            String columnName = column.startsWith(prefix) ? column.substring(prefix.length()) : column;
            rowObject.set(columnName, value);
        }
        return rowObject.getPropertiesAsHierarchy();
    }

    protected Long getObjectTTL(String objectId, OptionsContext optionsContext) {
        Long ttl = (Long)optionsContext.getUnique(TTLOption.class);
        if (ttl == null && (ttl = this.connection.pttl((Object)objectId)) != null && ttl <= 0L) {
            ttl = null;
        }
        return ttl;
    }

    protected String getKeyWithoutTablePrefix(String prefixBytes, String key) {
        return key.substring(prefixBytes.length());
    }

    protected void setObjectTTL(String objectId, Long ttl) {
        if (ttl != null) {
            this.connection.pexpire((Object)objectId, ttl.longValue());
        }
    }

    protected void removeAssociations(List<AssociationKey> keys) {
        if (keys.isEmpty()) {
            return;
        }
        Object[] ids = new String[keys.size()];
        int i = 0;
        for (AssociationKey key : keys) {
            ids[i] = this.associationId(key);
            ++i;
        }
        this.connection.del(ids);
    }

    protected void remove(EntityKey key) {
        this.connection.del((Object[])new String[]{this.entityId(key)});
    }

    protected Map<String, Object> keyStringToMap(EntityKeyMetadata entityKeyMetadata, String key) {
        if (entityKeyMetadata.getColumnNames().length == 1) {
            return Collections.singletonMap(entityKeyMetadata.getColumnNames()[0], key);
        }
        return this.strategy.deserialize(key, Map.class);
    }

    protected void addIdToEntity(Entity entity, String[] columnNames, Object[] columnValues) {
        for (int i = 0; i < columnNames.length; ++i) {
            entity.set(columnNames[i], columnValues[i]);
        }
    }

    protected String associationId(AssociationKey key) {
        String prefix = "Associations:" + key.getTable() + ":";
        String entityId = this.keyToString(key.getColumnNames(), key.getColumnValues()) + ":" + key.getMetadata().getCollectionRole();
        return prefix + entityId;
    }

    public String entityId(EntityKey key) {
        String prefix = key.getTable() + ":";
        String entityId = this.keyToString(key.getColumnNames(), key.getColumnValues());
        return prefix + entityId;
    }

    private String keyToString(String[] columnNames, Object[] columnValues) {
        if (columnNames.length == 1) {
            return columnValues[0].toString();
        }
        Collator collator = Collator.getInstance(Locale.ENGLISH);
        collator.setStrength(1);
        TreeMap<Object, Object> idObject = new TreeMap<Object, Object>(collator);
        for (int i = 0; i < columnNames.length; ++i) {
            idObject.put(columnNames[i], columnValues[i]);
        }
        return this.strategy.serialize(idObject);
    }

    protected Map<String, String> keyToMap(EntityKeyMetadata entityKeyMetadata, String key) {
        if (entityKeyMetadata.getColumnNames().length == 1) {
            return Collections.singletonMap(entityKeyMetadata.getColumnNames()[0], key);
        }
        return this.strategy.deserialize(key, Map.class);
    }

    protected Association getAssociation(AssociationKey key) {
        String associationId = this.associationId(key);
        Collection rows = key.getMetadata().getAssociationType() == AssociationType.SET ? this.connection.smembers((Object)associationId) : this.connection.lrange((Object)associationId, 0L, -1L);
        Association association = new Association();
        for (String item : rows) {
            association.getRows().add(this.strategy.deserialize(item, Object.class));
        }
        return association;
    }

    protected void storeAssociation(AssociationKey key, Association association) {
        String associationId = this.associationId(key);
        this.connection.del((Object[])new String[]{associationId});
        List<Object> rows = association.getRows();
        if (rows.isEmpty()) {
            return;
        }
        Object[] serializedRows = new String[rows.size()];
        int i = 0;
        for (Object row : rows) {
            serializedRows[i] = this.strategy.serialize(row);
            ++i;
        }
        if (key.getMetadata().getAssociationType() == AssociationType.SET) {
            this.connection.sadd((Object)associationId, serializedRows);
        } else {
            this.connection.rpush((Object)associationId, serializedRows);
        }
    }

    protected TuplePointer getEmbeddingEntityTuplePointer(AssociationKey key, AssociationContext associationContext) {
        TuplePointer tuplePointer = associationContext.getEntityTuplePointer();
        if (tuplePointer.getTuple() == null) {
            tuplePointer.setTuple(this.getTuple(key.getEntityKey(), (OperationContext)associationContext));
        }
        return tuplePointer;
    }

    protected KeyScanCursor<String> scan(KeyScanCursor<String> cursor, ScanArgs scanArgs) {
        if (!this.clusterMode) {
            return this.scan(this.connection, cursor, scanArgs);
        }
        return this.clusterScan(cursor, scanArgs);
    }

    private KeyScanCursor<String> scan(RedisClusterCommands<String, String> commands, KeyScanCursor<String> cursor, ScanArgs scanArgs) {
        if (cursor != null) {
            return commands.scan(cursor, scanArgs);
        }
        return commands.scan(scanArgs);
    }

    private KeyScanCursor<String> clusterScan(KeyScanCursor<String> cursor, ScanArgs scanArgs) {
        String currentNodeId;
        List<String> nodeIds;
        RedisAdvancedClusterCommands commands = (RedisAdvancedClusterCommands)this.connection;
        if (cursor == null) {
            Set masterNodes = commands.masters().asMap().keySet();
            nodeIds = new ArrayList<String>();
            for (RedisClusterNode masterNode : masterNodes) {
                if (masterNode.getSlots().isEmpty()) continue;
                nodeIds.add(masterNode.getNodeId());
            }
            if (nodeIds.isEmpty()) {
                return this.scan(this.connection, cursor, scanArgs);
            }
            currentNodeId = nodeIds.get(0);
        } else {
            ClusterwideKeyScanCursor clusterKeyScanCursor = (ClusterwideKeyScanCursor)cursor;
            nodeIds = clusterKeyScanCursor.nodeIds;
            currentNodeId = this.getNodeIdForNextScanIteration(nodeIds, clusterKeyScanCursor);
        }
        RedisClusterCommands nodeConnection = commands.getConnection(currentNodeId);
        KeyScanCursor<String> nodeKeyScanCursor = this.scan((RedisClusterCommands<String, String>)nodeConnection, cursor, scanArgs);
        return new ClusterwideKeyScanCursor<String>(nodeIds, currentNodeId, nodeKeyScanCursor);
    }

    private String getNodeIdForNextScanIteration(List<String> nodeIds, ClusterwideKeyScanCursor<String> clusterKeyScanCursor) {
        if (((ClusterwideKeyScanCursor)clusterKeyScanCursor).isScanOnCurrentNodeFinished()) {
            int nodeIndex = nodeIds.indexOf(clusterKeyScanCursor.currentNodeId);
            return nodeIds.get(nodeIndex + 1);
        }
        return clusterKeyScanCursor.currentNodeId;
    }

    public boolean isClusterMode() {
        return this.clusterMode;
    }

    static class ClusterwideKeyScanCursor<K>
    extends KeyScanCursor<K> {
        final List<String> nodeIds;
        final String currentNodeId;
        final KeyScanCursor<K> cursor;

        public ClusterwideKeyScanCursor(List<String> nodeIds, String currentNodeId, KeyScanCursor<K> cursor) {
            int nodeIndex;
            this.nodeIds = nodeIds;
            this.currentNodeId = currentNodeId;
            this.cursor = cursor;
            this.setCursor(cursor.getCursor());
            this.getKeys().addAll(cursor.getKeys());
            if (cursor.isFinished() && ((nodeIndex = nodeIds.indexOf(currentNodeId)) == -1 || nodeIndex == nodeIds.size() - 1)) {
                this.setFinished(true);
            }
        }

        private boolean isScanOnCurrentNodeFinished() {
            return this.cursor.isFinished();
        }
    }
}

