/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.redis.impl.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import org.hibernate.ogm.datastore.redis.impl.SerializationStrategy;
import org.hibernate.ogm.datastore.redis.impl.json.RedisJsonTypeConverter;
import org.hibernate.ogm.type.spi.GridType;
import org.hibernate.type.Type;

public class JsonSerializationStrategy
implements SerializationStrategy {
    private static final String NULL = "null";
    private final ObjectMapper objectMapper = new ObjectMapper().configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);

    @Override
    public <T> T deserialize(String serialized, Class<T> targetType) {
        if (serialized == null || serialized.length() == 0 || NULL.equals(serialized)) {
            return null;
        }
        try {
            JsonParser parser = this.objectMapper.reader().getFactory().createParser(serialized);
            return (T)this.objectMapper.reader().readValue(parser, targetType);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public String serialize(Object payload) {
        try {
            return this.objectMapper.writer().writeValueAsString(payload);
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public GridType overrideType(Type type) {
        return RedisJsonTypeConverter.INSTANCE.convert(type);
    }
}

