/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.neo4j.remote.http.dialect.impl;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.hibernate.ogm.datastore.neo4j.BaseNeo4jDialect;
import org.hibernate.ogm.datastore.neo4j.remote.http.dialect.impl.NodeWithEmbeddedNodes;
import org.hibernate.ogm.datastore.neo4j.remote.http.json.impl.Graph;
import org.hibernate.ogm.dialect.spi.TupleTypeContext;
import org.hibernate.ogm.model.key.spi.AssociatedEntityKeyMetadata;
import org.hibernate.ogm.model.key.spi.EntityKeyMetadata;
import org.hibernate.ogm.model.spi.TupleSnapshot;

public final class HttpNeo4jTupleSnapshot
implements TupleSnapshot {
    private final Graph.Node node;
    private final Map<String, AssociatedEntityKeyMetadata> associatedEntityKeyMetadata;
    private final EntityKeyMetadata entityKeyMetadata;
    private final Map<String, Graph.Node> toOneEntities;
    private final Map<String, Collection<Graph.Node>> embeddedNodes;
    private final Map<String, String> rolesByColumn;

    public HttpNeo4jTupleSnapshot(NodeWithEmbeddedNodes node, EntityKeyMetadata entityKeyMetadata, Map<String, Graph.Node> toOneEntities, TupleTypeContext tupleTypeContext) {
        this.node = node.getOwner();
        this.embeddedNodes = node.getEmbeddedNodes();
        this.entityKeyMetadata = entityKeyMetadata;
        this.toOneEntities = toOneEntities;
        this.associatedEntityKeyMetadata = tupleTypeContext.getAllAssociatedEntityKeyMetadata();
        this.rolesByColumn = tupleTypeContext.getAllRoles();
    }

    public Object get(String column) {
        if (this.associatedEntityKeyMetadata.containsKey(column)) {
            return this.readPropertyOnOtherNode(column);
        }
        if (BaseNeo4jDialect.isPartOfRegularEmbedded(this.entityKeyMetadata.getColumnNames(), column)) {
            return this.readEmbeddedProperty(column);
        }
        return this.readProperty(this.node, column);
    }

    private Object readPropertyOnOtherNode(String column) {
        String associationrole = this.rolesByColumn.get(column);
        Graph.Node associatedEntity = this.toOneEntities.get(associationrole);
        if (associatedEntity == null) {
            return null;
        }
        return this.readProperty(associatedEntity, this.associatedEntityKeyMetadata.get(column).getCorrespondingEntityKeyColumn(column));
    }

    private Object readEmbeddedProperty(String column) {
        String embeddedPath = column.substring(0, column.lastIndexOf("."));
        String property = column.substring(embeddedPath.length() + 1);
        if (this.embeddedNodes.containsKey(embeddedPath)) {
            Graph.Node embeddedNode = this.embeddedNodes.get(embeddedPath).iterator().next();
            return this.readProperty(embeddedNode, property);
        }
        return null;
    }

    private Object readProperty(Graph.Node node, String targetColumnName) {
        if (node.getProperties().containsKey(targetColumnName)) {
            return node.getProperties().get(targetColumnName);
        }
        return null;
    }

    public boolean isEmpty() {
        return this.node.getProperties().isEmpty();
    }

    public Set<String> getColumnNames() {
        HashSet<String> names = new HashSet<String>();
        for (String string : this.node.getProperties().keySet()) {
            names.add(string);
        }
        return names;
    }

    public Graph.Node getNode() {
        return this.node;
    }
}

