/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.neo4j.remote.common.impl;

import org.hibernate.ogm.cfg.impl.HostParser;
import org.hibernate.ogm.cfg.spi.Hosts;
import org.hibernate.ogm.datastore.neo4j.Neo4jProperties;
import org.hibernate.ogm.util.configurationreader.impl.Validators;
import org.hibernate.ogm.util.configurationreader.spi.ConfigurationPropertyReader;

public class RemoteNeo4jConfiguration {
    public static final int DEFAULT_HTTP_PORT = 7474;
    public static final int DEFAULT_BOLT_PORT = 7687;
    public static final int DEFAULT_CONNECTION_POOL_SIZE = 10;
    private static final String DEFAULT_HOST = "localhost";
    private static final String DEFAULT_DB = "db/data";
    private final Hosts hosts;
    private final String databaseName;
    private final String username;
    private final String password;
    private final boolean createDatabase;
    private final Long socketTimeout;
    private final Long establishConnectionTimeout;
    private final Long connectionCheckoutTimeout;
    private final Long connectionTTL;
    private final boolean authenticationRequired;
    private final Integer clientPoolSize;
    private final String nativeClientResource;

    public RemoteNeo4jConfiguration(ConfigurationPropertyReader propertyReader, int defaultPort) {
        String host = (String)propertyReader.property("hibernate.ogm.datastore.host", String.class).withDefault((Object)DEFAULT_HOST).getValue();
        Integer port = (Integer)propertyReader.property("hibernate.ogm.datastore.port", Integer.class).withValidator(Validators.PORT).withDefault(null).getValue();
        this.hosts = HostParser.parse((String)host, (Integer)port, (Integer)defaultPort);
        this.databaseName = (String)propertyReader.property("hibernate.ogm.datastore.database", String.class).withDefault((Object)DEFAULT_DB).getValue();
        this.username = (String)propertyReader.property("hibernate.ogm.datastore.username", String.class).getValue();
        this.password = (String)propertyReader.property("hibernate.ogm.datastore.password", String.class).getValue();
        this.socketTimeout = (Long)propertyReader.property(Neo4jProperties.SOCKET_TIMEOUT, Long.class).getValue();
        this.establishConnectionTimeout = (Long)propertyReader.property("hibernate.ogm.neo4j.client.establish_connection_timeout", Long.class).getValue();
        this.connectionCheckoutTimeout = (Long)propertyReader.property("hibernate.ogm.neo4j.client.connection_checkout_timeout", Long.class).getValue();
        this.connectionTTL = (Long)propertyReader.property("hibernate.ogm.neo4j.client.connection_ttl", Long.class).getValue();
        this.createDatabase = (Boolean)propertyReader.property("hibernate.ogm.datastore.create_database", Boolean.TYPE).withDefault((Object)false).getValue();
        this.authenticationRequired = this.username != null;
        this.clientPoolSize = (Integer)propertyReader.property("hibernate.ogm.neo4j.client.connection_pool_size", Integer.class).withDefault((Object)10).getValue();
        this.nativeClientResource = (String)propertyReader.property("hibernate.connection.resource", String.class).withDefault(null).getValue();
    }

    public Hosts getHosts() {
        return this.hosts;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public boolean isCreateDatabase() {
        return this.createDatabase;
    }

    public Long getSocketTimeout() {
        return this.socketTimeout;
    }

    public Long getConnectionCheckoutTimeout() {
        return this.connectionCheckoutTimeout;
    }

    public Long getConnectionTTL() {
        return this.connectionTTL;
    }

    public Long getEstablishConnectionTimeout() {
        return this.establishConnectionTimeout;
    }

    public boolean isAuthenticationRequired() {
        return this.authenticationRequired;
    }

    public Integer getClientPoolSize() {
        return this.clientPoolSize;
    }

    public String getNativeClientResource() {
        return this.nativeClientResource;
    }
}

