/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.neo4j.remote.bolt.impl;

import java.lang.invoke.MethodHandles;
import org.hibernate.HibernateException;
import org.hibernate.engine.jndi.spi.JndiService;
import org.hibernate.ogm.datastore.neo4j.BoltNeo4jDialect;
import org.hibernate.ogm.datastore.neo4j.logging.impl.Log;
import org.hibernate.ogm.datastore.neo4j.logging.impl.LoggerFactory;
import org.hibernate.ogm.datastore.neo4j.remote.bolt.dialect.impl.BoltNeo4jSequenceGenerator;
import org.hibernate.ogm.datastore.neo4j.remote.bolt.impl.BoltNeo4jClient;
import org.hibernate.ogm.datastore.neo4j.remote.bolt.impl.BoltNeo4jSchemaDefiner;
import org.hibernate.ogm.datastore.neo4j.remote.bolt.transaction.impl.BoltNeo4jTransactionCoordinatorBuilder;
import org.hibernate.ogm.datastore.neo4j.remote.common.impl.RemoteNeo4jDatastoreProvider;
import org.hibernate.ogm.datastore.spi.SchemaDefiner;
import org.hibernate.ogm.dialect.spi.GridDialect;
import org.hibernate.resource.transaction.spi.TransactionCoordinatorBuilder;
import org.hibernate.service.spi.Configurable;
import org.hibernate.service.spi.ServiceRegistryAwareService;
import org.hibernate.service.spi.ServiceRegistryImplementor;
import org.hibernate.service.spi.Startable;
import org.hibernate.service.spi.Stoppable;
import org.neo4j.driver.v1.Driver;

public class BoltNeo4jDatastoreProvider
extends RemoteNeo4jDatastoreProvider
implements Startable,
Stoppable,
Configurable,
ServiceRegistryAwareService {
    private static final String BOLT_PROTOCOL = "bolt";
    private static final Log log = LoggerFactory.make(MethodHandles.lookup());
    private BoltNeo4jClient client;
    private BoltNeo4jSequenceGenerator sequenceGenerator;
    private JndiService jndiService;

    public BoltNeo4jDatastoreProvider() {
        super(BOLT_PROTOCOL, 7687);
    }

    public TransactionCoordinatorBuilder getTransactionCoordinatorBuilder(TransactionCoordinatorBuilder coordinatorBuilder) {
        return new BoltNeo4jTransactionCoordinatorBuilder(coordinatorBuilder, this);
    }

    public Class<? extends SchemaDefiner> getSchemaDefinerType() {
        return BoltNeo4jSchemaDefiner.class;
    }

    public void start() {
        if (this.client != null) {
            return;
        }
        if (this.configuration.getNativeClientResource() == null) {
            this.createClient();
        } else {
            this.lookupClient();
        }
        this.sequenceGenerator = new BoltNeo4jSequenceGenerator(this.client, this.getSequenceCacheMaxSize());
        this.jndiService = null;
    }

    private void createClient() {
        try {
            this.client = new BoltNeo4jClient(this.getDatabaseIdentifier(), this.configuration);
        }
        catch (HibernateException e) {
            throw log.unableToStartDatastoreProvider((Exception)((Object)e));
        }
    }

    private void lookupClient() {
        try {
            log.tracef("Retrieving MongoDatabase from JNDI at %1$s", this.configuration.getNativeClientResource());
            Driver driver = (Driver)this.jndiService.locate(this.configuration.getNativeClientResource());
            this.client = new BoltNeo4jClient(driver);
        }
        catch (RuntimeException e) {
            throw log.errorOnFetchJndiClientProperty(this.configuration.getNativeClientResource());
        }
    }

    public void stop() {
        try {
            if (this.client != null) {
                this.client.close();
            }
        }
        finally {
            this.client = null;
        }
    }

    @Override
    public void injectServices(ServiceRegistryImplementor serviceRegistry) {
        this.jndiService = (JndiService)serviceRegistry.getService(JndiService.class);
    }

    public Class<? extends GridDialect> getDefaultDialect() {
        return BoltNeo4jDialect.class;
    }

    @Override
    public BoltNeo4jSequenceGenerator getSequenceGenerator() {
        return this.sequenceGenerator;
    }

    public BoltNeo4jClient getClient() {
        return this.client;
    }
}

