/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.neo4j.remote.http.impl;

import java.lang.invoke.MethodHandles;
import java.util.List;
import java.util.Set;
import org.hibernate.boot.model.relational.Sequence;
import org.hibernate.ogm.datastore.neo4j.impl.BaseNeo4jSchemaDefiner;
import org.hibernate.ogm.datastore.neo4j.logging.impl.Log;
import org.hibernate.ogm.datastore.neo4j.logging.impl.LoggerFactory;
import org.hibernate.ogm.datastore.neo4j.remote.http.dialect.impl.HttpNeo4jSequenceGenerator;
import org.hibernate.ogm.datastore.neo4j.remote.http.impl.HttpNeo4jClient;
import org.hibernate.ogm.datastore.neo4j.remote.http.impl.HttpNeo4jDatastoreProvider;
import org.hibernate.ogm.datastore.neo4j.remote.http.json.impl.ErrorResponse;
import org.hibernate.ogm.datastore.neo4j.remote.http.json.impl.Statement;
import org.hibernate.ogm.datastore.neo4j.remote.http.json.impl.Statements;
import org.hibernate.ogm.datastore.neo4j.remote.http.json.impl.StatementsResponse;
import org.hibernate.ogm.datastore.spi.DatastoreProvider;
import org.hibernate.ogm.model.key.spi.IdSourceKeyMetadata;

public class HttpNeo4jSchemaDefiner
extends BaseNeo4jSchemaDefiner {
    private static final Log log = LoggerFactory.make(MethodHandles.lookup());

    @Override
    protected void createSequences(List<Sequence> sequences, Set<IdSourceKeyMetadata> allIdSourceKeyMetadata, DatastoreProvider provider) {
        HttpNeo4jSequenceGenerator sequenceGenerator = ((HttpNeo4jDatastoreProvider)provider).getSequenceGenerator();
        sequenceGenerator.createSequences(sequences, allIdSourceKeyMetadata);
    }

    @Override
    protected void createUniqueConstraintsIfMissing(DatastoreProvider provider, List<BaseNeo4jSchemaDefiner.UniqueConstraintDetails> constraints) {
        Statements statements = new Statements();
        for (BaseNeo4jSchemaDefiner.UniqueConstraintDetails constraint : constraints) {
            log.tracef("Creating unique constraint for nodes labeled as %1$s on property %2$s", constraint.getLabel().name(), constraint.getProperty());
            statements.addStatement(new Statement(constraint.asCypherQuery()));
        }
        log.debug("Creating missing constraints");
        HttpNeo4jClient remoteClient = ((HttpNeo4jDatastoreProvider)provider).getClient();
        StatementsResponse response = remoteClient.executeQueriesInNewTransaction(statements);
        this.validateConstraintsCreation(response);
    }

    private void validateConstraintsCreation(StatementsResponse response) {
        if (!response.getErrors().isEmpty()) {
            ErrorResponse errorResponse = response.getErrors().get(0);
            throw log.constraintsCreationException(errorResponse.getCode(), errorResponse.getMessage());
        }
    }
}

