/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.neo4j;

import java.lang.invoke.MethodHandles;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.AssertionFailure;
import org.hibernate.HibernateException;
import org.hibernate.ogm.datastore.neo4j.BaseNeo4jDialect;
import org.hibernate.ogm.datastore.neo4j.RemoteNeo4jDialect;
import org.hibernate.ogm.datastore.neo4j.logging.impl.Log;
import org.hibernate.ogm.datastore.neo4j.logging.impl.LoggerFactory;
import org.hibernate.ogm.datastore.neo4j.remote.common.dialect.impl.RemoteNeo4jAssociationPropertiesRow;
import org.hibernate.ogm.datastore.neo4j.remote.common.dialect.impl.RemoteNeo4jAssociationSnapshot;
import org.hibernate.ogm.datastore.neo4j.remote.common.dialect.impl.RemoteNeo4jTupleAssociationSnapshot;
import org.hibernate.ogm.datastore.neo4j.remote.common.util.impl.RemoteNeo4jHelper;
import org.hibernate.ogm.datastore.neo4j.remote.http.dialect.impl.HttpNeo4jAssociatedNodesHelper;
import org.hibernate.ogm.datastore.neo4j.remote.http.dialect.impl.HttpNeo4jAssociationQueries;
import org.hibernate.ogm.datastore.neo4j.remote.http.dialect.impl.HttpNeo4jEntityQueries;
import org.hibernate.ogm.datastore.neo4j.remote.http.dialect.impl.HttpNeo4jMapsTupleIterator;
import org.hibernate.ogm.datastore.neo4j.remote.http.dialect.impl.HttpNeo4jNodesTupleIterator;
import org.hibernate.ogm.datastore.neo4j.remote.http.dialect.impl.HttpNeo4jSequenceGenerator;
import org.hibernate.ogm.datastore.neo4j.remote.http.dialect.impl.HttpNeo4jTupleSnapshot;
import org.hibernate.ogm.datastore.neo4j.remote.http.dialect.impl.HttpNeo4jTypeConverter;
import org.hibernate.ogm.datastore.neo4j.remote.http.dialect.impl.NodeWithEmbeddedNodes;
import org.hibernate.ogm.datastore.neo4j.remote.http.impl.HttpNeo4jClient;
import org.hibernate.ogm.datastore.neo4j.remote.http.impl.HttpNeo4jDatastoreProvider;
import org.hibernate.ogm.datastore.neo4j.remote.http.json.impl.ErrorResponse;
import org.hibernate.ogm.datastore.neo4j.remote.http.json.impl.Graph;
import org.hibernate.ogm.datastore.neo4j.remote.http.json.impl.Row;
import org.hibernate.ogm.datastore.neo4j.remote.http.json.impl.Statement;
import org.hibernate.ogm.datastore.neo4j.remote.http.json.impl.StatementResult;
import org.hibernate.ogm.datastore.neo4j.remote.http.json.impl.Statements;
import org.hibernate.ogm.datastore.neo4j.remote.http.json.impl.StatementsResponse;
import org.hibernate.ogm.dialect.query.spi.BackendQuery;
import org.hibernate.ogm.dialect.query.spi.ClosableIterator;
import org.hibernate.ogm.dialect.query.spi.QueryParameters;
import org.hibernate.ogm.dialect.spi.AssociationContext;
import org.hibernate.ogm.dialect.spi.ModelConsumer;
import org.hibernate.ogm.dialect.spi.NextValueRequest;
import org.hibernate.ogm.dialect.spi.OperationContext;
import org.hibernate.ogm.dialect.spi.TransactionContext;
import org.hibernate.ogm.dialect.spi.TupleAlreadyExistsException;
import org.hibernate.ogm.dialect.spi.TupleContext;
import org.hibernate.ogm.dialect.spi.TupleTypeContext;
import org.hibernate.ogm.dialect.spi.TuplesSupplier;
import org.hibernate.ogm.entityentry.impl.TuplePointer;
import org.hibernate.ogm.model.key.spi.AssociatedEntityKeyMetadata;
import org.hibernate.ogm.model.key.spi.AssociationKey;
import org.hibernate.ogm.model.key.spi.AssociationKeyMetadata;
import org.hibernate.ogm.model.key.spi.EntityKey;
import org.hibernate.ogm.model.key.spi.EntityKeyMetadata;
import org.hibernate.ogm.model.key.spi.RowKey;
import org.hibernate.ogm.model.spi.Association;
import org.hibernate.ogm.model.spi.AssociationOperation;
import org.hibernate.ogm.model.spi.AssociationSnapshot;
import org.hibernate.ogm.model.spi.Tuple;
import org.hibernate.ogm.model.spi.TupleOperation;
import org.hibernate.ogm.model.spi.TupleSnapshot;

public class HttpNeo4jDialect
extends BaseNeo4jDialect<HttpNeo4jEntityQueries, HttpNeo4jAssociationQueries>
implements RemoteNeo4jDialect {
    private static final Log log = LoggerFactory.make(MethodHandles.lookup());
    private static final int UNKNOWN_UPDATES = -1;
    private final HttpNeo4jClient client;
    private final HttpNeo4jSequenceGenerator sequenceGenerator;

    public HttpNeo4jDialect(HttpNeo4jDatastoreProvider provider) {
        super(HttpNeo4jTypeConverter.INSTANCE);
        this.client = provider.getClient();
        this.sequenceGenerator = provider.getSequenceGenerator();
    }

    @Override
    protected HttpNeo4jAssociationQueries createNeo4jAssociationQueries(EntityKeyMetadata ownerEntityKeyMetadata, AssociationKeyMetadata associationKeyMetadata) {
        return new HttpNeo4jAssociationQueries(ownerEntityKeyMetadata, associationKeyMetadata);
    }

    @Override
    protected HttpNeo4jEntityQueries createNeo4jEntityQueries(EntityKeyMetadata entityKeyMetadata, TupleTypeContext tupleTypeContext) {
        return new HttpNeo4jEntityQueries(entityKeyMetadata, tupleTypeContext);
    }

    public Tuple getTuple(EntityKey key, OperationContext operationContext) {
        Long txId;
        HttpNeo4jEntityQueries queries = (HttpNeo4jEntityQueries)this.getEntityQueries(key.getMetadata(), operationContext);
        NodeWithEmbeddedNodes owner = queries.findEntity(this.client, txId = this.transactionId(operationContext.getTransactionContext()), key.getColumnValues());
        if (owner == null) {
            return null;
        }
        Map<String, Graph.Node> toOneEntities = HttpNeo4jAssociatedNodesHelper.findAssociatedNodes(this.client, txId, owner, key.getMetadata(), operationContext.getTupleTypeContext(), queries);
        return new Tuple((TupleSnapshot)new HttpNeo4jTupleSnapshot(owner, key.getMetadata(), toOneEntities, operationContext.getTupleTypeContext()), Tuple.SnapshotType.UPDATE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Tuple> getTuples(EntityKey[] keys, TupleContext tupleContext) {
        if (keys.length == 0) {
            return Collections.emptyList();
        }
        Long txId = this.transactionId(tupleContext.getTransactionContext());
        EntityKeyMetadata metadata = keys[0].getMetadata();
        HttpNeo4jEntityQueries queries = (HttpNeo4jEntityQueries)this.getEntityQueries(metadata, (OperationContext)tupleContext);
        try (ClosableIterator<NodeWithEmbeddedNodes> nodes = queries.findEntities(this.client, keys, txId);){
            List<Tuple> list = this.tuplesResult(keys, tupleContext, nodes, txId, queries);
            return list;
        }
    }

    private List<Tuple> tuplesResult(EntityKey[] keys, TupleContext tupleContext, ClosableIterator<NodeWithEmbeddedNodes> nodes, Long txId, HttpNeo4jEntityQueries queries) {
        Tuple[] tuples = new Tuple[keys.length];
        block0: while (nodes.hasNext()) {
            NodeWithEmbeddedNodes node = (NodeWithEmbeddedNodes)nodes.next();
            for (int i = 0; i < keys.length; ++i) {
                String[] keyNames = keys[i].getColumnNames();
                Object[] keyValues = keys[i].getColumnValues();
                Map<String, Object> nodeProperties = node.getOwner().getProperties();
                if (!RemoteNeo4jHelper.matches(nodeProperties, keyNames, keyValues)) continue;
                EntityKeyMetadata metadata = keys[i].getMetadata();
                Map<String, Graph.Node> toOneEntities = HttpNeo4jAssociatedNodesHelper.findAssociatedNodes(this.client, txId, node, metadata, tupleContext.getTupleTypeContext(), queries);
                tuples[i] = new Tuple((TupleSnapshot)new HttpNeo4jTupleSnapshot(node, metadata, toOneEntities, tupleContext.getTupleTypeContext()), Tuple.SnapshotType.UPDATE);
                continue block0;
            }
        }
        return Arrays.asList(tuples);
    }

    public void insertOrUpdateTuple(EntityKey key, TuplePointer tuplePointer, TupleContext tupleContext) {
        Tuple tuple = tuplePointer.getTuple();
        HashMap<String, EntityKey> toOneAssociations = new HashMap<String, EntityKey>();
        Statements statements = new Statements();
        HashMap<String, Object> properties = new HashMap<String, Object>();
        this.applyTupleOperations(key, tuple, properties, toOneAssociations, statements, tuple.getOperations(), tupleContext, tupleContext.getTransactionContext());
        if (Tuple.SnapshotType.INSERT.equals((Object)tuple.getSnapshotType())) {
            Statement statement = ((HttpNeo4jEntityQueries)this.getEntityQueries(key.getMetadata(), (OperationContext)tupleContext)).getCreateEntityWithPropertiesQueryStatement(key.getColumnValues(), properties);
            statements.getStatements().add(0, statement);
        } else {
            this.updateTuple(key, statements, properties, tupleContext.getTupleTypeContext());
        }
        this.saveToOneAssociations(statements, key, tupleContext.getTupleTypeContext(), toOneAssociations);
        Long txId = this.transactionId(tupleContext.getTransactionContext());
        StatementsResponse readEntity = this.client.executeQueriesInOpenTransaction(txId, statements);
        this.validate(readEntity, key);
        tuple.setSnapshotType(Tuple.SnapshotType.UPDATE);
    }

    private Long transactionId(TransactionContext context) {
        return (Long)context.getTransactionId();
    }

    private void updateTuple(EntityKey key, Statements statements, Map<String, Object> properties, TupleTypeContext tupleTypeContext) {
        if (!properties.isEmpty()) {
            Statement statement = ((HttpNeo4jEntityQueries)this.getEntityQueries(key.getMetadata(), tupleTypeContext)).getUpdateEntityPropertiesStatement(key.getColumnValues(), properties);
            statements.addStatement(statement);
        }
    }

    private void validate(StatementsResponse readEntity, EntityKey key) {
        if (!readEntity.getErrors().isEmpty()) {
            ErrorResponse errorResponse = readEntity.getErrors().get(0);
            switch (errorResponse.getCode()) {
                case "Neo.ClientError.Schema.ConstraintValidationFailed": {
                    throw this.extractException(key, errorResponse);
                }
            }
            throw new HibernateException(String.valueOf(errorResponse));
        }
    }

    private HibernateException extractException(EntityKey key, ErrorResponse errorResponse) {
        if (TUPLE_ALREADY_EXISTS_EXCEPTION_PATTERN.matcher(errorResponse.getMessage()).matches()) {
            return new TupleAlreadyExistsException(key, errorResponse.getMessage());
        }
        return log.constraintViolation(key, errorResponse.getMessage(), null);
    }

    private void saveToOneAssociations(Statements statements, EntityKey key, TupleTypeContext tupleTypeContext, Map<String, EntityKey> toOneAssociations) {
        for (Map.Entry<String, EntityKey> entry : toOneAssociations.entrySet()) {
            Statement statement = ((HttpNeo4jEntityQueries)this.getEntityQueries(key.getMetadata(), tupleTypeContext)).getUpdateOneToOneAssociationStatement(entry.getKey(), key.getColumnValues(), entry.getValue().getColumnValues());
            statements.addStatement(statement);
        }
    }

    public void removeTuple(EntityKey key, TupleContext tupleContext) {
        Long txId = this.transactionId(tupleContext.getTransactionContext());
        ((HttpNeo4jEntityQueries)this.getEntityQueries(key.getMetadata(), tupleContext.getTupleTypeContext())).removeEntity(this.client, txId, key.getColumnValues());
    }

    private void putAssociationOperation(AssociationKey associationKey, AssociationOperation action, AssociationContext associationContext) {
        switch (associationKey.getMetadata().getAssociationKind()) {
            case EMBEDDED_COLLECTION: {
                this.createRelationshipWithEmbeddedNode(associationKey, associationContext, action);
                break;
            }
            case ASSOCIATION: {
                this.findOrCreateRelationshipWithEntityNode(associationKey, associationContext, action);
                break;
            }
            default: {
                throw new AssertionFailure("Unrecognized associationKind: " + associationKey.getMetadata().getAssociationKind());
            }
        }
    }

    private void createRelationshipWithEmbeddedNode(AssociationKey associationKey, AssociationContext associationContext, AssociationOperation action) {
        AssociatedEntityKeyMetadata associatedEntityKeyMetadata = associationContext.getAssociationTypeContext().getAssociatedEntityKeyMetadata();
        Long txId = this.transactionId(associationContext.getTransactionContext());
        Tuple associationRow = action.getValue();
        EntityKey embeddedKey = this.getEntityKey(associationRow, associatedEntityKeyMetadata);
        if (!HttpNeo4jDialect.emptyNode(embeddedKey)) {
            Object[] relationshipProperties = this.relationshipProperties(associationKey, action);
            ((HttpNeo4jAssociationQueries)this.getAssociationQueries(associationKey.getMetadata())).createRelationshipForEmbeddedAssociation(this.client, txId, associationKey, embeddedKey, relationshipProperties);
        }
    }

    private static boolean emptyNode(EntityKey entityKey) {
        for (Object value : entityKey.getColumnValues()) {
            if (value == null) continue;
            return false;
        }
        return true;
    }

    private Graph.Relationship findOrCreateRelationshipWithEntityNode(AssociationKey associationKey, AssociationContext associationContext, AssociationOperation action) {
        Tuple associationRow = action.getValue();
        EntityKey ownerKey = associationKey.getEntityKey();
        AssociatedEntityKeyMetadata associatedEntityKeyMetadata = associationContext.getAssociationTypeContext().getAssociatedEntityKeyMetadata();
        EntityKey targetKey = this.getEntityKey(associationRow, associatedEntityKeyMetadata);
        Object[] relationshipProperties = this.relationshipProperties(associationKey, associationRow);
        Long txId = this.transactionId(associationContext.getTransactionContext());
        return ((HttpNeo4jAssociationQueries)this.getAssociationQueries(associationKey.getMetadata())).createRelationship(this.client, txId, ownerKey.getColumnValues(), targetKey.getColumnValues(), relationshipProperties);
    }

    private Object[] relationshipProperties(AssociationKey associationKey, Tuple associationRow) {
        String[] indexColumns = associationKey.getMetadata().getRowKeyIndexColumnNames();
        Object[] properties = new Object[indexColumns.length];
        for (int i = 0; i < indexColumns.length; ++i) {
            String propertyName = indexColumns[i];
            properties[i] = associationRow.get(propertyName);
        }
        return properties;
    }

    public Association getAssociation(AssociationKey associationKey, AssociationContext associationContext) {
        EntityKey entityKey = associationKey.getEntityKey();
        Long transactionId = this.transactionId(associationContext.getTransactionContext());
        NodeWithEmbeddedNodes node = ((HttpNeo4jEntityQueries)this.getEntityQueries(entityKey.getMetadata(), associationContext.getTupleTypeContext())).findEntity(this.client, transactionId, entityKey.getColumnValues());
        if (node == null) {
            return null;
        }
        Map<RowKey, Tuple> tuples = this.createAssociationMap(associationKey, associationContext, entityKey, associationContext.getTransactionContext());
        return new Association((AssociationSnapshot)new RemoteNeo4jAssociationSnapshot(tuples));
    }

    private Map<RowKey, Tuple> createAssociationMap(AssociationKey associationKey, AssociationContext associationContext, EntityKey entityKey, TransactionContext transactionContext) {
        String relationshipType = associationContext.getAssociationTypeContext().getRoleOnMainSide();
        HashMap<RowKey, Tuple> tuples = new HashMap<RowKey, Tuple>();
        Long txId = this.transactionId(transactionContext);
        ClosableIterator<RemoteNeo4jAssociationPropertiesRow> relationships = ((HttpNeo4jEntityQueries)this.getEntityQueries(entityKey.getMetadata(), (OperationContext)associationContext)).findAssociation(this.client, txId, entityKey.getColumnValues(), relationshipType, associationKey.getMetadata());
        while (relationships.hasNext()) {
            RemoteNeo4jAssociationPropertiesRow row = (RemoteNeo4jAssociationPropertiesRow)relationships.next();
            AssociatedEntityKeyMetadata associatedEntityKeyMetadata = associationContext.getAssociationTypeContext().getAssociatedEntityKeyMetadata();
            RemoteNeo4jTupleAssociationSnapshot snapshot = new RemoteNeo4jTupleAssociationSnapshot(row, associationKey, associatedEntityKeyMetadata);
            RowKey rowKey = this.convert(associationKey, snapshot);
            tuples.put(rowKey, new Tuple((TupleSnapshot)snapshot, Tuple.SnapshotType.UPDATE));
        }
        return tuples;
    }

    private RowKey convert(AssociationKey associationKey, RemoteNeo4jTupleAssociationSnapshot snapshot) {
        String[] columnNames = associationKey.getMetadata().getRowKeyColumnNames();
        Object[] values = new Object[columnNames.length];
        for (int i = 0; i < columnNames.length; ++i) {
            values[i] = snapshot.get(columnNames[i]);
        }
        return new RowKey(columnNames, values);
    }

    public void insertOrUpdateAssociation(AssociationKey key, Association association, AssociationContext associationContext) {
        if (key.getMetadata().isInverse()) {
            return;
        }
        for (AssociationOperation action : association.getOperations()) {
            this.applyAssociationOperation(association, key, action, associationContext);
        }
    }

    public void removeAssociation(AssociationKey key, AssociationContext associationContext) {
        if (key.getMetadata().isInverse()) {
            return;
        }
        Long txId = this.transactionId(associationContext.getTransactionContext());
        ((HttpNeo4jAssociationQueries)this.getAssociationQueries(key.getMetadata())).removeAssociation(this.client, txId, key);
    }

    private void applyAssociationOperation(Association association, AssociationKey key, AssociationOperation operation, AssociationContext associationContext) {
        switch (operation.getType()) {
            case CLEAR: {
                this.removeAssociation(key, associationContext);
                break;
            }
            case PUT: {
                this.putAssociationOperation(key, operation, associationContext);
                break;
            }
            case REMOVE: {
                this.removeAssociationOperation(key, operation, associationContext);
            }
        }
    }

    private Object[] relationshipProperties(AssociationKey associationKey, AssociationOperation action) {
        Object[] relationshipProperties = new Object[associationKey.getMetadata().getRowKeyIndexColumnNames().length];
        String[] indexColumns = associationKey.getMetadata().getRowKeyIndexColumnNames();
        for (int i = 0; i < indexColumns.length; ++i) {
            relationshipProperties[i] = action.getValue().get(indexColumns[i]);
        }
        return relationshipProperties;
    }

    private void removeAssociationOperation(AssociationKey associationKey, AssociationOperation action, AssociationContext associationContext) {
        Long txId = this.transactionId(associationContext.getTransactionContext());
        ((HttpNeo4jAssociationQueries)this.getAssociationQueries(associationKey.getMetadata())).removeAssociationRow(this.client, txId, associationKey, action.getKey());
    }

    private void applyTupleOperations(EntityKey entityKey, Tuple tuple, Map<String, Object> node, Map<String, EntityKey> toOneAssociations, Statements statements, Set<TupleOperation> operations, TupleContext tupleContext, TransactionContext transactionContext) {
        HashSet<String> processedAssociationRoles = new HashSet<String>();
        for (TupleOperation operation : operations) {
            this.applyOperation(entityKey, tuple, node, toOneAssociations, statements, operation, tupleContext, transactionContext, processedAssociationRoles);
        }
    }

    private void applyOperation(EntityKey entityKey, Tuple tuple, Map<String, Object> node, Map<String, EntityKey> toOneAssociations, Statements statements, TupleOperation operation, TupleContext tupleContext, TransactionContext transactionContext, Set<String> processedAssociationRoles) {
        switch (operation.getType()) {
            case PUT: {
                this.putTupleOperation(entityKey, tuple, node, toOneAssociations, statements, operation, tupleContext, processedAssociationRoles);
                break;
            }
            case PUT_NULL: 
            case REMOVE: {
                this.removeTupleOperation(entityKey, node, operation, statements, tupleContext, transactionContext, processedAssociationRoles);
            }
        }
    }

    private void removeTupleOperation(EntityKey entityKey, Map<String, Object> ownerNode, TupleOperation operation, Statements statements, TupleContext tupleContext, TransactionContext transactionContext, Set<String> processedAssociationRoles) {
        if (!tupleContext.getTupleTypeContext().isPartOfAssociation(operation.getColumn())) {
            if (HttpNeo4jDialect.isPartOfRegularEmbedded(entityKey.getColumnNames(), operation.getColumn())) {
                Statement statement = ((HttpNeo4jEntityQueries)this.getEntityQueries(entityKey.getMetadata(), tupleContext.getTupleTypeContext())).removeEmbeddedColumnStatement(entityKey.getColumnValues(), operation.getColumn());
                statements.addStatement(statement);
            } else {
                Statement statement = ((HttpNeo4jEntityQueries)this.getEntityQueries(entityKey.getMetadata(), tupleContext.getTupleTypeContext())).removeColumnStatement(entityKey.getColumnValues(), operation.getColumn());
                statements.addStatement(statement);
            }
        } else {
            String associationRole = tupleContext.getTupleTypeContext().getRole(operation.getColumn());
            if (!processedAssociationRoles.contains(associationRole)) {
                Long txId = this.transactionId(transactionContext);
                ((HttpNeo4jEntityQueries)this.getEntityQueries(entityKey.getMetadata(), (OperationContext)tupleContext)).removeToOneAssociation(this.client, txId, entityKey.getColumnValues(), associationRole);
            }
        }
    }

    private void putTupleOperation(EntityKey entityKey, Tuple tuple, Map<String, Object> node, Map<String, EntityKey> toOneAssociations, Statements statements, TupleOperation operation, TupleContext tupleContext, Set<String> processedAssociationRoles) {
        if (tupleContext.getTupleTypeContext().isPartOfAssociation(operation.getColumn())) {
            this.putOneToOneAssociation(entityKey, tuple, node, toOneAssociations, operation, tupleContext, processedAssociationRoles);
        } else if (HttpNeo4jDialect.isPartOfRegularEmbedded(entityKey.getMetadata().getColumnNames(), operation.getColumn())) {
            Statement statement = ((HttpNeo4jEntityQueries)this.getEntityQueries(entityKey.getMetadata(), (OperationContext)tupleContext)).updateEmbeddedColumnStatement(entityKey.getColumnValues(), operation.getColumn(), operation.getValue());
            statements.addStatement(statement);
        } else {
            this.putProperty(entityKey, node, operation);
        }
    }

    private void putProperty(EntityKey entityKey, Map<String, Object> node, TupleOperation operation) {
        node.put(operation.getColumn(), operation.getValue());
    }

    private void putOneToOneAssociation(EntityKey ownerKey, Tuple tuple, Map<String, Object> node, Map<String, EntityKey> toOneAssociations, TupleOperation operation, TupleContext tupleContext, Set<String> processedAssociationRoles) {
        String associationRole = tupleContext.getTupleTypeContext().getRole(operation.getColumn());
        if (!processedAssociationRoles.contains(associationRole)) {
            processedAssociationRoles.add(associationRole);
            EntityKey targetKey = this.getEntityKey(tuple, tupleContext.getTupleTypeContext().getAssociatedEntityKeyMetadata(operation.getColumn()));
            toOneAssociations.put(associationRole, targetKey);
        }
    }

    public void forEachTuple(ModelConsumer consumer, TupleTypeContext tupleTypeContext, EntityKeyMetadata entityKeyMetadata) {
        HttpTuplesSupplier tupleSupplier = new HttpTuplesSupplier((HttpNeo4jEntityQueries)this.getEntityQueries(entityKeyMetadata, tupleTypeContext), entityKeyMetadata, tupleTypeContext, this.client);
        consumer.consume((TuplesSupplier)tupleSupplier);
    }

    public ClosableIterator<Tuple> executeBackendQuery(BackendQuery<String> backendQuery, QueryParameters queryParameters, TupleContext tupleContext) {
        Map<String, Object> parameters = this.getParameters(queryParameters);
        String nativeQuery = this.buildNativeQuery(backendQuery, queryParameters);
        Statement statement = new Statement(nativeQuery, parameters);
        Statements statements = new Statements();
        statements.addStatement(statement);
        Long txId = this.transactionId(tupleContext.getTransactionContext());
        StatementsResponse response = null;
        if (backendQuery.getSingleEntityMetadataInformationOrNull() != null) {
            response = this.client.executeQueriesInOpenTransaction(txId, statements);
            this.validate(response, nativeQuery);
            EntityKeyMetadata entityKeyMetadata = backendQuery.getSingleEntityMetadataInformationOrNull().getEntityKeyMetadata();
            HttpNeo4jEntityQueries queries = (HttpNeo4jEntityQueries)this.getEntityQueries(entityKeyMetadata, (OperationContext)tupleContext);
            List<StatementResult> results = response.getResults();
            List<Row> rows = results.get(0).getData();
            EntityKey[] keys = new EntityKey[rows.size()];
            for (int i = 0; i < rows.size(); ++i) {
                List<Graph.Node> nodes = rows.get(i).getGraph().getNodes();
                if (nodes.isEmpty()) {
                    throw log.addEntityNotAllowedInNativeQueriesUsingProjection(entityKeyMetadata.getTable(), (String)backendQuery.getQuery());
                }
                Graph.Node node = nodes.get(0);
                Object[] values = this.columnValues(node, entityKeyMetadata);
                keys[i] = new EntityKey(entityKeyMetadata, values);
            }
            ClosableIterator<NodeWithEmbeddedNodes> entities = ((HttpNeo4jEntityQueries)this.getEntityQueries(entityKeyMetadata, (OperationContext)tupleContext)).findEntities(this.client, keys, txId);
            return new HttpNeo4jNodesTupleIterator(this.client, txId, queries, entityKeyMetadata, tupleContext.getTupleTypeContext(), entities);
        }
        statement.setResultDataContents(Arrays.asList("row"));
        response = this.client.executeQueriesInOpenTransaction(txId, statements);
        this.validate(response, nativeQuery);
        return new HttpNeo4jMapsTupleIterator(response.getResults().get(0));
    }

    @Override
    public int executeBackendUpdateQuery(BackendQuery<String> query, QueryParameters queryParameters, TupleContext tupleContext) {
        Map<String, Object> parameters = this.getParameters(queryParameters);
        String nativeQuery = this.buildNativeQuery(query, queryParameters);
        Statement statement = new Statement(nativeQuery, parameters);
        statement.setResultDataContents(Arrays.asList("row"));
        Statements statements = new Statements();
        statements.addStatement(statement);
        Long txId = this.transactionId(tupleContext.getTransactionContext());
        StatementsResponse response = this.client.executeQueriesInOpenTransaction(txId, statements);
        this.validate(response, nativeQuery);
        return -1;
    }

    private void validate(StatementsResponse response, String nativeQuery) {
        if (!response.getErrors().isEmpty()) {
            ErrorResponse errorResponse = response.getErrors().get(0);
            throw log.nativeQueryException(errorResponse.getCode(), errorResponse.getMessage(), null);
        }
    }

    private Object[] columnValues(Graph.Node node, EntityKeyMetadata metadata) {
        Object[] values = new Object[metadata.getColumnNames().length];
        for (int i = 0; i < metadata.getColumnNames().length; ++i) {
            values[i] = node.getProperties().get(metadata.getColumnNames()[i]);
        }
        return values;
    }

    public Number nextValue(NextValueRequest request) {
        return this.sequenceGenerator.nextValue(request);
    }

    private static class HttpTuplesSupplier
    implements TuplesSupplier {
        private final HttpNeo4jEntityQueries entityQueries;
        private final EntityKeyMetadata entityKeyMetadata;
        private final TupleTypeContext tupleTypeContext;
        private final HttpNeo4jClient httpClient;

        public HttpTuplesSupplier(HttpNeo4jEntityQueries entityQueries, EntityKeyMetadata entityKeyMetadata, TupleTypeContext tupleTypeContext, HttpNeo4jClient httpClient) {
            this.entityQueries = entityQueries;
            this.entityKeyMetadata = entityKeyMetadata;
            this.tupleTypeContext = tupleTypeContext;
            this.httpClient = httpClient;
        }

        public ClosableIterator<Tuple> get(TransactionContext transactionContext) {
            Long txId = transactionContext == null ? null : (Long)transactionContext.getTransactionId();
            ClosableIterator<NodeWithEmbeddedNodes> entities = this.entityQueries.findEntitiesWithEmbedded(this.httpClient, txId);
            return new HttpNeo4jNodesTupleIterator(this.httpClient, txId, this.entityQueries, this.entityKeyMetadata, this.tupleTypeContext, entities);
        }
    }
}

