/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.neo4j.embedded.transaction.impl;

import java.lang.invoke.MethodHandles;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import org.hibernate.HibernateException;
import org.hibernate.TransactionException;
import org.hibernate.engine.transaction.spi.IsolationDelegate;
import org.hibernate.engine.transaction.spi.TransactionObserver;
import org.hibernate.jdbc.WorkExecutor;
import org.hibernate.jdbc.WorkExecutorVisitable;
import org.hibernate.ogm.datastore.neo4j.embedded.impl.EmbeddedNeo4jDatastoreProvider;
import org.hibernate.ogm.datastore.neo4j.logging.impl.Log;
import org.hibernate.ogm.datastore.neo4j.logging.impl.LoggerFactory;
import org.hibernate.resource.transaction.internal.SynchronizationRegistryStandardImpl;
import org.hibernate.resource.transaction.spi.SynchronizationRegistry;
import org.hibernate.resource.transaction.spi.TransactionCoordinator;
import org.hibernate.resource.transaction.spi.TransactionCoordinatorBuilder;
import org.hibernate.resource.transaction.spi.TransactionCoordinatorOwner;
import org.hibernate.resource.transaction.spi.TransactionStatus;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Transaction;

public class EmbeddedNeo4jResourceLocalTransactionCoordinator
implements TransactionCoordinator {
    private static final Log log = LoggerFactory.make(MethodHandles.lookup());
    private final TransactionCoordinatorBuilder transactionCoordinatorBuilder;
    private final TransactionCoordinatorOwner owner;
    private final SynchronizationRegistryStandardImpl synchronizationRegistry = new SynchronizationRegistryStandardImpl();
    private Neo4jTransactionDriver physicalTransactionDelegate;
    private int timeOut = -1;
    private final transient List<TransactionObserver> observers;
    private final EmbeddedNeo4jDatastoreProvider provider;

    EmbeddedNeo4jResourceLocalTransactionCoordinator(TransactionCoordinatorBuilder transactionCoordinatorBuilder, TransactionCoordinatorOwner owner, EmbeddedNeo4jDatastoreProvider provider) {
        this.provider = provider;
        this.observers = new ArrayList<TransactionObserver>();
        this.transactionCoordinatorBuilder = transactionCoordinatorBuilder;
        this.owner = owner;
    }

    public TransactionCoordinator.TransactionDriver getTransactionDriverControl() {
        if (this.physicalTransactionDelegate == null) {
            this.physicalTransactionDelegate = new Neo4jTransactionDriver(this.provider);
        }
        return this.physicalTransactionDelegate;
    }

    public void explicitJoin() {
        log.callingJoinTransactionOnNonJtaEntityManager();
    }

    public boolean isJoined() {
        return this.physicalTransactionDelegate != null && this.physicalTransactionDelegate.getStatus() == TransactionStatus.ACTIVE;
    }

    public void pulse() {
        this.getTransactionDriverControl();
    }

    public SynchronizationRegistry getLocalSynchronizations() {
        return this.synchronizationRegistry;
    }

    public boolean isActive() {
        return this.owner.isActive();
    }

    public IsolationDelegate createIsolationDelegate() {
        return new Neo4jIsolationDelegate(this.provider);
    }

    public TransactionCoordinatorBuilder getTransactionCoordinatorBuilder() {
        return this.transactionCoordinatorBuilder;
    }

    public void setTimeOut(int seconds) {
        this.timeOut = seconds;
    }

    public int getTimeOut() {
        return this.timeOut;
    }

    private void afterBeginCallback() {
        if (this.timeOut > 0) {
            this.owner.setTransactionTimeOut(this.timeOut);
        }
        this.owner.afterTransactionBegin();
        for (TransactionObserver observer : this.observers) {
            observer.afterBegin();
        }
        log.trace("ResourceLocalTransactionCoordinatorImpl#afterBeginCallback");
    }

    private void beforeCompletionCallback() {
        log.trace("ResourceLocalTransactionCoordinatorImpl#beforeCompletionCallback");
        try {
            this.owner.beforeTransactionCompletion();
            this.synchronizationRegistry.notifySynchronizationsBeforeTransactionCompletion();
            for (TransactionObserver observer : this.observers) {
                observer.beforeCompletion();
            }
        }
        catch (RuntimeException e) {
            if (this.physicalTransactionDelegate != null) {
                this.physicalTransactionDelegate.markRollbackOnly();
            }
            throw e;
        }
    }

    private void afterCompletionCallback(boolean successful) {
        log.tracef("ResourceLocalTransactionCoordinatorImpl#afterCompletionCallback(%s)", successful);
        int statusToSend = successful ? 3 : 5;
        this.synchronizationRegistry.notifySynchronizationsAfterTransactionCompletion(statusToSend);
        this.owner.afterTransactionCompletion(successful, false);
        for (TransactionObserver observer : this.observers) {
            observer.afterCompletion(successful, false);
        }
        this.invalidateDelegate();
    }

    private void invalidateDelegate() {
        if (this.physicalTransactionDelegate == null) {
            throw new IllegalStateException("Physical-transaction delegate not known on attempt to invalidate");
        }
        this.physicalTransactionDelegate.invalidate();
        this.physicalTransactionDelegate = null;
    }

    public void addObserver(TransactionObserver observer) {
        this.observers.add(observer);
    }

    public void removeObserver(TransactionObserver observer) {
        this.observers.remove(observer);
    }

    public class Neo4jTransactionDriver
    implements TransactionCoordinator.TransactionDriver {
        private final GraphDatabaseService graphDB;
        private TransactionStatus status;
        private Transaction tx;
        private boolean invalid;
        private boolean rollbackOnly = false;

        public Neo4jTransactionDriver(EmbeddedNeo4jDatastoreProvider provider) {
            this.graphDB = provider.getDatabase();
        }

        protected void invalidate() {
            this.invalid = true;
        }

        public void begin() {
            this.errorIfInvalid();
            this.tx = this.graphDB.beginTx();
            this.status = TransactionStatus.ACTIVE;
            EmbeddedNeo4jResourceLocalTransactionCoordinator.this.afterBeginCallback();
        }

        protected void errorIfInvalid() {
            if (this.invalid) {
                throw new IllegalStateException("Physical-transaction delegate is no longer valid");
            }
        }

        public void commit() {
            try {
                if (this.rollbackOnly) {
                    throw new TransactionException("Transaction was marked for rollback only; cannot commit");
                }
                EmbeddedNeo4jResourceLocalTransactionCoordinator.this.beforeCompletionCallback();
                this.tx.success();
                this.close();
                this.status = TransactionStatus.NOT_ACTIVE;
                EmbeddedNeo4jResourceLocalTransactionCoordinator.this.afterCompletionCallback(true);
            }
            catch (RuntimeException e) {
                try {
                    this.rollback();
                }
                catch (RuntimeException e2) {
                    log.unableToRollbackTransaction(e2);
                }
                throw e;
            }
        }

        private void close() {
            try {
                this.tx.close();
            }
            finally {
                this.tx = null;
            }
        }

        public void rollback() {
            if (this.rollbackOnly || this.getStatus() == TransactionStatus.ACTIVE) {
                this.rollbackOnly = false;
                this.tx.failure();
                this.status = TransactionStatus.NOT_ACTIVE;
                this.close();
                EmbeddedNeo4jResourceLocalTransactionCoordinator.this.afterCompletionCallback(false);
            }
        }

        public TransactionStatus getStatus() {
            return this.rollbackOnly ? TransactionStatus.MARKED_ROLLBACK : this.status;
        }

        public void markRollbackOnly() {
            if (log.isDebugEnabled()) {
                log.debug("Neo4j transaction marked for rollback-only (exception provided for stack trace)", new Exception("exception just for purpose of providing stack trace"));
            }
            this.rollbackOnly = true;
        }
    }

    private class Neo4jIsolationDelegate
    implements IsolationDelegate {
        private final EmbeddedNeo4jDatastoreProvider provider;

        public Neo4jIsolationDelegate(EmbeddedNeo4jDatastoreProvider provider) {
            this.provider = provider;
        }

        public <T> T delegateWork(WorkExecutorVisitable<T> work, boolean transacted) throws HibernateException {
            Transaction tx = null;
            try {
                if (!transacted) {
                    log.cannotExecuteWorkOutsideIsolatedTransaction();
                }
                GraphDatabaseService dataBase = this.provider.getDatabase();
                tx = dataBase.beginTx();
                Connection connection = null;
                Object result = work.accept(new WorkExecutor(), connection);
                tx.success();
                Object object = result;
                return (T)object;
            }
            catch (Exception e) {
                try {
                    tx.failure();
                }
                catch (Exception re) {
                    log.unableToRollbackTransaction(re);
                }
                if (e instanceof HibernateException) {
                    throw (HibernateException)e;
                }
                throw log.unableToPerformIsolatedWork(e);
            }
            finally {
                if (tx != null) {
                    tx.close();
                    tx = null;
                }
            }
        }

        public <T> T delegateCallable(Callable<T> callable, boolean transacted) throws HibernateException {
            throw new UnsupportedOperationException("Not implemented yet");
        }
    }
}

