/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.neo4j.embedded.transaction.impl;

import javax.transaction.Synchronization;
import org.hibernate.ogm.datastore.neo4j.embedded.impl.EmbeddedNeo4jDatastoreProvider;
import org.hibernate.ogm.datastore.neo4j.transaction.impl.BaseNeo4jJtaTransactionCoordinator;
import org.hibernate.ogm.datastore.neo4j.transaction.impl.Neo4jSynchronization;
import org.hibernate.ogm.transaction.impl.ForwardingTransactionCoordinator;
import org.hibernate.resource.transaction.TransactionCoordinator;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Transaction;

public class EmbeddedNeo4jJtaTransactionCoordinator
extends ForwardingTransactionCoordinator
implements BaseNeo4jJtaTransactionCoordinator {
    private final GraphDatabaseService graphDB;
    private Transaction tx;

    public EmbeddedNeo4jJtaTransactionCoordinator(TransactionCoordinator jtaDelegate, EmbeddedNeo4jDatastoreProvider graphDb) {
        super(jtaDelegate);
        this.graphDB = graphDb.getDatabase();
    }

    public void explicitJoin() {
        super.explicitJoin();
        this.join();
    }

    public void pulse() {
        super.pulse();
        this.join();
    }

    @Override
    public void join() {
        if (this.tx == null && this.isActive()) {
            this.beginTransaction();
            this.getLocalSynchronizations().registerSynchronization((Synchronization)new Neo4jSynchronization(this));
        }
    }

    @Override
    public void success() {
        if (this.tx != null) {
            this.tx.success();
            this.close();
        }
    }

    @Override
    public void failure() {
        if (this.tx != null) {
            this.tx.failure();
            this.close();
        }
    }

    private void close() {
        try {
            this.tx.close();
        }
        finally {
            this.tx = null;
        }
    }

    @Override
    public boolean isTransactionOpen() {
        return this.tx != null;
    }

    @Override
    public void beginTransaction() {
        this.tx = this.graphDB.beginTx();
    }

    @Override
    public Object getTransactionId() {
        return this.tx;
    }
}

