/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.neo4j.remote.bolt.transaction.impl;

import javax.transaction.Synchronization;
import org.hibernate.ogm.datastore.neo4j.remote.bolt.impl.BoltNeo4jDatastoreProvider;
import org.hibernate.ogm.datastore.neo4j.transaction.impl.BaseNeo4jJtaTransactionCoordinator;
import org.hibernate.ogm.datastore.neo4j.transaction.impl.Neo4jSynchronization;
import org.hibernate.ogm.datastore.neo4j.transaction.impl.RemoteTransactionDriver;
import org.hibernate.ogm.transaction.impl.ForwardingTransactionCoordinator;
import org.hibernate.resource.transaction.TransactionCoordinator;
import org.neo4j.driver.v1.Driver;
import org.neo4j.driver.v1.Session;
import org.neo4j.driver.v1.Transaction;

public class BoltNeo4jJtaTransactionCoordinator
extends ForwardingTransactionCoordinator
implements BaseNeo4jJtaTransactionCoordinator {
    private final Driver driver;
    private Transaction tx;
    private Session session;

    public BoltNeo4jJtaTransactionCoordinator(TransactionCoordinator delegate, BoltNeo4jDatastoreProvider provider) {
        super(delegate);
        this.driver = provider.getClient().getDriver();
    }

    public TransactionCoordinator.TransactionDriver getTransactionDriverControl() {
        return new RemoteTransactionDriver(this, super.getTransactionDriverControl());
    }

    public void explicitJoin() {
        super.explicitJoin();
        this.join();
    }

    public void pulse() {
        super.pulse();
        this.join();
    }

    @Override
    public void join() {
        if (this.tx == null && this.delegate.isActive() && this.delegate.getTransactionCoordinatorBuilder().isJta()) {
            this.beginTransaction();
            this.delegate.getLocalSynchronizations().registerSynchronization((Synchronization)new Neo4jSynchronization(this));
        }
    }

    @Override
    public void beginTransaction() {
        if (this.session == null) {
            this.session = this.driver.session();
        }
        if (this.tx == null) {
            this.tx = this.session.beginTransaction();
        }
    }

    @Override
    public void success() {
        if (this.tx != null) {
            try {
                this.tx.success();
                this.tx.close();
            }
            finally {
                this.tx = null;
                this.closeSession();
            }
        }
    }

    @Override
    public void failure() {
        if (this.tx != null) {
            try {
                this.tx.failure();
                this.tx.close();
            }
            finally {
                this.tx = null;
                this.closeSession();
            }
        }
    }

    private void closeSession() {
        try {
            this.session.close();
        }
        finally {
            this.session = null;
        }
    }

    @Override
    public boolean isTransactionOpen() {
        return this.tx != null;
    }

    @Override
    public Object getTransactionId() {
        return this.tx;
    }
}

