/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.neo4j.query.parsing.impl;

import java.util.Collections;
import java.util.Map;
import org.hibernate.SessionFactory;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.hql.QueryParser;
import org.hibernate.hql.ast.spi.AstProcessingChain;
import org.hibernate.hql.ast.spi.EntityNamesResolver;
import org.hibernate.ogm.datastore.neo4j.query.parsing.impl.Neo4jProcessingChain;
import org.hibernate.ogm.datastore.neo4j.query.parsing.impl.Neo4jQueryParsingResult;
import org.hibernate.ogm.query.spi.BaseQueryParserService;
import org.hibernate.ogm.query.spi.QueryParsingResult;
import org.hibernate.ogm.service.impl.SessionFactoryEntityNamesResolver;
import org.hibernate.ogm.util.impl.Log;
import org.hibernate.ogm.util.impl.LoggerFactory;

public class Neo4jBasedQueryParserService
extends BaseQueryParserService {
    private static final Log log = LoggerFactory.make();
    private volatile SessionFactoryEntityNamesResolver entityNamesResolver;

    public QueryParsingResult parseQuery(SessionFactoryImplementor sessionFactory, String queryString, Map<String, Object> namedParameters) {
        throw new UnsupportedOperationException("The Neo4j query parser supports parameterized queries");
    }

    public QueryParsingResult parseQuery(SessionFactoryImplementor sessionFactory, String queryString) {
        QueryParser queryParser = new QueryParser();
        Neo4jProcessingChain processingChain = this.createProcessingChain(sessionFactory);
        Neo4jQueryParsingResult result = (Neo4jQueryParsingResult)queryParser.parseQuery(queryString, (AstProcessingChain)processingChain);
        log.createdQuery(queryString, (Object)result);
        return result;
    }

    public boolean supportsParameters() {
        return true;
    }

    private Neo4jProcessingChain createProcessingChain(SessionFactoryImplementor sessionFactory) {
        EntityNamesResolver entityNamesResolver = this.getDefinedEntityNames((SessionFactory)sessionFactory);
        return new Neo4jProcessingChain(sessionFactory, entityNamesResolver, Collections.emptyMap());
    }

    private EntityNamesResolver getDefinedEntityNames(SessionFactory sessionFactory) {
        if (this.entityNamesResolver == null) {
            this.entityNamesResolver = new SessionFactoryEntityNamesResolver(sessionFactory);
        }
        return this.entityNamesResolver;
    }
}

