/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.neo4j.remote.http.dialect.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.hibernate.ogm.datastore.neo4j.remote.http.json.impl.Graph;

public class NodeWithEmbeddedNodes {
    private static final Map<String, Collection<Graph.Node>> EMPTY_MAP = Collections.emptyMap();
    private final Graph.Node owner;
    private final Map<String, Collection<Graph.Node>> embeddedNodes;

    public NodeWithEmbeddedNodes(Graph.Node owner) {
        this(owner, EMPTY_MAP);
    }

    public NodeWithEmbeddedNodes(Graph.Node owner, Map<String, Collection<Graph.Node>> embeddedNodes) {
        this.owner = owner;
        this.embeddedNodes = embeddedNodes == null ? EMPTY_MAP : Collections.unmodifiableMap(embeddedNodes);
    }

    public Graph.Node getOwner() {
        return this.owner;
    }

    public Map<String, Collection<Graph.Node>> getEmbeddedNodes() {
        return this.embeddedNodes;
    }
}

