/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.neo4j.remote.http.impl;

import java.net.URI;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.core.Response;
import org.hibernate.ogm.datastore.neo4j.logging.impl.Log;
import org.hibernate.ogm.datastore.neo4j.logging.impl.LoggerFactory;
import org.hibernate.ogm.datastore.neo4j.remote.common.impl.RemoteNeo4jConfiguration;
import org.hibernate.ogm.datastore.neo4j.remote.common.impl.RemoteNeo4jDatabaseIdentifier;
import org.hibernate.ogm.datastore.neo4j.remote.http.json.impl.Statements;
import org.hibernate.ogm.datastore.neo4j.remote.http.json.impl.StatementsResponse;
import org.hibernate.ogm.datastore.neo4j.remote.http.request.impl.HttpNeo4jAuthenticationFacade;
import org.hibernate.ogm.datastore.neo4j.remote.http.request.impl.HttpNeo4jTransactionFacade;
import org.hibernate.ogm.datastore.neo4j.remote.http.request.impl.XStreamRequestHeaderFilter;
import org.hibernate.ogm.datastore.neo4j.remote.http.transaction.impl.HttpNeo4jTransaction;
import org.jboss.resteasy.client.jaxrs.BasicAuthentication;
import org.jboss.resteasy.client.jaxrs.ResteasyClient;
import org.jboss.resteasy.client.jaxrs.ResteasyClientBuilder;

public class HttpNeo4jClient
implements AutoCloseable {
    private static final int OK_STATUS_CODE = Response.Status.OK.getStatusCode();
    private static final Log log = LoggerFactory.getLogger();
    private static final int CONNECTION_POOL_SIZE = 10;
    private final ResteasyClient client;
    private final HttpNeo4jAuthenticationFacade authenticationClient;
    private final HttpNeo4jTransactionFacade neo4jFacade;
    private final RemoteNeo4jDatabaseIdentifier database;

    public HttpNeo4jClient(RemoteNeo4jDatabaseIdentifier database, RemoteNeo4jConfiguration configuration) {
        this.database = database;
        this.client = HttpNeo4jClient.createRestClient(database, configuration);
        this.authenticationClient = (HttpNeo4jAuthenticationFacade)this.client.target(database.getServerUri()).proxy(HttpNeo4jAuthenticationFacade.class);
        this.neo4jFacade = (HttpNeo4jTransactionFacade)this.client.target(database.getDatabaseUri()).proxy(HttpNeo4jTransactionFacade.class);
    }

    private static ResteasyClient createRestClient(RemoteNeo4jDatabaseIdentifier database, RemoteNeo4jConfiguration configuration) {
        ResteasyClientBuilder clientBuilder = new ResteasyClientBuilder();
        if (database.getUserName() != null) {
            clientBuilder.register((Object)new BasicAuthentication(database.getUserName(), database.getPassword()));
        }
        if (configuration.getConnectionCheckoutTimeout() != null) {
            clientBuilder.connectionCheckoutTimeout(configuration.getConnectionCheckoutTimeout().longValue(), TimeUnit.MILLISECONDS);
        }
        if (configuration.getEstablishConnectionTimeout() != null) {
            clientBuilder.establishConnectionTimeout(configuration.getEstablishConnectionTimeout().longValue(), TimeUnit.MILLISECONDS);
        }
        if (configuration.getConnectionTTL() != null) {
            clientBuilder.connectionTTL(configuration.getConnectionTTL().longValue(), TimeUnit.MILLISECONDS);
        }
        if (configuration.getSocketTimeout() != null) {
            clientBuilder.socketTimeout(configuration.getSocketTimeout().longValue(), TimeUnit.MILLISECONDS);
        }
        clientBuilder.register((Object)XStreamRequestHeaderFilter.INSTANCE);
        return clientBuilder.connectionPoolSize(10).build();
    }

    public void validateConnection() {
        Response response = this.authenticationClient.authenticate(this.database.getUserName());
        if (response.getStatus() != OK_STATUS_CODE) {
            throw log.connectionFailed(String.valueOf(this.database.getHost()), String.valueOf(response.getStatus()), response.getStatusInfo().getReasonPhrase());
        }
    }

    @Override
    public void close() {
        this.client.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StatementsResponse executeQueriesInOpenTransaction(Long txId, Statements statements) {
        try (Response executeQuery = this.neo4jFacade.executeQuery(txId, statements);){
            StatementsResponse statementsResponse = (StatementsResponse)executeQuery.readEntity(StatementsResponse.class);
            return statementsResponse;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StatementsResponse executeQueriesInNewTransaction(Statements statements) {
        try (Response response = this.neo4jFacade.executeQuery(statements);){
            StatementsResponse statementsResponse = (StatementsResponse)response.readEntity(StatementsResponse.class);
            return statementsResponse;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpNeo4jTransaction beginTx() {
        try (Response response = this.neo4jFacade.beginTransaction();){
            HttpNeo4jTransaction transaction;
            Long txId = this.transactionId(response.getLocation());
            HttpNeo4jTransaction httpNeo4jTransaction = transaction = new HttpNeo4jTransaction(this, txId);
            return httpNeo4jTransaction;
        }
    }

    private Long transactionId(URI location) {
        return Long.valueOf(location.getPath().substring(location.getPath().lastIndexOf("/") + 1));
    }

    public void commit(Long txId) {
        Response response = this.neo4jFacade.commit(txId);
        response.close();
    }

    public void rollback(Long txId) {
        Response response = this.neo4jFacade.rollback(txId);
        response.close();
    }
}

