/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.neo4j;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.AssertionFailure;
import org.hibernate.HibernateException;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.ogm.datastore.neo4j.BaseNeo4jDialect;
import org.hibernate.ogm.datastore.neo4j.RemoteNeo4jDialect;
import org.hibernate.ogm.datastore.neo4j.logging.impl.Log;
import org.hibernate.ogm.datastore.neo4j.logging.impl.LoggerFactory;
import org.hibernate.ogm.datastore.neo4j.remote.bolt.dialect.impl.BoltNeo4jAssociatedNodesHelper;
import org.hibernate.ogm.datastore.neo4j.remote.bolt.dialect.impl.BoltNeo4jAssociationQueries;
import org.hibernate.ogm.datastore.neo4j.remote.bolt.dialect.impl.BoltNeo4jEntityQueries;
import org.hibernate.ogm.datastore.neo4j.remote.bolt.dialect.impl.BoltNeo4jMapsTupleIterator;
import org.hibernate.ogm.datastore.neo4j.remote.bolt.dialect.impl.BoltNeo4jNodesTupleIterator;
import org.hibernate.ogm.datastore.neo4j.remote.bolt.dialect.impl.BoltNeo4jSequenceGenerator;
import org.hibernate.ogm.datastore.neo4j.remote.bolt.dialect.impl.BoltNeo4jTupleAssociationSnapshot;
import org.hibernate.ogm.datastore.neo4j.remote.bolt.dialect.impl.BoltNeo4jTupleSnapshot;
import org.hibernate.ogm.datastore.neo4j.remote.bolt.dialect.impl.BoltNeo4jTypeConverter;
import org.hibernate.ogm.datastore.neo4j.remote.bolt.dialect.impl.NodeWithEmbeddedNodes;
import org.hibernate.ogm.datastore.neo4j.remote.bolt.impl.BoltNeo4jClient;
import org.hibernate.ogm.datastore.neo4j.remote.bolt.impl.BoltNeo4jDatastoreProvider;
import org.hibernate.ogm.datastore.neo4j.remote.common.dialect.impl.RemoteNeo4jAssociationPropertiesRow;
import org.hibernate.ogm.datastore.neo4j.remote.common.dialect.impl.RemoteNeo4jAssociationSnapshot;
import org.hibernate.ogm.datastore.neo4j.remote.common.util.impl.RemoteNeo4jHelper;
import org.hibernate.ogm.datastore.spi.DatastoreProvider;
import org.hibernate.ogm.dialect.query.spi.BackendQuery;
import org.hibernate.ogm.dialect.query.spi.ClosableIterator;
import org.hibernate.ogm.dialect.query.spi.QueryParameters;
import org.hibernate.ogm.dialect.spi.AssociationContext;
import org.hibernate.ogm.dialect.spi.ModelConsumer;
import org.hibernate.ogm.dialect.spi.NextValueRequest;
import org.hibernate.ogm.dialect.spi.OperationContext;
import org.hibernate.ogm.dialect.spi.TransactionContext;
import org.hibernate.ogm.dialect.spi.TupleAlreadyExistsException;
import org.hibernate.ogm.dialect.spi.TupleContext;
import org.hibernate.ogm.dialect.spi.TupleTypeContext;
import org.hibernate.ogm.dialect.spi.TuplesSupplier;
import org.hibernate.ogm.entityentry.impl.TuplePointer;
import org.hibernate.ogm.model.key.spi.AssociatedEntityKeyMetadata;
import org.hibernate.ogm.model.key.spi.AssociationKey;
import org.hibernate.ogm.model.key.spi.AssociationKeyMetadata;
import org.hibernate.ogm.model.key.spi.EntityKey;
import org.hibernate.ogm.model.key.spi.EntityKeyMetadata;
import org.hibernate.ogm.model.key.spi.RowKey;
import org.hibernate.ogm.model.spi.Association;
import org.hibernate.ogm.model.spi.AssociationOperation;
import org.hibernate.ogm.model.spi.AssociationSnapshot;
import org.hibernate.ogm.model.spi.Tuple;
import org.hibernate.ogm.model.spi.TupleOperation;
import org.hibernate.ogm.model.spi.TupleSnapshot;
import org.hibernate.ogm.persister.impl.OgmCollectionPersister;
import org.hibernate.ogm.persister.impl.OgmEntityPersister;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.entity.EntityPersister;
import org.neo4j.driver.v1.Record;
import org.neo4j.driver.v1.Session;
import org.neo4j.driver.v1.Statement;
import org.neo4j.driver.v1.StatementResult;
import org.neo4j.driver.v1.Transaction;
import org.neo4j.driver.v1.exceptions.ClientException;
import org.neo4j.driver.v1.summary.ResultSummary;
import org.neo4j.driver.v1.types.Node;
import org.neo4j.driver.v1.types.Relationship;

public class BoltNeo4jDialect
extends BaseNeo4jDialect
implements RemoteNeo4jDialect {
    public static final Log log = LoggerFactory.getLogger();
    private final BoltNeo4jSequenceGenerator sequenceGenerator;
    private Map<EntityKeyMetadata, BoltNeo4jEntityQueries> entitiesQueries;
    private Map<AssociationKeyMetadata, BoltNeo4jAssociationQueries> associationQueries;

    public BoltNeo4jDialect(BoltNeo4jDatastoreProvider provider) {
        super(BoltNeo4jTypeConverter.INSTANCE);
        this.sequenceGenerator = provider.getSequenceGenerator();
    }

    public void sessionFactoryCreated(SessionFactoryImplementor sessionFactoryImplementor) {
        this.associationQueries = Collections.unmodifiableMap(this.initializeAssociationQueries(sessionFactoryImplementor));
        this.entitiesQueries = Collections.unmodifiableMap(this.initializeEntityQueries(sessionFactoryImplementor, this.associationQueries));
    }

    private Map<EntityKeyMetadata, BoltNeo4jEntityQueries> initializeEntityQueries(SessionFactoryImplementor sessionFactoryImplementor, Map<AssociationKeyMetadata, BoltNeo4jAssociationQueries> associationQueries) {
        Map<EntityKeyMetadata, BoltNeo4jEntityQueries> entityQueries = this.initializeEntityQueries(sessionFactoryImplementor);
        for (AssociationKeyMetadata associationKeyMetadata : associationQueries.keySet()) {
            EntityKeyMetadata entityKeyMetadata = associationKeyMetadata.getAssociatedEntityKeyMetadata().getEntityKeyMetadata();
            if (entityQueries.containsKey(entityKeyMetadata)) continue;
            entityQueries.put(entityKeyMetadata, new BoltNeo4jEntityQueries(entityKeyMetadata, null));
        }
        return entityQueries;
    }

    private Map<EntityKeyMetadata, BoltNeo4jEntityQueries> initializeEntityQueries(SessionFactoryImplementor sessionFactoryImplementor) {
        HashMap<EntityKeyMetadata, BoltNeo4jEntityQueries> queryMap = new HashMap<EntityKeyMetadata, BoltNeo4jEntityQueries>();
        Collection entityPersisters = sessionFactoryImplementor.getEntityPersisters().values();
        for (EntityPersister entityPersister : entityPersisters) {
            if (!(entityPersister instanceof OgmEntityPersister)) continue;
            OgmEntityPersister ogmEntityPersister = (OgmEntityPersister)entityPersister;
            queryMap.put(ogmEntityPersister.getEntityKeyMetadata(), new BoltNeo4jEntityQueries(ogmEntityPersister.getEntityKeyMetadata(), ogmEntityPersister.getTupleTypeContext()));
        }
        return queryMap;
    }

    private Map<AssociationKeyMetadata, BoltNeo4jAssociationQueries> initializeAssociationQueries(SessionFactoryImplementor sessionFactoryImplementor) {
        HashMap<AssociationKeyMetadata, BoltNeo4jAssociationQueries> queryMap = new HashMap<AssociationKeyMetadata, BoltNeo4jAssociationQueries>();
        Collection collectionPersisters = sessionFactoryImplementor.getCollectionPersisters().values();
        for (CollectionPersister collectionPersister : collectionPersisters) {
            if (!(collectionPersister instanceof OgmCollectionPersister)) continue;
            OgmCollectionPersister ogmCollectionPersister = (OgmCollectionPersister)collectionPersister;
            EntityKeyMetadata ownerEntityKeyMetadata = ogmCollectionPersister.getOwnerEntityPersister().getEntityKeyMetadata();
            AssociationKeyMetadata associationKeyMetadata = ogmCollectionPersister.getAssociationKeyMetadata();
            queryMap.put(associationKeyMetadata, new BoltNeo4jAssociationQueries(ownerEntityKeyMetadata, associationKeyMetadata));
        }
        return queryMap;
    }

    public ClosableIterator<Tuple> executeBackendQuery(BackendQuery<String> backendQuery, QueryParameters queryParameters, TupleContext tupleContext) {
        Map<String, Object> parameters = this.getParameters(queryParameters);
        String nativeQuery = this.buildNativeQuery(backendQuery, queryParameters);
        Statement statement = new Statement(nativeQuery, parameters);
        if (backendQuery.getSingleEntityMetadataInformationOrNull() != null) {
            EntityKeyMetadata entityKeyMetadata = backendQuery.getSingleEntityMetadataInformationOrNull().getEntityKeyMetadata();
            BoltNeo4jEntityQueries queries = this.entitiesQueries.get(entityKeyMetadata);
            Transaction transaction = this.transaction((OperationContext)tupleContext);
            StatementResult result = transaction.run(statement);
            this.validateNativeQuery(result);
            ArrayList<EntityKey> entityKeys = new ArrayList<EntityKey>();
            while (result.hasNext()) {
                Record record = result.next();
                Map recordAsMap = record.get(0).asMap();
                Object[] columnValues = this.columnValues(recordAsMap, entityKeyMetadata);
                entityKeys.add(new EntityKey(entityKeyMetadata, columnValues));
            }
            EntityKey[] keys = entityKeys.toArray(new EntityKey[entityKeys.size()]);
            ClosableIterator<NodeWithEmbeddedNodes> entities = this.entitiesQueries.get(entityKeyMetadata).findEntities(keys, transaction);
            return new BoltNeo4jNodesTupleIterator(transaction, queries, entityKeyMetadata, tupleContext.getTupleTypeContext(), entities);
        }
        Transaction transaction = this.transaction((OperationContext)tupleContext);
        StatementResult statementResult = transaction.run(statement);
        this.validateNativeQuery(statementResult);
        return new BoltNeo4jMapsTupleIterator(statementResult);
    }

    @Override
    public int executeBackendUpdateQuery(BackendQuery<String> query, QueryParameters queryParameters, TupleContext tupleContext) {
        Map<String, Object> parameters = this.getParameters(queryParameters);
        String nativeQuery = this.buildNativeQuery(query, queryParameters);
        Statement statement = new Statement(nativeQuery, parameters);
        Transaction transaction = this.transaction((OperationContext)tupleContext);
        StatementResult statementResult = transaction.run(statement);
        this.validateNativeQuery(statementResult);
        ResultSummary summary = statementResult.consume();
        return this.updatesCount(summary);
    }

    private void validateNativeQuery(StatementResult result) {
        try {
            result.hasNext();
        }
        catch (ClientException e) {
            throw log.nativeQueryException(e.neo4jErrorCode(), e.getMessage(), null);
        }
    }

    private int updatesCount(ResultSummary summary) {
        int updates = 0;
        if (summary.counters().containsUpdates()) {
            updates += summary.counters().constraintsAdded();
            updates += summary.counters().constraintsRemoved();
            updates += summary.counters().nodesCreated();
            updates += summary.counters().nodesDeleted();
            updates += summary.counters().relationshipsCreated();
            updates += summary.counters().relationshipsDeleted();
            updates += summary.counters().labelsAdded();
            updates += summary.counters().labelsRemoved();
            updates += summary.counters().indexesAdded();
            updates += summary.counters().indexesRemoved();
            updates += summary.counters().propertiesSet();
        }
        return updates;
    }

    private Transaction transaction(OperationContext operationContext) {
        return (Transaction)operationContext.getTransactionContext().getTransactionId();
    }

    private Transaction transaction(AssociationContext associationContext) {
        return (Transaction)associationContext.getTransactionContext().getTransactionId();
    }

    private Object[] columnValues(Map<String, Object> node, EntityKeyMetadata metadata) {
        Object[] values = new Object[metadata.getColumnNames().length];
        for (int i = 0; i < metadata.getColumnNames().length; ++i) {
            values[i] = node.get(metadata.getColumnNames()[i]);
        }
        return values;
    }

    public Tuple getTuple(EntityKey key, OperationContext operationContext) {
        Transaction tx = this.transaction(operationContext);
        BoltNeo4jEntityQueries queries = this.entitiesQueries.get(key.getMetadata());
        NodeWithEmbeddedNodes owner = queries.findEntity(tx, key.getColumnValues());
        if (owner == null) {
            return null;
        }
        Map<String, Node> toOneEntities = BoltNeo4jAssociatedNodesHelper.findAssociatedNodes(tx, owner, key.getMetadata(), operationContext.getTupleTypeContext(), queries);
        return new Tuple((TupleSnapshot)new BoltNeo4jTupleSnapshot(owner, key.getMetadata(), toOneEntities, operationContext.getTupleTypeContext()), Tuple.SnapshotType.UPDATE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Tuple> getTuples(EntityKey[] keys, TupleContext tupleContext) {
        if (keys.length == 0) {
            return Collections.emptyList();
        }
        EntityKeyMetadata metadata = keys[0].getMetadata();
        try (ClosableIterator<NodeWithEmbeddedNodes> nodes = this.entitiesQueries.get(metadata).findEntities(keys, this.transaction((OperationContext)tupleContext));){
            List<Tuple> list = this.tuplesResult(keys, tupleContext, nodes);
            return list;
        }
    }

    private List<Tuple> tuplesResult(EntityKey[] keys, TupleContext tupleContext, ClosableIterator<NodeWithEmbeddedNodes> nodes) {
        Tuple[] tuples = new Tuple[keys.length];
        Transaction tx = this.transaction((OperationContext)tupleContext);
        block0: while (nodes.hasNext()) {
            NodeWithEmbeddedNodes node = (NodeWithEmbeddedNodes)nodes.next();
            for (int i = 0; i < keys.length; ++i) {
                if (!RemoteNeo4jHelper.matches(node.getOwner().asMap(), keys[i].getColumnNames(), keys[i].getColumnValues())) continue;
                EntityKeyMetadata metadata = keys[i].getMetadata();
                EntityKey key = keys[i];
                BoltNeo4jEntityQueries entityQueries = this.entitiesQueries.get(key.getMetadata());
                Map<String, Node> toOneEntities = BoltNeo4jAssociatedNodesHelper.findAssociatedNodes(tx, node, metadata, tupleContext.getTupleTypeContext(), entityQueries);
                tuples[i] = new Tuple((TupleSnapshot)new BoltNeo4jTupleSnapshot(node, metadata, toOneEntities, tupleContext.getTupleTypeContext()), Tuple.SnapshotType.UPDATE);
                continue block0;
            }
        }
        return Arrays.asList(tuples);
    }

    public void insertOrUpdateTuple(EntityKey key, TuplePointer tuplePointer, TupleContext tupleContext) throws TupleAlreadyExistsException {
        Tuple tuple = tuplePointer.getTuple();
        HashMap<String, EntityKey> toOneAssociations = new HashMap<String, EntityKey>();
        HashMap<String, Object> properties = new HashMap<String, Object>();
        ArrayList<Statement> statements = new ArrayList<Statement>();
        this.applyTupleOperations(key, tuple, properties, toOneAssociations, statements, tuple.getOperations(), tupleContext, tupleContext.getTransactionContext());
        if (Tuple.SnapshotType.INSERT.equals((Object)tuple.getSnapshotType())) {
            Statement statement = this.entitiesQueries.get(key.getMetadata()).getCreateEntityWithPropertiesQueryStatement(key.getColumnValues(), properties);
            statements.add(0, statement);
        } else {
            this.updateTuple(key, statements, properties);
        }
        this.saveToOneAssociations(statements, key, toOneAssociations);
        try {
            this.runAll(this.transaction((OperationContext)tupleContext), statements);
            tuple.setSnapshotType(Tuple.SnapshotType.UPDATE);
        }
        catch (ClientException e) {
            switch (e.neo4jErrorCode()) {
                case "Neo.ClientError.Schema.ConstraintValidationFailed": {
                    throw this.extractException(key, e);
                }
            }
            throw new HibernateException(e.getMessage());
        }
    }

    private void runAll(Transaction tx, List<Statement> statements) {
        for (Statement statement : statements) {
            StatementResult result = tx.run(statement);
            this.validate(result);
        }
    }

    private void validate(StatementResult result) {
        result.hasNext();
    }

    private HibernateException extractException(EntityKey key, ClientException exception) {
        if (exception.getMessage().matches(".*Node \\d+ already exists with label.*")) {
            return new TupleAlreadyExistsException(key, exception.getMessage());
        }
        return log.constraintViolation(key, exception.getMessage(), null);
    }

    private void updateTuple(EntityKey key, List<Statement> statements, Map<String, Object> properties) {
        if (!properties.isEmpty()) {
            Statement statement = this.entitiesQueries.get(key.getMetadata()).getUpdateEntityPropertiesStatement(key.getColumnValues(), properties);
            statements.add(statement);
        }
    }

    private void applyTupleOperations(EntityKey entityKey, Tuple tuple, Map<String, Object> node, Map<String, EntityKey> toOneAssociations, List<Statement> statements, Set<TupleOperation> operations, TupleContext tupleContext, TransactionContext transactionContext) {
        HashSet<String> processedAssociationRoles = new HashSet<String>();
        for (TupleOperation operation : operations) {
            this.applyOperation(entityKey, tuple, node, toOneAssociations, statements, operation, tupleContext, transactionContext, processedAssociationRoles);
        }
    }

    private void applyOperation(EntityKey entityKey, Tuple tuple, Map<String, Object> node, Map<String, EntityKey> toOneAssociations, List<Statement> statements, TupleOperation operation, TupleContext tupleContext, TransactionContext transactionContext, Set<String> processedAssociationRoles) {
        switch (operation.getType()) {
            case PUT: {
                this.putTupleOperation(entityKey, tuple, node, toOneAssociations, statements, operation, tupleContext, processedAssociationRoles);
                break;
            }
            case PUT_NULL: 
            case REMOVE: {
                this.removeTupleOperation(entityKey, node, operation, statements, tupleContext, transactionContext, processedAssociationRoles);
            }
        }
    }

    private void saveToOneAssociations(List<Statement> statements, EntityKey key, Map<String, EntityKey> toOneAssociations) {
        for (Map.Entry<String, EntityKey> entry : toOneAssociations.entrySet()) {
            Statement statement = this.entitiesQueries.get(key.getMetadata()).getUpdateOneToOneAssociationStatement(entry.getKey(), key.getColumnValues(), entry.getValue().getColumnValues());
            statements.add(statement);
        }
    }

    private void removeTupleOperation(EntityKey entityKey, Map<String, Object> ownerNode, TupleOperation operation, List<Statement> statements, TupleContext tupleContext, TransactionContext transactionContext, Set<String> processedAssociationRoles) {
        if (!tupleContext.getTupleTypeContext().isPartOfAssociation(operation.getColumn())) {
            if (BoltNeo4jDialect.isPartOfRegularEmbedded(entityKey.getColumnNames(), operation.getColumn())) {
                Statement statement = this.entitiesQueries.get(entityKey.getMetadata()).removeEmbeddedColumnStatement(entityKey.getColumnValues(), operation.getColumn(), this.transaction((OperationContext)tupleContext));
                statements.add(statement);
            } else {
                Statement statement = this.entitiesQueries.get(entityKey.getMetadata()).removeColumnStatement(entityKey.getColumnValues(), operation.getColumn(), this.transaction((OperationContext)tupleContext));
                statements.add(statement);
            }
        } else {
            String associationRole = tupleContext.getTupleTypeContext().getRole(operation.getColumn());
            if (!processedAssociationRoles.contains(associationRole)) {
                Transaction tx = (Transaction)transactionContext.getTransactionId();
                this.entitiesQueries.get(entityKey.getMetadata()).removeToOneAssociation(tx, entityKey.getColumnValues(), associationRole);
            }
        }
    }

    private void putTupleOperation(EntityKey entityKey, Tuple tuple, Map<String, Object> node, Map<String, EntityKey> toOneAssociations, List<Statement> statements, TupleOperation operation, TupleContext tupleContext, Set<String> processedAssociationRoles) {
        if (tupleContext.getTupleTypeContext().isPartOfAssociation(operation.getColumn())) {
            this.putOneToOneAssociation(entityKey, tuple, node, toOneAssociations, operation, tupleContext, processedAssociationRoles);
        } else if (BoltNeo4jDialect.isPartOfRegularEmbedded(entityKey.getMetadata().getColumnNames(), operation.getColumn())) {
            Statement statement = this.entitiesQueries.get(entityKey.getMetadata()).updateEmbeddedColumnStatement(entityKey.getColumnValues(), operation.getColumn(), operation.getValue());
            statements.add(statement);
        } else {
            this.putProperty(entityKey, node, operation);
        }
    }

    private void putOneToOneAssociation(EntityKey ownerKey, Tuple tuple, Map<String, Object> node, Map<String, EntityKey> toOneAssociations, TupleOperation operation, TupleContext tupleContext, Set<String> processedAssociationRoles) {
        String associationRole = tupleContext.getTupleTypeContext().getRole(operation.getColumn());
        if (!processedAssociationRoles.contains(associationRole)) {
            processedAssociationRoles.add(associationRole);
            EntityKey targetKey = this.getEntityKey(tuple, tupleContext.getTupleTypeContext().getAssociatedEntityKeyMetadata(operation.getColumn()));
            toOneAssociations.put(associationRole, targetKey);
        }
    }

    private void putProperty(EntityKey entityKey, Map<String, Object> node, TupleOperation operation) {
        node.put(operation.getColumn(), operation.getValue());
    }

    public void removeTuple(EntityKey key, TupleContext tupleContext) {
        this.entitiesQueries.get(key.getMetadata()).removeEntity(this.transaction((OperationContext)tupleContext), key.getColumnValues());
    }

    public Association getAssociation(AssociationKey associationKey, AssociationContext associationContext) {
        EntityKey entityKey = associationKey.getEntityKey();
        Transaction tx = this.transaction(associationContext);
        NodeWithEmbeddedNodes node = this.entitiesQueries.get(entityKey.getMetadata()).findEntity(tx, entityKey.getColumnValues());
        if (node == null) {
            return null;
        }
        Map<RowKey, Tuple> tuples = this.createAssociationMap(associationKey, associationContext, entityKey);
        return new Association((AssociationSnapshot)new RemoteNeo4jAssociationSnapshot(tuples));
    }

    private Map<RowKey, Tuple> createAssociationMap(AssociationKey associationKey, AssociationContext associationContext, EntityKey entityKey) {
        String relationshipType = associationContext.getAssociationTypeContext().getRoleOnMainSide();
        HashMap<RowKey, Tuple> tuples = new HashMap<RowKey, Tuple>();
        Transaction tx = this.transaction(associationContext);
        ClosableIterator<RemoteNeo4jAssociationPropertiesRow> relationships = this.entitiesQueries.get(entityKey.getMetadata()).findAssociation(tx, entityKey.getColumnValues(), relationshipType);
        while (relationships.hasNext()) {
            RemoteNeo4jAssociationPropertiesRow row = (RemoteNeo4jAssociationPropertiesRow)relationships.next();
            AssociatedEntityKeyMetadata associatedEntityKeyMetadata = associationContext.getAssociationTypeContext().getAssociatedEntityKeyMetadata();
            BoltNeo4jTupleAssociationSnapshot snapshot = new BoltNeo4jTupleAssociationSnapshot(row, associationKey, associatedEntityKeyMetadata);
            RowKey rowKey = this.convert(associationKey, snapshot);
            tuples.put(rowKey, new Tuple((TupleSnapshot)snapshot, Tuple.SnapshotType.UPDATE));
        }
        return tuples;
    }

    @Override
    protected RowKey convert(AssociationKey associationKey, TupleSnapshot snapshot) {
        String[] columnNames = associationKey.getMetadata().getRowKeyColumnNames();
        Object[] values = new Object[columnNames.length];
        for (int i = 0; i < columnNames.length; ++i) {
            values[i] = snapshot.get(columnNames[i]);
        }
        return new RowKey(columnNames, values);
    }

    public void insertOrUpdateAssociation(AssociationKey key, Association association, AssociationContext associationContext) {
        if (key.getMetadata().isInverse()) {
            return;
        }
        for (AssociationOperation action : association.getOperations()) {
            this.applyAssociationOperation(association, key, action, associationContext);
        }
    }

    private void applyAssociationOperation(Association association, AssociationKey key, AssociationOperation operation, AssociationContext associationContext) {
        switch (operation.getType()) {
            case CLEAR: {
                this.removeAssociation(key, associationContext);
                break;
            }
            case PUT: {
                this.putAssociationOperation(key, operation, associationContext);
                break;
            }
            case REMOVE: {
                this.removeAssociationOperation(key, operation, associationContext);
            }
        }
    }

    private void removeAssociationOperation(AssociationKey associationKey, AssociationOperation action, AssociationContext associationContext) {
        Transaction tx = this.transaction(associationContext);
        this.associationQueries.get(associationKey.getMetadata()).removeAssociationRow(tx, associationKey, action.getKey());
    }

    private Relationship putAssociationOperation(AssociationKey associationKey, AssociationOperation action, AssociationContext associationContext) {
        switch (associationKey.getMetadata().getAssociationKind()) {
            case EMBEDDED_COLLECTION: {
                return this.createRelationshipWithEmbeddedNode(associationKey, associationContext, action);
            }
            case ASSOCIATION: {
                return this.findOrCreateRelationshipWithEntityNode(associationKey, associationContext, action);
            }
        }
        throw new AssertionFailure("Unrecognized associationKind: " + associationKey.getMetadata().getAssociationKind());
    }

    private Relationship createRelationshipWithEmbeddedNode(AssociationKey associationKey, AssociationContext associationContext, AssociationOperation action) {
        AssociatedEntityKeyMetadata associatedEntityKeyMetadata = associationContext.getAssociationTypeContext().getAssociatedEntityKeyMetadata();
        Transaction tx = this.transaction(associationContext);
        Tuple associationRow = action.getValue();
        EntityKey embeddedKey = this.getEntityKey(associationRow, associatedEntityKeyMetadata);
        Object[] relationshipProperties = this.relationshipProperties(associationKey, action);
        Relationship relationship = this.associationQueries.get(associationKey.getMetadata()).createRelationshipForEmbeddedAssociation(tx, associationKey, embeddedKey, relationshipProperties);
        return relationship;
    }

    private Relationship findOrCreateRelationshipWithEntityNode(AssociationKey associationKey, AssociationContext associationContext, AssociationOperation action) {
        Tuple associationRow = action.getValue();
        EntityKey ownerKey = associationKey.getEntityKey();
        AssociatedEntityKeyMetadata associatedEntityKeyMetadata = associationContext.getAssociationTypeContext().getAssociatedEntityKeyMetadata();
        EntityKey targetKey = this.getEntityKey(associationRow, associatedEntityKeyMetadata);
        Object[] relationshipProperties = this.relationshipProperties(associationKey, associationRow);
        Transaction txId = this.transaction(associationContext);
        return this.associationQueries.get(associationKey.getMetadata()).createRelationship(txId, ownerKey.getColumnValues(), targetKey.getColumnValues(), relationshipProperties);
    }

    private Object[] relationshipProperties(AssociationKey associationKey, AssociationOperation action) {
        Object[] relationshipProperties = new Object[associationKey.getMetadata().getRowKeyIndexColumnNames().length];
        String[] indexColumns = associationKey.getMetadata().getRowKeyIndexColumnNames();
        for (int i = 0; i < indexColumns.length; ++i) {
            relationshipProperties[i] = action.getValue().get(indexColumns[i]);
        }
        return relationshipProperties;
    }

    private Object[] relationshipProperties(AssociationKey associationKey, Tuple associationRow) {
        String[] indexColumns = associationKey.getMetadata().getRowKeyIndexColumnNames();
        Object[] properties = new Object[indexColumns.length];
        for (int i = 0; i < indexColumns.length; ++i) {
            String propertyName = indexColumns[i];
            properties[i] = associationRow.get(propertyName);
        }
        return properties;
    }

    public void removeAssociation(AssociationKey key, AssociationContext associationContext) {
        if (key.getMetadata().isInverse()) {
            return;
        }
        Transaction tx = this.transaction(associationContext);
        this.associationQueries.get(key.getMetadata()).removeAssociation(tx, key);
    }

    public Number nextValue(NextValueRequest request) {
        return this.sequenceGenerator.nextValue(request);
    }

    public void forEachTuple(ModelConsumer consumer, TupleTypeContext tupleTypeContext, EntityKeyMetadata entityKeyMetadata) {
        DatastoreProvider datastoreProvider = (DatastoreProvider)this.getServiceRegistry().getService(DatastoreProvider.class);
        BoltNeo4jDatastoreProvider neo4jProvider = (BoltNeo4jDatastoreProvider)datastoreProvider;
        BoltNeo4jClient client = neo4jProvider.getClient();
        BoltTuplesSupplier tupleSupplier = new BoltTuplesSupplier(this.entitiesQueries.get(entityKeyMetadata), entityKeyMetadata, tupleTypeContext, client);
        consumer.consume((TuplesSupplier)tupleSupplier);
    }

    private static class BoltTuplesSupplier
    implements TuplesSupplier {
        private final BoltNeo4jEntityQueries entityQueries;
        private final EntityKeyMetadata entityKeyMetadata;
        private final TupleTypeContext tupleTypeContext;
        private final BoltNeo4jClient boltClient;

        public BoltTuplesSupplier(BoltNeo4jEntityQueries entityQueries, EntityKeyMetadata entityKeyMetadata, TupleTypeContext tupleTypeContext, BoltNeo4jClient boltClient) {
            this.entityQueries = entityQueries;
            this.entityKeyMetadata = entityKeyMetadata;
            this.tupleTypeContext = tupleTypeContext;
            this.boltClient = boltClient;
        }

        public ClosableIterator<Tuple> get(TransactionContext transactionContext) {
            boolean shouldCloseTransaction = transactionContext == null;
            Transaction tx = this.transaction(transactionContext);
            ClosableIterator<NodeWithEmbeddedNodes> entities = this.entityQueries.findEntitiesWithEmbedded(tx);
            return new BoltNeo4jNodesTupleIterator(tx, this.entityQueries, this.entityKeyMetadata, this.tupleTypeContext, entities, shouldCloseTransaction);
        }

        private Transaction transaction(TransactionContext transactionContext) {
            if (transactionContext == null) {
                Session session = this.boltClient.getDriver().session();
                return session.beginTransaction();
            }
            return (Transaction)transactionContext.getTransactionId();
        }
    }
}

