/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.neo4j.remote.http.dialect.impl;

import java.util.Map;
import org.hibernate.ogm.datastore.neo4j.remote.http.dialect.impl.HttpNeo4jAssociatedNodesHelper;
import org.hibernate.ogm.datastore.neo4j.remote.http.dialect.impl.HttpNeo4jEntityQueries;
import org.hibernate.ogm.datastore.neo4j.remote.http.dialect.impl.HttpNeo4jTupleSnapshot;
import org.hibernate.ogm.datastore.neo4j.remote.http.dialect.impl.NodeWithEmbeddedNodes;
import org.hibernate.ogm.datastore.neo4j.remote.http.impl.HttpNeo4jClient;
import org.hibernate.ogm.datastore.neo4j.remote.http.json.impl.Graph;
import org.hibernate.ogm.datastore.neo4j.remote.http.json.impl.StatementsResponse;
import org.hibernate.ogm.dialect.query.spi.ClosableIterator;
import org.hibernate.ogm.dialect.spi.TupleTypeContext;
import org.hibernate.ogm.model.key.spi.EntityKeyMetadata;
import org.hibernate.ogm.model.spi.Tuple;
import org.hibernate.ogm.model.spi.TupleSnapshot;

public class HttpNeo4jNodesTupleIterator
implements ClosableIterator<Tuple> {
    private final EntityKeyMetadata entityKeyMetadata;
    private final Long txId;
    private final TupleTypeContext tupleTypeContext;
    private final ClosableIterator<NodeWithEmbeddedNodes> entities;
    private final HttpNeo4jEntityQueries entityQueries;
    private final HttpNeo4jClient client;

    public HttpNeo4jNodesTupleIterator(HttpNeo4jClient client, Long txId, HttpNeo4jEntityQueries entityQueries, StatementsResponse response, EntityKeyMetadata entityKeyMetadata, TupleTypeContext tupleTypeContext, ClosableIterator<NodeWithEmbeddedNodes> entities) {
        this.client = client;
        this.txId = txId;
        this.entityQueries = entityQueries;
        this.entityKeyMetadata = entityKeyMetadata;
        this.tupleTypeContext = tupleTypeContext;
        this.entities = entities;
    }

    private Tuple createTuple(NodeWithEmbeddedNodes node) {
        Map<String, Graph.Node> associatedNodes = HttpNeo4jAssociatedNodesHelper.findAssociatedNodes(this.client, this.txId, node, this.entityKeyMetadata, this.tupleTypeContext, this.entityQueries);
        return new Tuple((TupleSnapshot)new HttpNeo4jTupleSnapshot(node, this.entityKeyMetadata, associatedNodes, this.tupleTypeContext), Tuple.SnapshotType.UPDATE);
    }

    public boolean hasNext() {
        return this.entities.hasNext();
    }

    public Tuple next() {
        return this.createTuple((NodeWithEmbeddedNodes)this.entities.next());
    }

    public void remove() {
        this.entities.remove();
    }

    public void close() {
        this.entities.close();
    }
}

