/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.neo4j.remote.bolt.transaction.impl;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import org.hibernate.HibernateException;
import org.hibernate.TransactionException;
import org.hibernate.engine.transaction.spi.IsolationDelegate;
import org.hibernate.engine.transaction.spi.TransactionObserver;
import org.hibernate.jdbc.WorkExecutor;
import org.hibernate.jdbc.WorkExecutorVisitable;
import org.hibernate.ogm.datastore.neo4j.logging.impl.Log;
import org.hibernate.ogm.datastore.neo4j.logging.impl.LoggerFactory;
import org.hibernate.ogm.datastore.neo4j.remote.bolt.impl.BoltNeo4jDatastoreProvider;
import org.hibernate.ogm.dialect.impl.IdentifiableDriver;
import org.hibernate.resource.transaction.SynchronizationRegistry;
import org.hibernate.resource.transaction.TransactionCoordinator;
import org.hibernate.resource.transaction.TransactionCoordinatorBuilder;
import org.hibernate.resource.transaction.internal.SynchronizationRegistryStandardImpl;
import org.hibernate.resource.transaction.spi.TransactionCoordinatorOwner;
import org.hibernate.resource.transaction.spi.TransactionStatus;
import org.neo4j.driver.v1.Driver;
import org.neo4j.driver.v1.Session;
import org.neo4j.driver.v1.Transaction;
import org.neo4j.driver.v1.util.Resource;

public class BoltNeo4jResourceLocalTransactionCoordinator
implements TransactionCoordinator {
    private static final Log log = LoggerFactory.getLogger();
    public Session session;
    private final TransactionCoordinatorBuilder transactionCoordinatorBuilder;
    private final TransactionCoordinatorOwner owner;
    private final SynchronizationRegistryStandardImpl synchronizationRegistry = new SynchronizationRegistryStandardImpl();
    private final transient List<TransactionObserver> observers;
    private final BoltNeo4jDatastoreProvider provider;
    private Neo4jTransactionDriver physicalTransactionDelegate;
    private int timeOut = -1;

    BoltNeo4jResourceLocalTransactionCoordinator(TransactionCoordinatorBuilder transactionCoordinatorBuilder, TransactionCoordinatorOwner owner, BoltNeo4jDatastoreProvider provider) {
        this.provider = provider;
        this.observers = new ArrayList<TransactionObserver>();
        this.transactionCoordinatorBuilder = transactionCoordinatorBuilder;
        this.owner = owner;
    }

    public TransactionCoordinator.TransactionDriver getTransactionDriverControl() {
        if (this.physicalTransactionDelegate == null) {
            this.physicalTransactionDelegate = new Neo4jTransactionDriver(this.provider);
        }
        return this.physicalTransactionDelegate;
    }

    public void explicitJoin() {
        log.callingJoinTransactionOnNonJtaEntityManager();
    }

    public boolean isJoined() {
        return this.physicalTransactionDelegate != null && this.physicalTransactionDelegate.getStatus() == TransactionStatus.ACTIVE;
    }

    public void pulse() {
        this.getTransactionDriverControl();
    }

    public SynchronizationRegistry getLocalSynchronizations() {
        return this.synchronizationRegistry;
    }

    public boolean isActive() {
        return this.owner.isActive();
    }

    public IsolationDelegate createIsolationDelegate() {
        return new Neo4jIsolationDelegate(this.provider);
    }

    private void close(Resource closable) {
        if (closable != null) {
            closable.close();
        }
    }

    public TransactionCoordinatorBuilder getTransactionCoordinatorBuilder() {
        return this.transactionCoordinatorBuilder;
    }

    public void setTimeOut(int seconds) {
        this.timeOut = seconds;
    }

    public int getTimeOut() {
        return this.timeOut;
    }

    private void afterBeginCallback() {
        if (this.timeOut > 0) {
            this.owner.setTransactionTimeOut(this.timeOut);
        }
        this.owner.afterTransactionBegin();
        for (TransactionObserver observer : this.observers) {
            observer.afterBegin();
        }
        log.trace("ResourceLocalTransactionCoordinatorImpl#afterBeginCallback");
    }

    private void beforeCompletionCallback() {
        log.trace("ResourceLocalTransactionCoordinatorImpl#beforeCompletionCallback");
        try {
            this.owner.beforeTransactionCompletion();
            this.synchronizationRegistry.notifySynchronizationsBeforeTransactionCompletion();
            for (TransactionObserver observer : this.observers) {
                observer.beforeCompletion();
            }
        }
        catch (RuntimeException e) {
            if (this.physicalTransactionDelegate != null) {
                this.physicalTransactionDelegate.markRollbackOnly();
            }
            throw e;
        }
    }

    private void afterCompletionCallback(boolean successful) {
        log.tracef("ResourceLocalTransactionCoordinatorImpl#afterCompletionCallback(%s)", successful);
        int statusToSend = successful ? 3 : 5;
        this.synchronizationRegistry.notifySynchronizationsAfterTransactionCompletion(statusToSend);
        this.owner.afterTransactionCompletion(successful, false);
        for (TransactionObserver observer : this.observers) {
            observer.afterCompletion(successful, false);
        }
        this.invalidateDelegate();
    }

    private void invalidateDelegate() {
        if (this.physicalTransactionDelegate == null) {
            throw new IllegalStateException("Physical-transaction delegate not known on attempt to invalidate");
        }
        this.physicalTransactionDelegate.invalidate();
        this.physicalTransactionDelegate = null;
    }

    public void addObserver(TransactionObserver observer) {
        this.observers.add(observer);
    }

    public void removeObserver(TransactionObserver observer) {
        this.observers.remove(observer);
    }

    public class Neo4jTransactionDriver
    implements IdentifiableDriver {
        private final Driver driver;
        private TransactionStatus status;
        private Transaction tx;
        private boolean invalid;
        private boolean rollbackOnly = false;

        public Neo4jTransactionDriver(BoltNeo4jDatastoreProvider provider) {
            this.driver = provider.getClient().getDriver();
        }

        protected void invalidate() {
            this.invalid = true;
        }

        public void begin() {
            this.errorIfInvalid();
            if (BoltNeo4jResourceLocalTransactionCoordinator.this.session == null) {
                BoltNeo4jResourceLocalTransactionCoordinator.this.session = this.driver.session();
            }
            this.tx = BoltNeo4jResourceLocalTransactionCoordinator.this.session.beginTransaction();
            this.status = TransactionStatus.ACTIVE;
            BoltNeo4jResourceLocalTransactionCoordinator.this.afterBeginCallback();
        }

        protected void errorIfInvalid() {
            if (this.invalid) {
                throw new IllegalStateException("Physical-transaction delegate is no longer valid");
            }
        }

        public void commit() {
            try {
                if (this.rollbackOnly) {
                    throw new TransactionException("Transaction was marked for rollback only; cannot commit");
                }
                BoltNeo4jResourceLocalTransactionCoordinator.this.beforeCompletionCallback();
                this.commit(this.tx);
                this.status = TransactionStatus.NOT_ACTIVE;
                BoltNeo4jResourceLocalTransactionCoordinator.this.afterCompletionCallback(true);
            }
            catch (RuntimeException e) {
                try {
                    this.rollback();
                }
                catch (RuntimeException e2) {
                    log.debug("Encountered failure rolling back failed commit", e2);
                }
                throw e;
            }
        }

        private void commit(Transaction tx) {
            try {
                tx.success();
                tx.close();
            }
            finally {
                tx = null;
                this.closeSession();
            }
        }

        public void rollback() {
            if (this.rollbackOnly || this.getStatus() == TransactionStatus.ACTIVE) {
                this.rollbackOnly = false;
                this.status = TransactionStatus.NOT_ACTIVE;
                this.rollback(this.tx);
                BoltNeo4jResourceLocalTransactionCoordinator.this.afterCompletionCallback(false);
            }
        }

        private void rollback(Transaction tx) {
            try {
                tx.failure();
                tx.close();
            }
            finally {
                tx = null;
                this.closeSession();
            }
        }

        private void closeSession() {
            try {
                BoltNeo4jResourceLocalTransactionCoordinator.this.session.close();
            }
            finally {
                BoltNeo4jResourceLocalTransactionCoordinator.this.session = null;
            }
        }

        public TransactionStatus getStatus() {
            return this.rollbackOnly ? TransactionStatus.MARKED_ROLLBACK : this.status;
        }

        public void markRollbackOnly() {
            if (log.isDebugEnabled()) {
                log.debug("Neo4j transaction marked for rollback-only (exception provided for stack trace)", new Exception("exception just for purpose of providing stack trace"));
            }
            this.rollbackOnly = true;
        }

        public Object getTransactionId() {
            return this.tx;
        }
    }

    private class Neo4jIsolationDelegate
    implements IsolationDelegate {
        private final BoltNeo4jDatastoreProvider provider;

        public Neo4jIsolationDelegate(BoltNeo4jDatastoreProvider provider) {
            this.provider = provider;
        }

        public <T> T delegateWork(WorkExecutorVisitable<T> work, boolean transacted) throws HibernateException {
            if (!transacted) {
                log.cannotExecuteWorkOutsideIsolatedTransaction();
            }
            Driver dataBase = this.provider.getClient().getDriver();
            Session session = null;
            try {
                Object object;
                session = dataBase.session();
                Transaction tx = session.beginTransaction();
                try {
                    Connection connection = null;
                    Object result = work.accept(new WorkExecutor(), connection);
                    tx.success();
                    tx.close();
                    object = result;
                }
                catch (Exception e) {
                    try {
                        tx.failure();
                        tx.close();
                    }
                    catch (Exception re) {
                        log.unableToRollbackTransaction(re);
                    }
                    if (e instanceof HibernateException) {
                        throw (HibernateException)((Object)e);
                    }
                    throw log.unableToPerformIsolatedWork(e);
                }
                return (T)object;
            }
            finally {
                BoltNeo4jResourceLocalTransactionCoordinator.this.close((Resource)session);
            }
        }

        public <T> T delegateCallable(Callable<T> callable, boolean transacted) throws HibernateException {
            throw new UnsupportedOperationException("Not implemented yet");
        }
    }
}

