/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.neo4j.remote.bolt.dialect.impl;

import java.util.Map;
import org.hibernate.ogm.datastore.neo4j.dialect.impl.BaseNeo4jTypeConverter;
import org.hibernate.ogm.type.impl.ByteMappedType;
import org.hibernate.ogm.type.impl.IntegerMappedType;
import org.hibernate.ogm.type.impl.LongMappedType;
import org.hibernate.ogm.type.impl.PrimitiveByteArrayStringType;
import org.hibernate.ogm.type.impl.SerializableAsStringType;
import org.hibernate.ogm.type.spi.GridType;
import org.hibernate.type.MaterializedBlobType;
import org.hibernate.type.SerializableToBlobType;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.Type;

public class BoltNeo4jTypeConverter
extends BaseNeo4jTypeConverter {
    public static final BoltNeo4jTypeConverter INSTANCE = new BoltNeo4jTypeConverter();
    private static final Map<Type, GridType> conversionMap = BoltNeo4jTypeConverter.createRemoteGridTypeConversionMap();

    private BoltNeo4jTypeConverter() {
    }

    private static Map<Type, GridType> createRemoteGridTypeConversionMap() {
        Map<Type, GridType> conversion = BaseNeo4jTypeConverter.createGridTypeConversionMap();
        conversion.put((Type)StandardBasicTypes.INTEGER, (GridType)IntegerMappedType.INSTANCE);
        conversion.put((Type)StandardBasicTypes.LONG, (GridType)LongMappedType.INSTANCE);
        conversion.put((Type)StandardBasicTypes.BYTE, (GridType)ByteMappedType.INSTANCE);
        conversion.put((Type)StandardBasicTypes.BINARY, (GridType)PrimitiveByteArrayStringType.INSTANCE);
        conversion.put((Type)MaterializedBlobType.INSTANCE, (GridType)PrimitiveByteArrayStringType.INSTANCE);
        return conversion;
    }

    @Override
    public GridType convert(Type type) {
        if (type instanceof SerializableToBlobType) {
            SerializableToBlobType exposedType = (SerializableToBlobType)type;
            return new SerializableAsStringType(exposedType.getJavaTypeDescriptor());
        }
        return conversionMap.get(type);
    }
}

