/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.neo4j.query.parsing.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class EmbeddedAliasTree {
    private final String name;
    private final String alias;
    private final List<EmbeddedAliasTree> children;

    public EmbeddedAliasTree(String alias, String name) {
        this.name = name;
        this.alias = alias;
        this.children = new ArrayList<EmbeddedAliasTree>();
    }

    public EmbeddedAliasTree findChild(String name) {
        for (EmbeddedAliasTree child : this.children) {
            if (!child.getName().equals(name)) continue;
            return child;
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public void addChild(EmbeddedAliasTree embeddedNode) {
        this.children.add(embeddedNode);
    }

    public String getAlias() {
        return this.alias;
    }

    public List<EmbeddedAliasTree> getChildren() {
        return Collections.unmodifiableList(this.children);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[name=");
        builder.append(this.name);
        builder.append(", alias=");
        builder.append(this.alias);
        builder.append("]");
        return builder.toString();
    }
}

