/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.neo4j;

import java.util.HashMap;
import java.util.Map;
import org.hibernate.ogm.datastore.neo4j.dialect.impl.BaseNeo4jTypeConverter;
import org.hibernate.ogm.datastore.neo4j.query.impl.Neo4jParameterMetadataBuilder;
import org.hibernate.ogm.datastore.neo4j.query.parsing.cypherdsl.impl.CypherDSL;
import org.hibernate.ogm.dialect.multiget.spi.MultigetGridDialect;
import org.hibernate.ogm.dialect.query.spi.BackendQuery;
import org.hibernate.ogm.dialect.query.spi.ParameterMetadataBuilder;
import org.hibernate.ogm.dialect.query.spi.QueryParameters;
import org.hibernate.ogm.dialect.query.spi.QueryableGridDialect;
import org.hibernate.ogm.dialect.query.spi.TypedGridValue;
import org.hibernate.ogm.dialect.spi.AssociationContext;
import org.hibernate.ogm.dialect.spi.AssociationTypeContext;
import org.hibernate.ogm.dialect.spi.BaseGridDialect;
import org.hibernate.ogm.dialect.spi.DuplicateInsertPreventionStrategy;
import org.hibernate.ogm.dialect.spi.OperationContext;
import org.hibernate.ogm.dialect.spi.SessionFactoryLifecycleAwareDialect;
import org.hibernate.ogm.dialect.spi.TupleContext;
import org.hibernate.ogm.model.key.spi.AssociatedEntityKeyMetadata;
import org.hibernate.ogm.model.key.spi.AssociationKey;
import org.hibernate.ogm.model.key.spi.AssociationKeyMetadata;
import org.hibernate.ogm.model.key.spi.EntityKey;
import org.hibernate.ogm.model.key.spi.EntityKeyMetadata;
import org.hibernate.ogm.model.key.spi.RowKey;
import org.hibernate.ogm.model.spi.Association;
import org.hibernate.ogm.model.spi.Tuple;
import org.hibernate.ogm.model.spi.TupleSnapshot;
import org.hibernate.ogm.type.spi.GridType;
import org.hibernate.ogm.util.impl.ArrayHelper;
import org.hibernate.ogm.util.impl.EmbeddedHelper;
import org.hibernate.service.spi.ServiceRegistryAwareService;
import org.hibernate.service.spi.ServiceRegistryImplementor;
import org.hibernate.type.Type;

public abstract class BaseNeo4jDialect
extends BaseGridDialect
implements QueryableGridDialect<String>,
ServiceRegistryAwareService,
SessionFactoryLifecycleAwareDialect,
MultigetGridDialect {
    public static final String CONSTRAINT_VIOLATION_CODE = "Neo.ClientError.Schema.ConstraintValidationFailed";
    private ServiceRegistryImplementor serviceRegistry;
    private final BaseNeo4jTypeConverter typeConverter;

    public BaseNeo4jDialect(BaseNeo4jTypeConverter converter) {
        this.typeConverter = converter;
    }

    public void injectServices(ServiceRegistryImplementor serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
    }

    public ServiceRegistryImplementor getServiceRegistry() {
        return this.serviceRegistry;
    }

    public Tuple createTuple(EntityKey key, OperationContext operationContext) {
        return new Tuple();
    }

    public Association createAssociation(AssociationKey associationKey, AssociationContext associationContext) {
        return new Association();
    }

    public boolean isStoredInEntityStructure(AssociationKeyMetadata associationKeyMetadata, AssociationTypeContext associationTypeContext) {
        return false;
    }

    public boolean supportsSequences() {
        return true;
    }

    protected RowKey convert(AssociationKey associationKey, TupleSnapshot snapshot) {
        String[] columnNames = associationKey.getMetadata().getRowKeyColumnNames();
        Object[] values = new Object[columnNames.length];
        for (int i = 0; i < columnNames.length; ++i) {
            values[i] = snapshot.get(columnNames[i]);
        }
        return new RowKey(columnNames, values);
    }

    public GridType overrideType(Type type) {
        return this.typeConverter.convert(type);
    }

    public String parseNativeQuery(String nativeQuery) {
        return nativeQuery;
    }

    protected String buildNativeQuery(BackendQuery<String> customQuery, QueryParameters queryParameters) {
        StringBuilder nativeQuery = new StringBuilder((String)customQuery.getQuery());
        this.applyFirstRow(queryParameters, nativeQuery);
        this.applyMaxRows(queryParameters, nativeQuery);
        return nativeQuery.toString();
    }

    private void applyFirstRow(QueryParameters queryParameters, StringBuilder nativeQuery) {
        Integer firstRow = queryParameters.getRowSelection().getFirstRow();
        if (firstRow != null) {
            CypherDSL.skip(nativeQuery, firstRow);
        }
    }

    private void applyMaxRows(QueryParameters queryParameters, StringBuilder nativeQuery) {
        Integer maxRows = queryParameters.getRowSelection().getMaxRows();
        if (maxRows != null) {
            CypherDSL.limit(nativeQuery, maxRows);
        }
    }

    public ParameterMetadataBuilder getParameterMetadataBuilder() {
        return new Neo4jParameterMetadataBuilder();
    }

    protected EntityKey getEntityKey(Tuple tuple, AssociatedEntityKeyMetadata associatedEntityKeyMetadata) {
        Object[] columnValues = new Object[associatedEntityKeyMetadata.getAssociationKeyColumns().length];
        int i = 0;
        for (String associationKeyColumn : associatedEntityKeyMetadata.getAssociationKeyColumns()) {
            columnValues[i] = tuple.get(associationKeyColumn);
            ++i;
        }
        return new EntityKey(associatedEntityKeyMetadata.getEntityKeyMetadata(), columnValues);
    }

    public DuplicateInsertPreventionStrategy getDuplicateInsertPreventionStrategy(EntityKeyMetadata entityKeyMetadata) {
        return entityKeyMetadata.getColumnNames().length == 1 ? DuplicateInsertPreventionStrategy.NATIVE : DuplicateInsertPreventionStrategy.LOOK_UP;
    }

    public static boolean isPartOfRegularEmbedded(String[] keyColumnNames, String column) {
        return EmbeddedHelper.isPartOfEmbedded((String)column) && !ArrayHelper.contains((Object[])keyColumnNames, (Object)column);
    }

    public int executeBackendUpdateQuery(BackendQuery<String> query, QueryParameters queryParameters, TupleContext tupleContext) {
        throw new UnsupportedOperationException("Not yet implemented.");
    }

    protected Map<String, Object> getParameters(QueryParameters queryParameters) {
        HashMap<String, Object> parameters = new HashMap<String, Object>(queryParameters.getNamedParameters().size());
        for (Map.Entry parameter : queryParameters.getNamedParameters().entrySet()) {
            parameters.put((String)parameter.getKey(), ((TypedGridValue)parameter.getValue()).getValue());
        }
        return parameters;
    }

    public boolean usesNavigationalInformationForInverseSideOfAssociations() {
        return false;
    }
}

