/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.neo4j.dialect.impl;

import java.util.Map;
import org.hibernate.ogm.datastore.neo4j.dialect.impl.MapsTupleIterator;
import org.hibernate.ogm.datastore.neo4j.dialect.impl.Neo4jTupleSnapshot;
import org.hibernate.ogm.dialect.spi.TupleContext;
import org.hibernate.ogm.model.key.spi.EntityKeyMetadata;
import org.hibernate.ogm.model.spi.Tuple;
import org.hibernate.ogm.model.spi.TupleSnapshot;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Result;

public class NodesTupleIterator
extends MapsTupleIterator {
    private final EntityKeyMetadata entityKeyMetadata;
    private final TupleContext tupleContext;

    public NodesTupleIterator(Result result, EntityKeyMetadata entityKeyMetadata, TupleContext tupleContext) {
        super(result);
        this.entityKeyMetadata = entityKeyMetadata;
        this.tupleContext = tupleContext;
    }

    @Override
    protected Tuple convert(Map<String, Object> next) {
        return this.createTuple((Node)next.values().iterator().next());
    }

    private Tuple createTuple(Node node) {
        return new Tuple((TupleSnapshot)Neo4jTupleSnapshot.fromNode(node, this.tupleContext.getAllAssociatedEntityKeyMetadata(), this.tupleContext.getAllRoles(), this.entityKeyMetadata));
    }
}

