/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.neo4j.impl;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.hibernate.ogm.datastore.neo4j.spi.GraphDatabaseServiceFactory;
import org.hibernate.ogm.util.configurationreader.spi.ConfigurationPropertyReader;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.factory.GraphDatabaseBuilder;
import org.neo4j.graphdb.factory.GraphDatabaseFactory;

public class EmbeddedGraphDatabaseFactory
implements GraphDatabaseServiceFactory {
    private String dbLocation;
    private URL configurationLocation;
    private Map<?, ?> configuration;

    @Override
    public void initialize(Map<?, ?> properties) {
        ConfigurationPropertyReader configurationPropertyReader = new ConfigurationPropertyReader(properties);
        this.dbLocation = (String)configurationPropertyReader.property("hibernate.ogm.neo4j.database_path", String.class).required().getValue();
        this.configurationLocation = (URL)configurationPropertyReader.property("hibernate.ogm.neo4j.configuration_resource_name", URL.class).getValue();
        this.configuration = properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GraphDatabaseService create() {
        GraphDatabaseBuilder builder = new GraphDatabaseFactory().newEmbeddedDatabaseBuilder(this.dbLocation);
        this.setConfigurationFromLocation(builder, this.configurationLocation);
        this.setConfigurationFromProperties(builder, this.configuration);
        ClassLoader neo4JClassLoader = builder.getClass().getClassLoader();
        Thread currentThread = Thread.currentThread();
        ClassLoader contextClassLoader = currentThread.getContextClassLoader();
        try {
            currentThread.setContextClassLoader(neo4JClassLoader);
            GraphDatabaseService graphDatabaseService = builder.newGraphDatabase();
            return graphDatabaseService;
        }
        finally {
            currentThread.setContextClassLoader(contextClassLoader);
        }
    }

    private void setConfigurationFromProperties(GraphDatabaseBuilder builder, Map<?, ?> properties) {
        if (properties != null) {
            builder.setConfig(this.convert(properties));
        }
    }

    private Map<String, String> convert(Map<?, ?> properties) {
        HashMap<String, String> neo4jConfiguration = new HashMap<String, String>();
        for (Map.Entry<?, ?> entry : properties.entrySet()) {
            neo4jConfiguration.put(String.valueOf(entry.getKey()), String.valueOf(entry.getValue()));
        }
        return neo4jConfiguration;
    }

    private void setConfigurationFromLocation(GraphDatabaseBuilder builder, URL cfgLocation) {
        if (cfgLocation != null) {
            builder.loadPropertiesFromURL(cfgLocation);
        }
    }
}

