/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.neo4j.query.parsing.impl;

import java.util.List;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.hql.ast.spi.EntityNamesResolver;
import org.hibernate.hql.ast.spi.PropertyHelper;
import org.hibernate.ogm.datastore.neo4j.query.parsing.impl.Neo4jQueryParameter;
import org.hibernate.ogm.model.spi.Tuple;
import org.hibernate.ogm.persister.impl.OgmEntityPersister;
import org.hibernate.ogm.query.parsing.impl.ParserPropertyHelper;
import org.hibernate.ogm.type.spi.GridType;
import org.hibernate.ogm.type.spi.TypeTranslator;
import org.hibernate.type.Type;

public class Neo4jPropertyHelper
extends ParserPropertyHelper
implements PropertyHelper {
    public Neo4jPropertyHelper(SessionFactoryImplementor sessionFactory, EntityNamesResolver entityNames) {
        super(sessionFactory, entityNames);
    }

    public Object convertToBackendType(String entityType, List<String> propertyPath, Object value) {
        if (value instanceof Neo4jQueryParameter) {
            return value;
        }
        return super.convertToBackendType(entityType, propertyPath, value);
    }

    public Object convertToLiteral(String entityType, List<String> propertyPath, Object value) {
        Type propertyType = this.getPropertyType(entityType, propertyPath);
        Object gridValue = this.convertToGridType(value, propertyType);
        return gridValue;
    }

    private Object convertToGridType(Object value, Type propertyType) {
        if (value instanceof Neo4jQueryParameter) {
            return value;
        }
        Tuple dummy = new Tuple();
        GridType gridType = this.typeTranslator().getType(propertyType);
        gridType.nullSafeSet(dummy, value, new String[]{"key"}, null);
        return dummy.get("key");
    }

    private TypeTranslator typeTranslator() {
        return (TypeTranslator)this.getSessionFactory().getServiceRegistry().getService(TypeTranslator.class);
    }

    public String getColumnName(Class<?> entityType, List<String> propertyName) {
        return this.getColumnName((OgmEntityPersister)this.getSessionFactory().getEntityPersister(entityType.getName()), propertyName);
    }

    public String getColumnName(String entityType, List<String> propertyPath) {
        return this.getColumnName(this.getPersister(entityType), propertyPath);
    }

    public String getColumnName(OgmEntityPersister persister, List<String> propertyName) {
        return this.getColumn(persister, propertyName);
    }

    public String getEmbeddeColumnName(String entityType, List<String> propertyPath) {
        String columnName = this.getColumnName(entityType, propertyPath);
        columnName = columnName.substring(columnName.lastIndexOf(46) + 1, columnName.length());
        return columnName;
    }
}

