/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.neo4j.query.parsing.impl;

import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.hql.ast.spi.AstProcessingChain;
import org.hibernate.hql.ast.spi.AstProcessor;
import org.hibernate.hql.ast.spi.EntityNamesResolver;
import org.hibernate.hql.ast.spi.QueryRendererDelegate;
import org.hibernate.hql.ast.spi.QueryRendererProcessor;
import org.hibernate.hql.ast.spi.QueryResolverDelegate;
import org.hibernate.hql.ast.spi.QueryResolverProcessor;
import org.hibernate.ogm.datastore.neo4j.query.parsing.impl.AliasResolver;
import org.hibernate.ogm.datastore.neo4j.query.parsing.impl.Neo4jPropertyHelper;
import org.hibernate.ogm.datastore.neo4j.query.parsing.impl.Neo4jQueryParsingResult;
import org.hibernate.ogm.datastore.neo4j.query.parsing.impl.Neo4jQueryRendererDelegate;
import org.hibernate.ogm.datastore.neo4j.query.parsing.impl.Neo4jQueryResolverDelegate;

public class Neo4jProcessingChain
implements AstProcessingChain<Neo4jQueryParsingResult> {
    private final QueryResolverProcessor resolverProcessor;
    private final QueryRendererProcessor rendererProcessor;
    private final Neo4jQueryRendererDelegate rendererDelegate;

    public Neo4jProcessingChain(SessionFactoryImplementor sessionFactory, EntityNamesResolver entityNamesResolver, Map<String, Object> namedParameters) {
        AliasResolver aliasResolver = new AliasResolver();
        Neo4jQueryResolverDelegate resolverDelegate = new Neo4jQueryResolverDelegate(aliasResolver);
        Neo4jPropertyHelper propertyHelper = new Neo4jPropertyHelper(sessionFactory, entityNamesResolver);
        this.rendererDelegate = new Neo4jQueryRendererDelegate(sessionFactory, aliasResolver, entityNamesResolver, propertyHelper, namedParameters);
        this.rendererProcessor = new QueryRendererProcessor((QueryRendererDelegate)this.rendererDelegate);
        this.resolverProcessor = new QueryResolverProcessor((QueryResolverDelegate)resolverDelegate);
    }

    public Iterator<AstProcessor> iterator() {
        return Arrays.asList(this.resolverProcessor, this.rendererProcessor).iterator();
    }

    public Neo4jQueryParsingResult getResult() {
        return this.rendererDelegate.getResult();
    }
}

