/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.neo4j.impl;

import org.hibernate.ogm.datastore.neo4j.logging.impl.Log;
import org.hibernate.ogm.datastore.neo4j.logging.impl.LoggerFactory;
import org.neo4j.helpers.collection.Visitor;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.kernel.logging.LogMarker;

public class StringLoggerToJBossLoggingAdaptor
extends StringLogger {
    public static final StringLogger JBOSS_LOGGING_STRING_LOGGER = new StringLoggerToJBossLoggingAdaptor();
    private static final Log log = LoggerFactory.getLogger();

    public void logLongMessage(String msg, Visitor<StringLogger.LineLogger, RuntimeException> source, final boolean flush) {
        this.logMessage(msg, flush);
        source.visit((Object)new StringLogger.LineLogger(){

            public void logLine(String line) {
                StringLoggerToJBossLoggingAdaptor.this.logMessage(line, flush);
            }
        });
    }

    public void logMessage(String msg, boolean flush) {
        log.logNeo4JQueryEngineMessage(msg);
    }

    public void logMessage(String msg, LogMarker marker) {
        log.logNeo4JQueryEngineUserMessage(marker.getName(), msg);
    }

    public void logMessage(String msg, Throwable cause, boolean flush) {
        log.logNeo4JQueryEngineException(msg, cause);
    }

    public void addRotationListener(Runnable listener) {
    }

    public void flush() {
    }

    public void close() {
    }

    public boolean isDebugEnabled() {
        return log.isDebugEnabled();
    }

    protected void logLine(String line) {
        log.logNeo4JQueryEngineMessage(line);
    }
}

