/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.neo4j.dialect.impl;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.hibernate.ogm.datastore.neo4j.dialect.impl.Neo4jTupleAssociationSnapshot;
import org.hibernate.ogm.model.key.spi.AssociatedEntityKeyMetadata;
import org.hibernate.ogm.model.key.spi.AssociationKey;
import org.hibernate.ogm.model.key.spi.RowKey;
import org.hibernate.ogm.model.spi.AssociationSnapshot;
import org.hibernate.ogm.model.spi.Tuple;
import org.hibernate.ogm.model.spi.TupleSnapshot;
import org.hibernate.ogm.util.impl.Contracts;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.DynamicRelationshipType;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;

public final class Neo4jAssociationSnapshot
implements AssociationSnapshot {
    private final Map<RowKey, Tuple> tuples = new HashMap<RowKey, Tuple>();

    public Neo4jAssociationSnapshot(Node ownerNode, AssociationKey associationKey, AssociatedEntityKeyMetadata associatedEntityKeyMetadata, String relationshipType) {
        Contracts.assertParameterNotNull((Object)relationshipType, (String)"relationshipType");
        for (Relationship relationship : Neo4jAssociationSnapshot.relationships(ownerNode, associationKey, relationshipType)) {
            Neo4jTupleAssociationSnapshot snapshot = new Neo4jTupleAssociationSnapshot(relationship, associationKey, associatedEntityKeyMetadata);
            RowKey rowKey = this.convert(associationKey, snapshot);
            this.tuples.put(rowKey, new Tuple((TupleSnapshot)snapshot));
        }
    }

    public Tuple get(RowKey rowKey) {
        Tuple tuple = this.tuples.get(rowKey);
        return tuple;
    }

    public boolean containsKey(RowKey rowKey) {
        return this.tuples.containsKey(rowKey);
    }

    public int size() {
        return this.tuples.size();
    }

    public Set<RowKey> getRowKeys() {
        return this.tuples.keySet();
    }

    private static Iterable<Relationship> relationships(Node ownerNode, AssociationKey associationKey, String relationshipType) {
        return ownerNode.getRelationships(Direction.BOTH, new RelationshipType[]{DynamicRelationshipType.withName((String)relationshipType)});
    }

    private RowKey convert(AssociationKey associationKey, Neo4jTupleAssociationSnapshot snapshot) {
        String[] columnNames = associationKey.getMetadata().getRowKeyColumnNames();
        Object[] values = new Object[columnNames.length];
        for (int i = 0; i < columnNames.length; ++i) {
            values[i] = snapshot.get(columnNames[i]);
        }
        return new RowKey(columnNames, values);
    }
}

