/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.neo4j.impl;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.hibernate.ogm.datastore.neo4j.spi.GraphDatabaseServiceFactory;
import org.hibernate.ogm.util.configurationreader.impl.ConfigurationPropertyReader;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.factory.GraphDatabaseBuilder;
import org.neo4j.graphdb.factory.GraphDatabaseFactory;

public class EmbeddedGraphDatabaseFactory
implements GraphDatabaseServiceFactory {
    private String dbLocation;
    private URL configurationLocation;
    private Map<?, ?> configuration;

    @Override
    public void initialize(Map<?, ?> properties) {
        ConfigurationPropertyReader configurationPropertyReader = new ConfigurationPropertyReader(properties);
        this.dbLocation = (String)configurationPropertyReader.property("hibernate.ogm.neo4j.database_path", String.class).required().getValue();
        this.configurationLocation = (URL)configurationPropertyReader.property("hibernate.ogm.neo4j.configuration_resource_name", URL.class).getValue();
        this.configuration = properties;
    }

    @Override
    public GraphDatabaseService create() {
        GraphDatabaseBuilder builder = new GraphDatabaseFactory().newEmbeddedDatabaseBuilder(this.dbLocation);
        this.setConfigurationFromLocation(builder, this.configurationLocation);
        this.setConfigurationFromProperties(builder, this.configuration);
        return builder.newGraphDatabase();
    }

    private void setConfigurationFromProperties(GraphDatabaseBuilder builder, Map<?, ?> properties) {
        if (properties != null) {
            builder.setConfig(this.convert(properties));
        }
    }

    private Map<String, String> convert(Map<?, ?> properties) {
        HashMap<String, String> neo4jConfiguration = new HashMap<String, String>();
        for (Map.Entry<?, ?> entry : properties.entrySet()) {
            neo4jConfiguration.put(String.valueOf(entry.getKey()), String.valueOf(entry.getValue()));
        }
        return neo4jConfiguration;
    }

    private void setConfigurationFromLocation(GraphDatabaseBuilder builder, URL cfgLocation) {
        if (cfgLocation != null) {
            builder.loadPropertiesFromURL(cfgLocation);
        }
    }
}

