/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.neo4j.dialect.impl;

import java.util.HashMap;
import java.util.Map;
import org.hibernate.ogm.datastore.neo4j.dialect.impl.NodeLabel;
import org.hibernate.ogm.grid.AssociationKey;
import org.hibernate.ogm.grid.EntityKey;
import org.hibernate.ogm.grid.Key;
import org.hibernate.ogm.grid.RowKey;
import org.neo4j.cypher.javacompat.ExecutionEngine;
import org.neo4j.cypher.javacompat.ExecutionResult;
import org.neo4j.graphdb.DynamicRelationshipType;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.ResourceIterator;

public class CypherCRUD {
    private final ExecutionEngine engine;

    public CypherCRUD(GraphDatabaseService graphDb) {
        this.engine = new ExecutionEngine(graphDb);
    }

    public Relationship findRelationship(AssociationKey associationKey, RowKey rowKey) {
        EntityKey entityKey = associationKey.getEntityKey();
        HashMap<String, Object> parameters = new HashMap<String, Object>(entityKey.getColumnNames().length + rowKey.getColumnNames().length);
        StringBuilder query = new StringBuilder("MATCH");
        this.appendNodePattern((Key)entityKey, parameters, query, NodeLabel.ENTITY);
        query.append(" - ");
        query.append(this.relationshipCypher(associationKey, rowKey, parameters, entityKey.getColumnNames().length));
        query.append(" -> () RETURN r");
        ExecutionResult result = this.engine.execute(query.toString(), parameters);
        ResourceIterator column = result.columnAs("r");
        Relationship relationship = null;
        if (column.hasNext()) {
            relationship = (Relationship)column.next();
        }
        column.close();
        return relationship;
    }

    public Node findNode(Key key) {
        return this.findNode(key, null);
    }

    public Node findNode(Key key, NodeLabel label) {
        HashMap<String, Object> parameters = new HashMap<String, Object>(key.getColumnNames().length);
        StringBuilder query = new StringBuilder("MATCH");
        this.appendNodePattern(key, parameters, query, label);
        query.append(" RETURN n");
        ExecutionResult result = this.engine.execute(query.toString(), parameters);
        ResourceIterator column = result.columnAs("n");
        Node node = null;
        if (column.hasNext()) {
            node = (Node)column.next();
        }
        column.close();
        return node;
    }

    public void remove(EntityKey entityKey) {
        HashMap<String, Object> parameters = new HashMap<String, Object>(entityKey.getColumnNames().length);
        StringBuilder query = new StringBuilder("MATCH");
        this.appendNodePattern((Key)entityKey, parameters, query, NodeLabel.ENTITY);
        query.append(" OPTIONAL MATCH (n) - [r] - () DELETE r,n");
        this.engine.execute(query.toString(), parameters);
    }

    public ResourceIterator<Node> findNodes(String tableName) {
        String query = "MATCH (n:`" + tableName + "`) RETURN n";
        ExecutionResult result = this.engine.execute(query.toString());
        return result.columnAs("n");
    }

    public Node createNodeUnlessExists(Key key, NodeLabel label) {
        HashMap<String, Object> parameters = new HashMap<String, Object>(key.getColumnNames().length);
        StringBuilder query = new StringBuilder("MERGE");
        this.appendNodePattern(key, parameters, query, label);
        query.append(" RETURN n");
        ExecutionResult result = this.engine.execute(query.toString(), parameters);
        ResourceIterator column = result.columnAs("n");
        Node node = null;
        if (column.hasNext()) {
            node = (Node)column.next();
        }
        column.close();
        return node;
    }

    private void appendNodePattern(Key key, Map<String, Object> parameters, StringBuilder query, NodeLabel label) {
        query.append("(n:`");
        query.append(key.getTable());
        query.append("`");
        if (label != null) {
            query.append(":");
            query.append(label.name());
        }
        query.append(" {");
        int columnsLength = key.getColumnNames().length;
        for (int i = 0; i < columnsLength; ++i) {
            query.append("`");
            query.append(key.getColumnNames()[i]);
            query.append("`: {");
            query.append(i);
            query.append("}");
            parameters.put(String.valueOf(i), key.getColumnValues()[i]);
            if (i >= columnsLength - 1) continue;
            query.append(",");
        }
        query.append("})");
    }

    private String relationshipCypher(AssociationKey associationKey, RowKey rowKey, Map<String, Object> parameters, int counter) {
        String[] columnNames = rowKey.getColumnNames();
        Object[] columnValues = rowKey.getColumnValues();
        String table = rowKey.getTable();
        StringBuilder relationshipBuilder = new StringBuilder("[r");
        if (associationKey != null) {
            relationshipBuilder.append(":");
            relationshipBuilder.append(CypherCRUD.relationshipType(associationKey).name());
        }
        this.appendRelationshipProperties(parameters, counter, columnNames, columnValues, table, relationshipBuilder);
        return relationshipBuilder.toString();
    }

    private String relationshipCypher(AssociationKey associationKey, Map<String, Object> parameters, int counter) {
        String[] columnNames = associationKey.getColumnNames();
        Object[] columnValues = associationKey.getColumnValues();
        String table = associationKey.getTable();
        StringBuilder relationshipBuilder = new StringBuilder("[r");
        relationshipBuilder.append(":");
        relationshipBuilder.append(CypherCRUD.relationshipType(associationKey).name());
        this.appendRelationshipProperties(parameters, counter, columnNames, columnValues, table, relationshipBuilder);
        return relationshipBuilder.toString();
    }

    private void appendRelationshipProperties(Map<String, Object> parameters, int counter, String[] columnNames, Object[] columnValues, String table, StringBuilder relationshipBuilder) {
        relationshipBuilder.append(" { ");
        for (int i = 0; i < columnNames.length; ++i) {
            if (columnValues[i] == null) continue;
            relationshipBuilder.append("`");
            relationshipBuilder.append(columnNames[i]);
            relationshipBuilder.append("`");
            relationshipBuilder.append(" : {");
            relationshipBuilder.append(counter);
            relationshipBuilder.append("}");
            parameters.put(String.valueOf(counter++), columnValues[i]);
            if (i >= columnNames.length - 1) continue;
            relationshipBuilder.append(",");
        }
        relationshipBuilder.append("}]");
    }

    public static RelationshipType relationshipType(AssociationKey associationKey) {
        return DynamicRelationshipType.withName((String)associationKey.getCollectionRole());
    }

    public void remove(AssociationKey associationKey) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        StringBuilder query = new StringBuilder("MATCH (n) - ");
        query.append(this.relationshipCypher(associationKey, parameters, 0));
        query.append(" - () DELETE r");
        this.engine.execute(query.toString(), parameters);
    }

    public void remove(AssociationKey associationKey, RowKey rowKey) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        StringBuilder query = new StringBuilder("MATCH (n) - ");
        query.append(this.relationshipCypher(associationKey, rowKey, parameters, 0));
        query.append(" - () DELETE r");
        this.engine.execute(query.toString(), parameters);
    }

    public ExecutionResult executeQuery(String query, Map<String, Object> parameters) {
        return this.engine.execute(query, parameters);
    }
}

