/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.dialect.neo4j;

import java.util.HashSet;
import java.util.Set;
import org.hibernate.ogm.datastore.spi.TupleSnapshot;
import org.neo4j.graphdb.PropertyContainer;

public final class Neo4jTupleSnapshot
implements TupleSnapshot {
    private final PropertyContainer node;

    public Neo4jTupleSnapshot(PropertyContainer node) {
        this.node = node;
    }

    public Object get(String column) {
        if (this.node.hasProperty(column)) {
            return this.node.getProperty(column);
        }
        return null;
    }

    public boolean isEmpty() {
        return !this.node.getPropertyKeys().iterator().hasNext();
    }

    public Set<String> getColumnNames() {
        HashSet<String> names = new HashSet<String>();
        for (String string : this.node.getPropertyKeys()) {
            names.add(string);
        }
        return names;
    }
}

