/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.mongodb.type;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bson.BsonArray;
import org.bson.BsonValue;
import org.bson.Document;
import org.hibernate.ogm.datastore.mongodb.logging.impl.Log;
import org.hibernate.ogm.datastore.mongodb.logging.impl.LoggerFactory;
import org.hibernate.ogm.datastore.mongodb.type.AbstractGeoJsonObject;
import org.hibernate.ogm.datastore.mongodb.type.GeoLineString;
import org.hibernate.ogm.datastore.mongodb.type.GeoMultiLineString;
import org.hibernate.ogm.datastore.mongodb.type.GeoMultiPoint;
import org.hibernate.ogm.datastore.mongodb.type.GeoMultiPolygon;
import org.hibernate.ogm.datastore.mongodb.type.GeoPoint;
import org.hibernate.ogm.datastore.mongodb.type.GeoPolygon;
import org.hibernate.ogm.util.impl.ArrayHelper;
import org.hibernate.ogm.util.impl.Contracts;

public class GeoCollection
extends AbstractGeoJsonObject {
    private static final String TYPE = "GeometryCollection";
    private static final Log log = LoggerFactory.make(MethodHandles.lookup());
    private List<AbstractGeoJsonObject> geometries;

    public GeoCollection(List<AbstractGeoJsonObject> geometries) {
        super(TYPE, "geometries");
        this.geometries = geometries;
    }

    public GeoCollection(AbstractGeoJsonObject firstGeoObject, AbstractGeoJsonObject ... additionalGeoObjects) {
        super(TYPE);
        Contracts.assertNotNull((Object)firstGeoObject, (String)"firstGeoObject");
        Contracts.assertNotNull((Object)additionalGeoObjects, (String)"additionalGeoObjects");
        this.geometries = new ArrayList<Object>(Arrays.asList(ArrayHelper.concat((Object)firstGeoObject, (Object[])additionalGeoObjects)));
    }

    @Override
    protected BsonArray toCoordinates() {
        BsonArray coordinates = new BsonArray();
        for (AbstractGeoJsonObject geometry : this.geometries) {
            coordinates.add((BsonValue)geometry.toBsonDocument());
        }
        return coordinates;
    }

    public static GeoCollection fromDocument(Document document) {
        if (document == null) {
            return null;
        }
        GeoCollection.checkType(TYPE, document);
        List geometries = (List)document.get((Object)"geometries");
        ArrayList<AbstractGeoJsonObject> array = new ArrayList<AbstractGeoJsonObject>();
        for (Document geometry : geometries) {
            array.add(GeoCollection.getGeoJsonObjectFromDocument(geometry));
        }
        return new GeoCollection(array);
    }

    private static AbstractGeoJsonObject getGeoJsonObjectFromDocument(Document document) {
        switch ((String)document.get((Object)"type")) {
            case "LineString": {
                return GeoLineString.fromDocument(document);
            }
            case "MultiLineString": {
                return GeoMultiLineString.fromDocument(document);
            }
            case "MultiPoint": {
                return GeoMultiPoint.fromDocument(document);
            }
            case "MultiPolygon": {
                return GeoMultiPolygon.fromDocument(document);
            }
            case "Point": {
                return GeoPoint.fromDocument(document);
            }
            case "Polygon": {
                return GeoPolygon.fromDocument(document);
            }
        }
        throw log.invalidGeoJsonType((String)document.get((Object)"type"), String.join((CharSequence)";", "LineString", "MultiLineString", "MultiPoint", "MultiPolygon", "Point", "Polygon"));
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        GeoCollection that = (GeoCollection)obj;
        return that.geometries.equals(this.geometries);
    }

    public int hashCode() {
        return this.geometries.hashCode();
    }

    public String toString() {
        return "GeoCollection [geometries=" + this.geometries + "]";
    }
}

