/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.mongodb.logging.impl;

import com.mongodb.MongoException;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.ogm.datastore.mongodb.query.impl.MongoDBQueryDescriptor;
import org.hibernate.ogm.model.key.spi.EntityKey;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;

@MessageLogger(projectCode="OGM")
public interface Log
extends org.hibernate.ogm.util.impl.Log {
    @LogMessage(level=Logger.Level.INFO)
    @Message(id=1201, value="Connecting to MongoDB at %1$s with a timeout set at %2$d millisecond(s)")
    public void connectingToMongo(String var1, int var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=1202, value="Closing connection to MongoDB")
    public void disconnectingFromMongo();

    @Message(id=1203, value="Unable to find or initialize a connection to the MongoDB server")
    public HibernateException unableToInitializeMongoDB(@Cause RuntimeException var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=1206, value="Mongo database named [%s] is not defined. Creating it!")
    public void creatingDatabase(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=1207, value="Connecting to Mongo database named [%s].")
    public void connectingToMongoDatabase(String var1);

    @Message(id=1209, value="The database named [%s] cannot be dropped")
    public HibernateException unableToDropDatabase(@Cause MongoException var1, String var2);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=1210, value="Removed [%d] associations")
    public void removedAssociation(long var1);

    @Message(id=1214, value="Unable to connect to MongoDB instance: %1$s")
    public HibernateException unableToConnectToDatastore(String var1, @Cause Exception var2);

    @Message(id=1217, value="The following native query does neither specify the collection name nor is its result type mapped to an entity: %s")
    public HibernateException unableToDetermineCollectionName(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=1218, value="Cannot use primary key column name '%s' for id generator, going to use '%s' instead")
    public void cannotUseGivenPrimaryKeyColumnName(String var1, String var2);

    @Message(id=1219, value="Database %s does not exist. Either create it yourself or set property 'hibernate.ogm.datastore.create_database' to true.")
    public HibernateException databaseDoesNotExistException(String var1);

    @Message(id=1220, value="When using MongoDB it is not valid to use a name for a table (a collection) which starts with the 'system.' prefix. Please change name for '%s', for example by using @Table ")
    public MappingException collectionNameHasInvalidSystemPrefix(String var1);

    @Message(id=1221, value="When using MongoDB it is not valid to use a name for a table (a collection) which contains the NUL character '\\0'. Please change name for '%s', for example by using @Table ")
    public MappingException collectionNameContainsNULCharacter(String var1);

    @Message(id=1222, value="When using MongoDB it is not valid to use a name for a table (a collection) which contains the dollar character '$'; for example this is a common problem with inner classes. Please pick a valid collection name for '%s', for example by using @Table ")
    public MappingException collectionNameContainsDollarCharacter(String var1);

    @Message(id=1223, value="When using MongoDB it is not valid to use a field name which starts with the prefix '$'. Please change name for '%s', for example by using @Column ")
    public MappingException fieldNameHasInvalidDollarPrefix(String var1);

    @Message(id=1224, value="When using MongoDB it is not valid to use a field name which contains the NUL character '\\0'. Please change name for '%s', for example by using @Column ")
    public MappingException fieldNameContainsNULCharacter(String var1);

    @Message(id=1225, value="This WriteConcern has been deprecated or removed by MongoDB: %s")
    public HibernateException writeConcernDeprecated(String var1);

    @Message(id=1226, value="Unable to use reflection on invoke method '%s#%s' via reflection.")
    public HibernateException unableToInvokeMethodViaReflection(String var1, String var2);

    @Message(id=1227, value="Query must be executed using the 'executeUpdate()' method: %s")
    public HibernateException updateQueryMustBeExecutedViaExecuteUpdate(MongoDBQueryDescriptor var1);

    @Message(id=1228, value="Query must be executed using 'getResultList()' or 'getSingleResult()' method: %s")
    public HibernateException readQueryMustBeExecutedViaGetResultList(MongoDBQueryDescriptor var1);

    @Message(id=1229, value="Constraint violation for entity %s (%s)")
    public HibernateException constraintViolationForEntity(EntityKey var1, String var2, @Cause Exception var3);

    @Message(id=1230, value="Constraint violation while flushing several entities (%s)")
    public HibernateException constraintViolationOnFlush(String var1, @Cause Exception var2);

    @Message(id=1231, value="Unable to create index %2$s on collection %1$s")
    public HibernateException unableToCreateIndex(String var1, String var2, @Cause Exception var3);

    @Message(id=1232, value="Unable to create text index %2$s on collection %1$s. A text index named %3$s already exists and MongoDB only supports one text index per collection.")
    public HibernateException unableToCreateTextIndex(String var1, String var2, String var3);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=1233, value="Cannot create an index with an empty name for collection %1$s. Please provide a name for all the indexes.")
    public void indexNameIsEmpty(String var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=1234, value="No valid keys found for the index %2$s of collection %1$s.")
    public void noValidKeysForIndex(String var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=1235, value="Index option for index %2$s of collection %1$s are referencing a non existing index.")
    public void indexOptionReferencingNonExistingIndex(String var1, String var2);

    @Message(id=1236, value="The options for index %2$s of collection %1$s are not a valid JSON object.")
    public HibernateException invalidOptionsFormatForIndex(String var1, String var2, @Cause Exception var3);

    @Message(id=1237, value="Invalid GeoJSON type %1$s. Expecting %2$s.")
    public HibernateException invalidGeoJsonType(String var1, String var2);
}

